/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.driver;

import fr.univ_orleans.jdl.agc.I_Collision;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Run;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_Run_Writer;
import fr.univ_orleans.jdl.util.File_Util;
import fr.univ_orleans.jdl.util.Rational;
import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import java.util.TreeMap;

public class Driver_Export_Eps
extends Driver_Export_Run_Writer {
    public static final Rational SCALE_POINT_CM = new Rational(28364L, 1000L);
    public static final String COM_STR = "s";
    public static final String EXTENTION_EPS = ".eps";
    private Map<I_Meta_Signal, String> commands;
    private StringWriter part_footer;
    private StringWriter part_geometry;
    private StringWriter part_header;
    private StringWriter part_middle;
    private StringWriter part_newcommands;
    private double width;
    private double height;

    public Driver_Export_Eps(I_Run run) {
        super(run);
        this.reset();
    }

    private void compute_x_min_max() {
        super.compute_maximal_size();
    }

    private void create_footer() {
        this.part_footer = new StringWriter();
        this.part_footer.write("showpage\n");
    }

    private void create_geometry() {
        this.part_geometry = new StringWriter();
        this.part_geometry.write("0 0 translate\n");
        this.part_geometry.write("1 setlinecap\n");
    }

    private void create_head() {
        this.part_header = new StringWriter();
        this.part_header.write("%!PS-Adobe-2.0\n");
        this.part_header.write("%%Orientation: Portrait\n");
        this.part_header.write("%%BoundingBox: 0 0 " + df.format(this.width) + " " + df.format(this.height) + "\n");
    }

    private void create_middle() {
        this.part_middle = new StringWriter();
        super.draw_diagram();
    }

    private void create_new_commands() {
        if (this.part_newcommands == null) {
            this.part_newcommands = new StringWriter();
            int number = this.run.get_signal_machine().get_nbr_meta_signals();
            int length = 2 * (int)(Math.log(number) / Math.log(2.0));
            int i = 0;
            this.commands = new TreeMap<I_Meta_Signal, String>();
            I_Meta_Signal[] i_Meta_SignalArray = this.run.get_signal_machine().get_meta_signals_copy();
            int n = i_Meta_SignalArray.length;
            int n2 = 0;
            while (n2 < n) {
                I_Meta_Signal ms = i_Meta_SignalArray[n2];
                Color c = ms.get_color();
                String psName = COM_STR + i;
                this.commands.put(ms, psName);
                this.part_newcommands.write("/" + psName + " { gsave ");
                if (c != null) {
                    this.part_newcommands.write(String.valueOf(df.format((double)c.getRed() / 255.0)) + " " + df.format((double)c.getGreen() / 255.0) + " " + df.format((double)c.getBlue() / 255.0) + " setrgbcolor");
                } else {
                    this.part_newcommands.write(String.valueOf(this.dashes_for(i, length)) + " setdash");
                }
                this.part_newcommands.write(" moveto lineto stroke grestore } def\n");
                ++i;
                ++n2;
            }
        }
    }

    private void create_rule_head(Rational radius) {
        this.part_header = new StringWriter();
        this.part_header.write("%!PS-Adobe-2.0\n");
        this.part_header.write("%%Orientation: Portrait\n");
        this.part_header.write("%%BoundingBox: 0 0 " + this.translate_rational_to_EPS(this.get_width()) + " " + this.translate_rational_to_EPS(this.get_height()) + "\n");
        this.part_header.write("1 setlinecap\n");
        float circle_x = this.translate_rational_to_EPS(this.translate_pos(radius));
        float circle_y = this.translate_rational_to_EPS(this.translate_date(radius));
        float radius_approx = this.translate_rational_to_EPS(this.get_scale_x().multiply(radius));
        String circle = String.valueOf(circle_x) + " " + circle_y + " " + radius_approx + " 0 360 arc";
        this.part_header.write("gsave\n.5 setlinewidth .6 .6 .6\nsetrgbcolor\n[ 1.0 4.0 ] 1.0 setdash\n" + circle + " stroke\ngrestore\n" + circle + " clip newpath\n");
    }

    private String dashes_for(int value, int length) {
        StringBuilder result = new StringBuilder("[ ");
        int last_bit = 0;
        double curlenght = 0.0;
        int i = 0;
        while (i < length) {
            int newbit = value % 2;
            if (newbit == last_bit) {
                curlenght += 2.0;
            } else {
                result.append(curlenght).append(" ");
                last_bit = newbit;
                curlenght = 2.0;
            }
            value /= 2;
            ++i;
        }
        return result + " ] " + curlenght;
    }

    @Override
    protected void draw_collision(I_Collision collision, Rational x, Rational y) {
        this.part_middle.write(String.valueOf(df.format(this.translate_rational_to_EPS(x))) + " " + df.format(this.translate_rational_to_EPS(y)) + " 1.5 0 360 arc fill\n");
    }

    @Override
    protected void draw_signal(I_Meta_Signal ms, Rational from_pos, Rational from_date, Rational to_pos, Rational to_date) {
        this.part_middle.write(String.valueOf(df.format(this.translate_rational_to_EPS(from_pos))) + " " + df.format(this.translate_rational_to_EPS(from_date)) + " " + df.format(this.translate_rational_to_EPS(to_pos)) + " " + df.format(this.translate_rational_to_EPS(to_date)) + " " + this.commands.get(ms) + "\n");
    }

    @Override
    public void reset() {
        super.reset();
        this.part_geometry = new StringWriter();
        this.set_scale(Rational.ONE);
    }

    protected float translate_rational_to_EPS(Rational loc) {
        return (float)loc.multiply(SCALE_POINT_CM).approx();
    }

    @Override
    public void write_diagram(String file_name) throws IOException {
        this.compute_x_min_max();
        this.width = this.translate_rational_to_EPS(this.get_width());
        this.height = this.translate_rational_to_EPS(this.get_height());
        this.create_geometry();
        this.create_head();
        this.create_new_commands();
        this.create_middle();
        this.create_footer();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter fw = new FileWriter(File_Util.ensureSuffix(file_name, EXTENTION_EPS));){
            fw.write(this.part_header.toString());
            fw.write(this.part_newcommands.toString());
            fw.write(this.part_geometry.toString());
            fw.write(this.part_middle.toString());
            fw.write(this.part_footer.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void write_rule(String file_name, I_Meta_Signal[] before) throws IOException {
        this.write_rule(file_name, before, RULE_RADIUS_DEFAULT);
    }

    @Override
    public void write_rule(String file_name, I_Meta_Signal[] before, Rational radius) throws IOException {
        this.set_scale_y(this.get_scale_x());
        Rational radius_2 = radius.multiply(2L);
        this.set_bounds(Rational.ZERO, Rational.ZERO, radius_2, radius_2);
        this.create_new_commands();
        this.part_middle = new StringWriter();
        this.draw_rule(before, radius);
        this.create_rule_head(radius);
        this.create_footer();
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileWriter fw = new FileWriter(File_Util.ensureSuffix(file_name, EXTENTION_EPS));){
            fw.write(this.part_header.toString());
            fw.write(this.part_newcommands.toString());
            fw.write(this.part_middle.toString());
            fw.write(this.part_footer.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

