/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.driver;

import fr.univ_orleans.jdl.agc.I_Collision;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Run;
import fr.univ_orleans.jdl.agc.I_Signal;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_Run;
import fr.univ_orleans.jdl.util.Rational;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class Driver_Export_Graphics2D
extends Driver_Export_Run {
    private final Graphics2D graphics;
    private Rational height_Rat;

    public Driver_Export_Graphics2D(I_Run run, Graphics2D graphics) {
        super(run);
        this.graphics = graphics;
    }

    public void draw() {
        this.compute_maximal_size();
        Rectangle rec = new Rectangle();
        this.graphics.getClipBounds(rec);
        int height = rec.height;
        int width = rec.width;
        Rational width_rat = this.get_width();
        if (width_rat.equals(Rational.ZERO)) {
            this.set_scale(Rational.ONE);
        } else {
            this.set_scale(new Rational((long)width - 1L).divide(this.get_width()));
        }
        this.height_Rat = new Rational(height);
        this.end_time = this.height_Rat.divide(this.get_scale_y());
        this.graphics.setColor(Color.WHITE);
        this.graphics.fillRect(0, 0, width, height);
        for (I_Signal s : this.run.get_finished_signals()) {
            if (s.get_date_start().compareTo(this.end_time) >= 0) continue;
            this.draw_signal(s, Rational.min(s.get_date_end(), this.end_time));
        }
        for (I_Signal s : this.run.get_signals()) {
            if (s.get_date_start().compareTo(this.end_time) >= 0) continue;
            Rational dt = s.is_active() ? this.end_time : Rational.min(s.get_date_end(), this.end_time);
            this.draw_signal(s, dt);
        }
    }

    @Override
    protected void draw_collision(I_Collision collision, Rational x, Rational y) {
    }

    @Override
    protected void draw_signal(I_Meta_Signal meta_signal, Rational from_pos, Rational from_date, Rational to_pos, Rational to_date) {
        int x1 = (int)from_pos.approx();
        int y1 = (int)this.reverse_position_y(from_date).approx();
        int x2 = (int)to_pos.approx();
        int y2 = (int)this.reverse_position_y(to_date).approx();
        this.graphics.setColor(meta_signal.get_color());
        this.graphics.drawLine(x1, y1, x2, y2);
    }

    private Rational reverse_position_y(Rational y) {
        return this.height_Rat.subtract(y);
    }
}

