/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.driver;

import fr.univ_orleans.jdl.agc.I_Run;
import fr.univ_orleans.jdl.agc.I_Signal_Machine;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_LaTeX_Pic_Only;
import java.io.IOException;
import java.io.StringWriter;

public class Driver_Export_LaTeX
extends Driver_Export_LaTeX_Pic_Only {
    private static final String _UNIT_DEFAULT = "1em";
    private String unit = "1em";
    private StringWriter header = new StringWriter();
    private StringWriter inputs = new StringWriter();
    private StringWriter packages;
    private StringWriter picture_after;
    private StringWriter picture_before;

    public Driver_Export_LaTeX(I_Run run) {
        super(run);
    }

    public Driver_Export_LaTeX(I_Signal_Machine mach) {
        this(mach.create_configuration().run());
    }

    public void add_header(String string) {
        this.header.write(String.valueOf(string) + "\n");
    }

    public void add_input(String input_name) {
        this.inputs.write("\\input{" + input_name + "}\n");
    }

    public void add_package(String package_name) {
        this.packages.write("\\usepackage{" + package_name + "}\n");
    }

    public void add_package(String package_name, String options) {
        this.packages.write("\\usepackage[" + options + "]{" + package_name + "}\n");
    }

    public void add_picture_after(String text) {
        this.picture_after.write(String.valueOf(text) + "\n");
    }

    public void add_picture_before(String text) {
        this.picture_before.write(String.valueOf(text) + "\n");
    }

    @Override
    public void reset() {
        super.reset();
        this.header = new StringWriter();
        this.inputs = new StringWriter();
        this.packages = new StringWriter();
        this.picture_before = new StringWriter();
        this.picture_after = new StringWriter();
        this.unit = _UNIT_DEFAULT;
    }

    public void set_unit(String unit) {
        this.unit = unit;
    }

    @Override
    protected void write_diagram() throws IOException {
        this.latex_p_w.should_compile_alone();
        this.latex_p_w.print(this.packages.toString());
        this.latex_p_w.print(this.inputs.toString());
        this.print_new_commands();
        this.latex_p_w.print(this.header.toString());
        this.latex_p_w.print("\n\n\\begin{document}\n\n");
        this.latex_p_w.print(this.picture_before.toString());
        this.latex_p_w.println("\\setlength{\\unitlength}{" + this.unit + "}\n");
        this.write_diagram_picture();
        this.latex_p_w.print(this.picture_after.toString());
        this.latex_p_w.close();
    }
}

