/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.driver;

import fr.univ_orleans.jdl.agc.I_Collision;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Run;
import fr.univ_orleans.jdl.agc.I_Signal_Machine;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_Run_Writer;
import fr.univ_orleans.jdl.agc.driver.I_Driver_Latex_Command_Customizer;
import fr.univ_orleans.jdl.agc.driver.LaTeX_Print_writer;
import fr.univ_orleans.jdl.util.Rational;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Driver_Export_LaTeX_Pic_Only
extends Driver_Export_Run_Writer {
    public static final String LATEX_COLOR_PREFIX = "ColorGENERATED";
    public static final String LATEX_SIG_PREFIX = "\\DrawSigGENERATED";
    private static final Pattern PATTERN_LATEX_COMMAND = Pattern.compile("\\\\[a-zA-Z]+");
    public static final String PREFERENCE_KW_LATEX_COMMAND = "latex_command";
    private static final double RELATIVE_SCALE_X_DEFAULT = 1.0;
    private I_Driver_Latex_Command_Customizer command_customizer;
    protected LaTeX_Print_writer latex_p_w;
    private StringWriter newcommands;
    private StringWriter picture_head;
    private StringWriter picture_tail;
    private double relative_scale_x = 1.0;
    private final Map<I_Meta_Signal, String> signal_to_latex_cmd = new HashMap<I_Meta_Signal, String>();

    public Driver_Export_LaTeX_Pic_Only(I_Run run) {
        super(run);
        this.create_signal_names_and_commands();
    }

    public Driver_Export_LaTeX_Pic_Only(I_Signal_Machine mach) {
        this(mach.create_configuration().run());
    }

    public void add_picture_head(String text) {
        this.picture_head.write(String.valueOf(text) + "\n");
    }

    public void add_picture_tail(String text) {
        this.picture_tail.write(String.valueOf(text) + "\n");
    }

    private void create_signal_names_and_commands() {
        int i = 0;
        this.newcommands = new StringWriter();
        Iterable iterable = this.run.get_signal_machine().get_meta_signal_stream()::iterator;
        for (I_Meta_Signal ms : iterable) {
            String latex_cmd;
            Object prop_latex_cmd = ms.get_property(PREFERENCE_KW_LATEX_COMMAND);
            if (prop_latex_cmd != null) {
                latex_cmd = prop_latex_cmd.toString();
            } else {
                String latex_suffix = Integer.toBinaryString(i).replace('0', 'a').replace('1', 'B');
                latex_cmd = LATEX_SIG_PREFIX + latex_suffix;
                Color c = ms.get_color();
                String color = "black";
                if (c != null) {
                    color = LATEX_COLOR_PREFIX + latex_suffix;
                    this.newcommands.write("\\definecolor{" + color + "}{rgb}{" + (double)c.getRed() / 255.0 + "," + (double)c.getGreen() / 255.0 + "," + (double)c.getBlue() / 255.0 + "}\n");
                }
                StringBuilder line_style = new StringBuilder();
                Object ls = ms.get_property("line_style");
                if (ls instanceof String) {
                    line_style.append((String)ls);
                }
                this.newcommands.write("\\def\\" + latex_cmd.substring(1) + "(#1)(#2){ \\draw[" + color + line_style + "] (#1) -- (#2) ;}  % " + ms.get_id() + "\n");
                ++i;
            }
            this.signal_to_latex_cmd.put(ms, latex_cmd);
        }
    }

    @Override
    protected void draw_collision(I_Collision collision, Rational x, Rational y) {
    }

    @Override
    protected void draw_signal(I_Meta_Signal ms, Rational from_pos, Rational from_to, Rational to_pos, Rational to_date) {
        double x1 = from_pos.approx();
        double y1 = from_to.approx();
        double x2 = to_pos.approx();
        double y2 = to_date.approx();
        if (x2 < x1) {
            double tmp = x1;
            x1 = x2;
            x2 = tmp;
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        String cmd = this.signal_to_latex_cmd.get(ms);
        this.latex_p_w.print(String.valueOf(this.command_customizer == null ? cmd : this.command_customizer.select_command(ms, cmd, x1, y1, x2, y2)) + "(" + df.format(x1) + "," + df.format(y1) + ")(" + df.format(x2) + "," + df.format(y2) + ")\n");
    }

    public I_Driver_Latex_Command_Customizer get_command_customizer() {
        return this.command_customizer;
    }

    void print_new_commands() {
        this.latex_p_w.print(this.newcommands.toString());
    }

    @Override
    public void reset() {
        super.reset();
        this.picture_head = new StringWriter();
        this.picture_tail = new StringWriter();
    }

    public void set_command_customizer(I_Driver_Latex_Command_Customizer command_customizer) {
        this.command_customizer = command_customizer;
    }

    public void set_relative_scale_x(double relative_scale_x) {
        this.relative_scale_x = relative_scale_x;
    }

    public void set_signal_latex_cmd(I_Meta_Signal meta, String latex_command) {
        if (latex_command == null || !PATTERN_LATEX_COMMAND.matcher(latex_command).matches()) {
            throw new IllegalArgumentException("Not a legal latex cmd " + latex_command);
        }
        this.signal_to_latex_cmd.put(meta, latex_command);
    }

    protected void write_diagram() throws IOException {
        this.print_new_commands();
        this.write_diagram_picture();
        this.latex_p_w.close();
    }

    @Override
    public void write_diagram(OutputStream out_stream) throws IOException {
        this.latex_p_w = new LaTeX_Print_writer(out_stream);
        this.write_diagram();
    }

    @Override
    public void write_diagram(String file_name) throws IOException {
        this.latex_p_w = new LaTeX_Print_writer(file_name);
        this.write_diagram();
    }

    protected void write_diagram_picture() {
        this.latex_p_w.println("\\begin{tikzpicture}[x=" + this.relative_scale_x + "\\unitlength,y=\\unitlength]");
        this.latex_p_w.print(this.picture_head.toString());
        this.draw_diagram();
        this.latex_p_w.print(this.picture_tail.toString());
        this.latex_p_w.print("\\end{tikzpicture}");
    }
}

