/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.driver;

import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Signal_Machine;
import fr.univ_orleans.jdl.agc.exception.E_No_Such_Rule_Exception;
import fr.univ_orleans.jdl.agc.util.Util_Meta_Signal;
import fr.univ_orleans.jdl.util.Rational;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public abstract class Driver_Export_Machine {
    public static final Rational RULE_RADIUS_DEFAULT = new Rational(40L);
    public static final DecimalFormat df = new DecimalFormat("###.###");
    private final I_Signal_Machine signal_machine;

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
    }

    public static String ensureSuffix(String string_base, String suffix) {
        return string_base.endsWith(suffix) ? string_base : String.valueOf(string_base) + suffix;
    }

    protected Driver_Export_Machine(I_Signal_Machine signal_machine) {
        this.signal_machine = signal_machine;
    }

    private void draw_rule(I_Meta_Signal ms_ray, Rational radius, int sign) {
        switch (ms_ray.get_speed().signum()) {
            case 1: {
                this.draw_signal(ms_ray, radius, radius, radius.multiply(Rational.ONE.add(Rational.min(Rational.ONE, ms_ray.get_speed()).multiply(sign))), radius.multiply(Rational.ONE.add(Rational.min(Rational.ONE, ms_ray.get_speed().inverse()).multiply(sign))));
                break;
            }
            case -1: {
                this.draw_signal(ms_ray, radius, radius, radius.multiply(Rational.ONE.add(Rational.max(Rational.MINUS_ONE, ms_ray.get_speed()).multiply(sign))), radius.multiply(Rational.ONE.add(Rational.max(Rational.MINUS_ONE, ms_ray.get_speed().inverse()).multiply(-sign))));
                break;
            }
            default: {
                this.draw_signal(ms_ray, radius, radius, radius, radius.multiply(sign));
            }
        }
    }

    protected void draw_rule(I_Meta_Signal[] in_coming_ms) {
        this.draw_rule(in_coming_ms, RULE_RADIUS_DEFAULT);
    }

    protected void draw_rule(I_Meta_Signal[] in_coming_ms, Rational radius) {
        I_Meta_Signal ms;
        I_Meta_Signal[] after = this.signal_machine.get_collision_rule_output(in_coming_ms);
        if (after == null) {
            throw new E_No_Such_Rule_Exception(Util_Meta_Signal.to_string(in_coming_ms));
        }
        I_Meta_Signal[] i_Meta_SignalArray = in_coming_ms;
        int n = in_coming_ms.length;
        int n2 = 0;
        while (n2 < n) {
            ms = i_Meta_SignalArray[n2];
            this.draw_rule(ms, radius, -1);
            ++n2;
        }
        i_Meta_SignalArray = after;
        n = after.length;
        n2 = 0;
        while (n2 < n) {
            ms = i_Meta_SignalArray[n2];
            this.draw_rule(ms, radius, 1);
            ++n2;
        }
    }

    protected abstract void draw_signal(I_Meta_Signal var1, Rational var2, Rational var3, Rational var4, Rational var5);

    public I_Signal_Machine get_signal_machine() {
        return this.signal_machine;
    }
}

