/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.driver;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import fr.univ_orleans.jdl.agc.I_Collision;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Run;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_Run_Writer;
import fr.univ_orleans.jdl.util.File_Util;
import fr.univ_orleans.jdl.util.Rational;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;

public class Driver_Export_Pdf
extends Driver_Export_Run_Writer {
    public static final String EXTENTION_PDF = ".pdf";
    private static final float[] PDF_SOLID = new float[0];
    private static final float[] PDF_DASH_DENSE = new float[]{35.0f, 25.0f};
    private static final float[] PDF_DASH = new float[]{20.0f, 20.0f};
    private static final float[] PDF_DASH_LOOSELY = new float[]{20.0f, 5.0f};
    private static final float[] PDF_DOT_DENSE = new float[]{2.0f, 5.0f};
    private static final float[] PDF_DOT = new float[]{2.0f, 10.0f};
    private static final float[] PDF_DOT_LOOSELY = new float[]{2.0f, 20.0f};
    public static final BaseColor RULE_CIRCLE_COLOR = new BaseColor(Color.GRAY);
    public static final Rational SCALE_POINT_CM = new Rational(7200L, 254L);
    private PdfContentByte pdf_content;

    public Driver_Export_Pdf(I_Run signal_machine_run) {
        super(signal_machine_run);
    }

    @Override
    protected void draw_collision(I_Collision collision, Rational x, Rational y) {
        this.pdf_content.saveState();
        this.pdf_content.circle(this.translate_rational_to_PDF(x), this.translate_rational_to_PDF(y), 1.5f);
        this.pdf_content.fillStroke();
        this.pdf_content.restoreState();
    }

    @Override
    protected void draw_signal(I_Meta_Signal meta_signal, Rational from_pos, Rational from_date, Rational to_pos, Rational to_date) {
        this.pdf_content.setColorStroke(new BaseColor(meta_signal.get_color()));
        Object o = meta_signal.get_property("line_style");
        float[] dash_array = PDF_SOLID;
        if (o instanceof String) {
            String s = (String)o;
            if (s.equals("dashed")) {
                dash_array = PDF_DASH;
            } else if (s.equals("densely dashed")) {
                dash_array = PDF_DASH_DENSE;
            } else if (s.equals("loosely dashed")) {
                dash_array = PDF_DASH_LOOSELY;
            } else if (s.equals("dotted")) {
                dash_array = PDF_DOT;
            } else if (s.equals("densely dotted")) {
                dash_array = PDF_DOT_DENSE;
            } else if (s.equals("loosely dotted")) {
                dash_array = PDF_DOT_LOOSELY;
            }
        }
        float from_x = this.translate_rational_to_PDF(from_pos);
        float from_y = this.translate_rational_to_PDF(from_date);
        float to_x = this.translate_rational_to_PDF(to_pos);
        float to_y = this.translate_rational_to_PDF(to_date);
        float x_0 = from_x + (from_x - to_x) / (from_y - to_y) * from_y;
        float phase = (float)Math.sqrt((x_0 - from_x) * (x_0 - from_x) + from_y * from_y);
        this.pdf_content.setLineDash(dash_array, phase);
        this.pdf_content.moveTo(from_x, from_y);
        this.pdf_content.lineTo(to_x, to_y);
        this.pdf_content.stroke();
    }

    protected float translate_rational_to_PDF(Rational loc) {
        return (float)loc.multiply(SCALE_POINT_CM).approx();
    }

    @Override
    public void write_diagram(String file_name) throws IOException, DocumentException {
        this.compute_maximal_size();
        Document document = new Document(new Rectangle(this.translate_rational_to_PDF(this.get_width()), this.translate_rational_to_PDF(this.get_height())));
        PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(File_Util.ensureSuffix(file_name, EXTENTION_PDF)));
        document.open();
        this.pdf_content = writer.getDirectContent();
        this.draw_diagram();
        document.close();
    }

    public void write_rule(String file_name, I_Meta_Signal[] before) throws IOException, DocumentException {
        this.write_rule(file_name, before, RULE_RADIUS_DEFAULT);
    }

    @Override
    public void write_rule(String file_name, I_Meta_Signal[] before, Rational radius) throws IOException, DocumentException {
        this.set_scale_y(this.get_scale_x());
        Rational radius_2 = radius.multiply(2L);
        this.set_bounds(Rational.ZERO, Rational.ZERO, radius_2, radius_2);
        float radius_approx = this.translate_rational_to_PDF(this.get_scale_x().multiply(radius));
        Document document = new Document(new Rectangle(this.translate_rational_to_PDF(this.get_width()), this.translate_rational_to_PDF(this.get_height())));
        PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(File_Util.ensureSuffix(file_name, EXTENTION_PDF)));
        document.open();
        this.pdf_content = writer.getDirectContent();
        float circle_x = radius_approx;
        float circle_y = radius_approx;
        this.pdf_content.circle(circle_x, circle_y, radius_approx);
        this.pdf_content.clip();
        this.pdf_content.newPath();
        this.draw_rule(before, radius);
        this.pdf_content.setLineDash(4.0f, 1.0f);
        this.pdf_content.setColorStroke(RULE_CIRCLE_COLOR);
        this.pdf_content.circle(circle_x, circle_y, radius_approx);
        this.pdf_content.stroke();
        document.close();
    }
}

