/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.driver;

import fr.univ_orleans.jdl.agc.I_Collision;
import fr.univ_orleans.jdl.agc.I_Run;
import fr.univ_orleans.jdl.agc.I_Signal;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_Signal_Machine;
import fr.univ_orleans.jdl.util.Rational;

public abstract class Driver_Export_Run
extends Driver_Export_Signal_Machine {
    public static final Rational DURATION_NO_COLLISION_DEFAULT = new Rational(3L);
    public static final Rational RELATIVE_DURATION_ADDED_NO_MORE_COLLISION_DEFAULT = new Rational(1L, 10L);
    public static final Rational DURATION_RELATIVE_NEXT_FORECASTED_COLLISION_DEFAULT = new Rational(1L, 2L);
    private Draw_Collisions draw_collisions = Draw_Collisions.NOT;
    private Rational added_duration_no_collision = DURATION_NO_COLLISION_DEFAULT;
    protected Rational end_time;
    private boolean is_end_time_fixed = false;
    private Rational added_relative_duration_no_collision = RELATIVE_DURATION_ADDED_NO_MORE_COLLISION_DEFAULT;
    protected final I_Run run;
    private Rational added_relative_duration_forecasted_collision = DURATION_RELATIVE_NEXT_FORECASTED_COLLISION_DEFAULT;

    protected Driver_Export_Run(I_Run run) {
        super(run.get_signal_machine());
        this.run = run;
        this.reset();
    }

    private void compute_end_time() {
        if (!this.is_end_time_fixed) {
            if (this.run.has_collision()) {
                this.end_time = this.run.get_date();
                this.end_time = this.end_time.add(this.run.get_next_collision_date().subtract(this.end_time).multiply(this.added_relative_duration_forecasted_collision));
            } else {
                this.end_time = this.run.get_date().equals(Rational.ZERO) ? this.added_duration_no_collision : this.run.get_date().multiply(Rational.ONE.add(this.added_relative_duration_no_collision));
            }
        }
    }

    protected void compute_maximal_size() {
        Rational date_first = this.run.get_initial_configuration().get_date();
        this.compute_end_time();
        Rational date_last = this.end_time;
        for (I_Signal s : this.run.get_finished_signals()) {
            if (s.get_date_end().compareTo(this.end_time) > 0) continue;
            this.update_X_Min_Max(s, Rational.min(s.get_date_end(), this.end_time));
        }
        for (I_Signal s : this.run.get_signals()) {
            if (s.get_date_start().compareTo(this.end_time) > 0) continue;
            Rational date = s.is_active() ? this.end_time : Rational.min(s.get_date_end(), this.end_time);
            this.update_X_Min_Max(s, date);
        }
        this.set_bounds(this.get_pos_min(), date_first, this.get_pos_max(), date_last);
    }

    protected abstract void draw_collision(I_Collision var1, Rational var2, Rational var3);

    protected void draw_diagram() {
        this.compute_maximal_size();
        if (this.draw_collisions == Draw_Collisions.BEFORE) {
            this.draw_diagram_collisions();
        }
        this.draw_diagram_signals();
        if (this.draw_collisions == Draw_Collisions.AFTER) {
            this.draw_diagram_collisions();
        }
    }

    private void draw_diagram_collisions() {
        for (I_Signal s : this.run.get_finished_signals()) {
            this.try_to_draw_collision(s.get_collision_end());
        }
        for (I_Signal s : this.run.get_signals()) {
            this.try_to_draw_collision(s.get_collision_end());
        }
    }

    private void draw_diagram_signals() {
        for (I_Signal s : this.run.get_finished_signals()) {
            if (s.get_date_start().compareTo(this.end_time) >= 0) continue;
            this.draw_signal(s, Rational.min(s.get_date_end(), this.end_time));
        }
        for (I_Signal s : this.run.get_signals()) {
            if (s.get_date_start().compareTo(this.end_time) >= 0) continue;
            Rational dt = s.is_active() ? this.end_time : Rational.min(s.get_date_end(), this.end_time);
            this.draw_signal(s, dt);
        }
    }

    public Rational get_added_duration_no_collision() {
        return this.added_duration_no_collision;
    }

    public Rational get_added_duration_relative_forecasted_collision() {
        return this.added_relative_duration_forecasted_collision;
    }

    public Rational get_added_relative_duration_no_collision() {
        return this.added_relative_duration_no_collision;
    }

    public Draw_Collisions get_draw_collisions() {
        return this.draw_collisions;
    }

    public Rational get_end_time() {
        this.compute_end_time();
        return this.end_time;
    }

    public boolean is_end_time_fixed() {
        return this.is_end_time_fixed;
    }

    @Override
    public void reset() {
        this.is_end_time_fixed = false;
        this.added_duration_no_collision = DURATION_NO_COLLISION_DEFAULT;
        this.added_relative_duration_no_collision = RELATIVE_DURATION_ADDED_NO_MORE_COLLISION_DEFAULT;
        super.reset();
    }

    public void set_added_duration_no_collision(Rational added_duration_no_collision) {
        this.added_duration_no_collision = added_duration_no_collision;
    }

    public void set_added_relative_duration_forecasted_collision(Rational added_relative_duration_forecasted_collision) {
        if (added_relative_duration_forecasted_collision.compareTo(Rational.ONE) >= 0 || added_relative_duration_forecasted_collision.compareTo(Rational.ZERO) <= 0) {
            throw new IllegalArgumentException("duration_relative_forecasted_collision should be 0 <= .. <= 1, found " + added_relative_duration_forecasted_collision);
        }
        this.added_relative_duration_forecasted_collision = added_relative_duration_forecasted_collision;
    }

    public void set_added_relative_duration_no_collision(Rational added_relative_duration_no_collision) {
        this.added_relative_duration_no_collision = added_relative_duration_no_collision;
    }

    public void set_draw_collisions(Draw_Collisions draw_collisions) {
        this.draw_collisions = draw_collisions;
    }

    public void set_end_time(Rational end_time) {
        if (end_time.subtract(this.run.get_initial_configuration().get_date()).signum() <= 0) {
            throw new IllegalArgumentException("end_time must be after the initial time ! " + end_time);
        }
        this.is_end_time_fixed = true;
        this.end_time = end_time;
    }

    private void try_to_draw_collision(I_Collision collision) {
        if (collision == null) {
            return;
        }
        if (this.is_in_clipping(collision.get_position(), collision.get_date())) {
            return;
        }
        this.draw_collision(collision, this.translate_pos(collision.get_position()), this.translate_date(collision.get_date()));
    }

    public void unset_end_time() {
        if (this.is_end_time_fixed) {
            this.is_end_time_fixed = false;
            this.compute_end_time();
        }
    }

    private void update_X_Min_Max(I_Signal s, Rational date) {
        this.update_X_Min_Max(s.get_position_start());
        this.update_X_Min_Max(s.get_position_at(date));
    }

    public static enum Draw_Collisions {
        AFTER,
        BEFORE,
        NOT;

    }
}

