/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.driver;

import fr.univ_orleans.jdl.agc.I_Collision;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Run;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_Run_Writer;
import fr.univ_orleans.jdl.util.File_Util;
import fr.univ_orleans.jdl.util.Rational;
import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.TreeMap;

public class Driver_Export_SVG
extends Driver_Export_Run_Writer {
    public static final String COM_STR = "s";
    public static final String EXTENTION_SVG = ".svg";
    private Map<I_Meta_Signal, String> style;
    private StringWriter part_footer;
    private StringWriter part_header;
    private StringWriter part_middle;
    private StringWriter part_newStyle;
    private double width;
    private double height;

    public Driver_Export_SVG(I_Run run) {
        super(run);
        this.reset();
    }

    private void compute_x_min_max() {
        super.compute_maximal_size();
    }

    private void create_footer() {
        this.part_footer = new StringWriter();
        this.part_footer.write("</svg>\n");
    }

    private void create_head() {
        this.create_head(this.width, this.height);
    }

    private void create_head(double width, double height) {
        this.part_header = new StringWriter();
        this.part_header.write("<svg width=\"" + df.format(width) + "\" height=\"" + df.format(height) + "\" xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\">" + "\n");
    }

    private void create_middle() {
        this.part_middle = new StringWriter();
        super.draw_diagram();
    }

    private void create_rule_head(double radius) {
        this.create_head(radius, radius);
    }

    private void create_style() {
        if (this.part_newStyle == null) {
            this.part_newStyle = new StringWriter();
            int i = 0;
            this.style = new TreeMap<I_Meta_Signal, String>();
            this.part_newStyle.write("<style type=\"text/css\"><![CDATA[");
            I_Meta_Signal[] i_Meta_SignalArray = this.run.get_signal_machine().get_meta_signals_copy();
            int n = i_Meta_SignalArray.length;
            int n2 = 0;
            while (n2 < n) {
                I_Meta_Signal ms = i_Meta_SignalArray[n2];
                Color c = ms.get_color();
                String className = COM_STR + i;
                this.style.put(ms, className);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.format("%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
                this.part_newStyle.write("  ." + className + " { fill:none; stroke:" + "#" + sw.toString() + "; stroke-width:" + 1 + " } \n");
                ++i;
                ++n2;
            }
            this.part_newStyle.write("]]></style>");
        }
    }

    @Override
    protected void draw_collision(I_Collision collision, Rational x, Rational y) {
    }

    @Override
    protected void draw_signal(I_Meta_Signal ms, Rational from_pos, Rational from_date, Rational to_pos, Rational to_date) {
        this.part_middle.write("<path d=\" M " + df.format(this.translate_rational_to_SVG(from_pos)) + " " + df.format(this.height - (double)this.translate_rational_to_SVG(from_date)) + " L " + df.format(this.translate_rational_to_SVG(to_pos)) + " " + df.format(this.height - (double)this.translate_rational_to_SVG(to_date)) + "\" class=\"" + this.style.get(ms) + "\"" + "/>\n");
    }

    @Override
    public void reset() {
        super.reset();
        this.set_scale(Rational.ONE);
    }

    protected float translate_rational_to_SVG(Rational loc) {
        return (float)loc.approx();
    }

    @Override
    public void write_diagram(String file_name) throws IOException {
        this.compute_x_min_max();
        this.width = this.translate_rational_to_SVG(this.get_width());
        this.height = this.translate_rational_to_SVG(this.get_height());
        this.create_head();
        this.create_style();
        this.create_middle();
        this.create_footer();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter fw = new FileWriter(File_Util.ensureSuffix(file_name, EXTENTION_SVG));){
            fw.write(this.part_header.toString());
            fw.write(this.part_newStyle.toString());
            fw.write(this.part_middle.toString());
            fw.write(this.part_footer.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void write_rule(String file_name, I_Meta_Signal[] before) throws IOException {
        this.write_rule(file_name, before, RULE_RADIUS_DEFAULT);
    }

    @Override
    public void write_rule(String file_name, I_Meta_Signal[] before, Rational radius) throws IOException {
        this.set_scale_y(this.get_scale_x());
        Rational radius_2 = radius.multiply(2L);
        this.set_bounds(Rational.ZERO, Rational.ZERO, radius_2, radius_2);
        this.reset();
        double rad_d = this.translate_rational_to_SVG(radius);
        this.create_rule_head(2.0 * rad_d);
        this.width = this.height = 2.0 * rad_d;
        this.create_style();
        this.part_middle = new StringWriter();
        this.draw_rule(before, radius);
        this.create_footer();
        Throwable throwable = null;
        Object var8_8 = null;
        try (FileWriter fw = new FileWriter(File_Util.ensureSuffix(file_name, EXTENTION_SVG));){
            fw.write(this.part_header.toString());
            fw.write(this.part_newStyle.toString());
            fw.write(this.part_middle.toString());
            fw.write(this.part_footer.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

