/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.driver;

import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Signal;
import fr.univ_orleans.jdl.agc.I_Signal_Machine;
import fr.univ_orleans.jdl.agc.exception.E_No_Such_Rule_Exception;
import fr.univ_orleans.jdl.agc.util.Util_Meta_Signal;
import fr.univ_orleans.jdl.util.Rational;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public abstract class Driver_Export_Signal_Machine {
    public static final String MS_PROPERTY_LINE_STYLE = "line_style";
    public static final String MS_PROPERTY_LINE_STYLE_VALUE_SOLID = "solid";
    public static final String MS_PROPERTY_LINE_STYLE_VALUE_DASHED_DENSELY = "densely dashed";
    public static final String MS_PROPERTY_LINE_STYLE_VALUE_DASHED = "dashed";
    public static final String MS_PROPERTY_LINE_STYLE_VALUE_DASHED_LOOSELY = "loosely dashed";
    public static final String MS_PROPERTY_LINE_STYLE_VALUE_DOTTED_DENSELY = "densely dotted";
    public static final String MS_PROPERTY_LINE_STYLE_VALUE_DOTTED = "dotted";
    public static final String MS_PROPERTY_LINE_STYLE_VALUE_DOTTED_LOOSELY = "loosely dotted";
    public static final DecimalFormat df = new DecimalFormat("###.###");
    public static final Rational RULE_RADIUS_DEFAULT = new Rational(40L);
    private Rational clipping_end;
    private Rational clipping_left;
    private Rational clipping_right;
    private Rational clipping_start;
    private Rational pos_min = Rational.PLUS_INFINITY;
    private Rational pos_max = Rational.MINUS_INFINITY;
    private Rational date_first = Rational.ZERO;
    private Rational date_last = Rational.ONE;
    private Rational scale_x = Rational.ONE;
    private Rational scale_y = Rational.ONE;
    private final I_Signal_Machine signal_machine;
    public static final Rational HALF_BACKUP_WIDTH;
    public static final Rational HALF_BACKUP_DELAY;

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        HALF_BACKUP_WIDTH = new Rational(1L, 2L);
        HALF_BACKUP_DELAY = new Rational(1L, 2L);
    }

    protected Driver_Export_Signal_Machine(I_Signal_Machine signal_machine) {
        this.signal_machine = signal_machine;
    }

    private Rational compute_intersect_date(Rational x, Rational x1, Rational y1, Rational x2, Rational y2) {
        assert (x1.compareTo(x) < 0 && x.compareTo(x2) < 0 || x2.compareTo(x) < 0 && x.compareTo(x1) < 0);
        return y1.add(y2.subtract(y1).multiply(x.subtract(x1)).divide(x2.subtract(x1)));
    }

    private void draw_rule(I_Meta_Signal ms, Rational radius, int sign) {
        switch (ms.get_speed().signum()) {
            case 1: {
                this.draw_signal_untranslated(ms, radius, radius, radius.multiply(Rational.ONE.add(Rational.min(Rational.ONE, ms.get_speed()).multiply(sign))), radius.multiply(Rational.ONE.add(Rational.min(Rational.ONE, ms.get_speed().inverse()).multiply(sign))));
                break;
            }
            case -1: {
                this.draw_signal_untranslated(ms, radius, radius, radius.multiply(Rational.ONE.add(Rational.max(Rational.MINUS_ONE, ms.get_speed()).multiply(sign))), radius.multiply(Rational.ONE.add(Rational.max(Rational.MINUS_ONE, ms.get_speed().inverse()).multiply(-sign))));
                break;
            }
            default: {
                this.draw_signal_untranslated(ms, radius, radius, radius, radius.multiply(sign));
            }
        }
    }

    protected void draw_rule(I_Meta_Signal[] before) {
        this.draw_rule(before, RULE_RADIUS_DEFAULT);
    }

    protected void draw_rule(I_Meta_Signal[] before, Rational radius) {
        I_Meta_Signal ms;
        Rational radius_x_2 = radius.multiply(2L);
        this.set_bounds(Rational.ZERO, Rational.ZERO, radius_x_2, radius_x_2);
        I_Meta_Signal[] after = this.signal_machine.get_collision_rule_output(before);
        if (after == null) {
            throw new E_No_Such_Rule_Exception(Util_Meta_Signal.to_string(before));
        }
        I_Meta_Signal[] i_Meta_SignalArray = before;
        int n = before.length;
        int n2 = 0;
        while (n2 < n) {
            ms = i_Meta_SignalArray[n2];
            this.draw_rule(ms, radius, -1);
            ++n2;
        }
        i_Meta_SignalArray = after;
        n = after.length;
        n2 = 0;
        while (n2 < n) {
            ms = i_Meta_SignalArray[n2];
            this.draw_rule(ms, radius, 1);
            ++n2;
        }
    }

    protected abstract void draw_signal(I_Meta_Signal var1, Rational var2, Rational var3, Rational var4, Rational var5);

    protected void draw_signal(I_Signal s, Rational end_date) {
        Rational end_date_final;
        Rational start_date = this.get_clipping_start() == null ? s.get_date_start() : Rational.max(this.get_clipping_start(), s.get_date_start());
        Rational rational = end_date_final = this.get_clipping_end() == null ? end_date : Rational.min(this.get_clipping_end(), end_date);
        if (end_date_final.compareTo(start_date) <= 0) {
            return;
        }
        Rational start_pos = s.get_position_at(start_date);
        Rational end_pos = s.get_position_at(end_date_final);
        Rational speed = s.get_meta_signal().get_speed();
        if (speed.signum() == 0) {
            if (this.clipping_right != null && this.clipping_right.compareTo(start_pos) < 0 || this.clipping_left != null && start_pos.compareTo(this.clipping_left) < 0) {
                return;
            }
        } else {
            boolean is_positive_speed;
            boolean bl = is_positive_speed = speed.signum() > 0;
            if (this.clipping_right != null) {
                if (is_positive_speed) {
                    if (this.clipping_right.compareTo(start_pos) < 0) {
                        return;
                    }
                    if (this.clipping_right.compareTo(end_pos) < 0) {
                        end_date_final = this.compute_intersect_date(this.clipping_right, start_pos, start_date, end_pos, end_date_final);
                        end_pos = s.get_position_at(end_date_final);
                    }
                } else {
                    if (this.clipping_right.compareTo(end_pos) < 0) {
                        return;
                    }
                    if (this.clipping_right.compareTo(start_pos) < 0) {
                        start_date = this.compute_intersect_date(this.clipping_right, start_pos, start_date, end_pos, end_date_final);
                        start_pos = s.get_position_at(start_date);
                    }
                }
            }
            if (this.clipping_left != null) {
                if (is_positive_speed) {
                    if (end_pos.compareTo(this.clipping_left) < 0) {
                        return;
                    }
                    if (start_pos.compareTo(this.clipping_left) < 0) {
                        start_date = this.compute_intersect_date(this.clipping_left, start_pos, start_date, end_pos, end_date_final);
                        start_pos = s.get_position_at(start_date);
                    }
                } else {
                    if (start_pos.compareTo(this.clipping_left) < 0) {
                        return;
                    }
                    if (end_pos.compareTo(this.clipping_left) < 0) {
                        end_date_final = this.compute_intersect_date(this.clipping_left, start_pos, start_date, end_pos, end_date_final);
                        end_pos = s.get_position_at(end_date_final);
                    }
                }
            }
        }
        this.draw_signal_untranslated(s.get_meta_signal(), start_pos, start_date, end_pos, end_date_final);
    }

    protected void draw_signal_untranslated(I_Meta_Signal m_s, Rational from_pos, Rational from_date, Rational to_pos, Rational to_date) {
        this.draw_signal(m_s, this.translate_pos(from_pos), this.translate_date(from_date), this.translate_pos(to_pos), this.translate_date(to_date));
    }

    public Rational get_clipping_end() {
        return this.clipping_end;
    }

    public Rational get_clipping_left() {
        return this.clipping_left;
    }

    public Rational get_clipping_right() {
        return this.clipping_right;
    }

    public Rational get_clipping_start() {
        return this.clipping_start;
    }

    public Rational get_date_first() {
        return this.date_first;
    }

    public Rational get_date_last() {
        return this.date_last;
    }

    public Rational get_height() {
        return this.translate_date(this.date_last);
    }

    public Rational get_pos_max() {
        return this.pos_max;
    }

    public Rational get_pos_min() {
        return this.pos_min;
    }

    public Rational get_scale_x() {
        return this.scale_x;
    }

    public Rational get_scale_y() {
        return this.scale_y;
    }

    public I_Signal_Machine get_signal_machine() {
        return this.signal_machine;
    }

    public Rational get_width() {
        return this.translate_pos(this.pos_max);
    }

    boolean is_in_clipping(Rational position, Rational date) {
        return !(this.clipping_start != null && this.clipping_start.compareTo(date) > 0 || this.clipping_end != null && date.compareTo(this.clipping_end) > 0 || this.clipping_left != null && this.clipping_left.compareTo(position) > 0 || this.clipping_right != null && position.compareTo(this.clipping_right) > 0);
    }

    public void reset() {
        this.unset_clippping();
        this.set_scale(Rational.ONE);
    }

    protected void set_bounds(Rational pos_min, Rational date_first, Rational pos_max, Rational date_last) {
        this.pos_min = this.clipping_left != null && pos_min.compareTo(this.clipping_left) < 0 ? this.clipping_left : pos_min;
        Rational rational = this.date_first = this.clipping_start != null && date_first.compareTo(this.clipping_start) < 0 ? this.clipping_start : date_first;
        if (pos_min.equals(pos_max)) {
            this.pos_min = pos_min.subtract(HALF_BACKUP_WIDTH);
            this.pos_max = pos_max.add(HALF_BACKUP_WIDTH);
        }
        this.pos_max = this.clipping_right != null && this.clipping_right.compareTo(pos_max) < 0 ? this.clipping_right : pos_max;
        Rational rational2 = this.date_last = this.clipping_end != null && this.clipping_end.compareTo(date_last) < 0 ? this.clipping_end : date_last;
        if (date_last.equals(date_first)) {
            this.pos_min = pos_min.subtract(HALF_BACKUP_DELAY);
            this.pos_max = pos_max.add(HALF_BACKUP_DELAY);
        }
    }

    public void set_clipping(Rational clipping_left, Rational clipping_start, Rational clipping_right, Rational clipping_end) {
        this.clipping_left = clipping_left;
        this.clipping_start = clipping_start;
        this.clipping_right = clipping_right;
        this.clipping_end = clipping_end;
    }

    public void set_clipping_end(Rational clipping_end) {
        this.clipping_end = clipping_end;
    }

    public void set_clipping_left(Rational clipping_left) {
        this.clipping_left = clipping_left;
    }

    public void set_clipping_right(Rational clipping_right) {
        this.clipping_right = clipping_right;
    }

    public void set_clipping_start(Rational clipping_start) {
        this.clipping_start = clipping_start;
    }

    public void set_scale(int scale) {
        this.set_scale(new Rational(scale));
    }

    public void set_scale(int scale_p, int scale_q) {
        this.set_scale(new Rational(scale_p, scale_q));
    }

    public void set_scale(Rational scale) {
        this.set_scale_x(scale);
        this.set_scale_y(scale);
    }

    public void set_scale_x(int scale_x) {
        this.set_scale_x(new Rational(scale_x));
    }

    public void set_scale_x(int scale_x_p, int scale_x_q) {
        this.set_scale_x(new Rational(scale_x_p, scale_x_q));
    }

    public void set_scale_x(Rational scale_x) {
        this.scale_x = scale_x;
    }

    public void set_scale_y(int scale_y) {
        this.set_scale_y(new Rational(scale_y));
    }

    public void set_scale_y(int scale_y_p, int scale_y_q) {
        this.set_scale_y(new Rational(scale_y_p, scale_y_q));
    }

    public void set_scale_y(Rational scale_y) {
        this.scale_y = scale_y;
    }

    protected Rational translate_date(Rational date) {
        return date.subtract(this.date_first).multiply(this.scale_y);
    }

    protected Rational translate_pos(Rational pos) {
        return pos.subtract(this.pos_min).multiply(this.scale_x);
    }

    public void unset_clippping() {
        this.clipping_right = null;
        this.clipping_left = null;
        this.clipping_end = null;
        this.clipping_start = null;
    }

    protected void update_X_Min_Max(Rational x) {
        if (x.lt(this.pos_min)) {
            this.pos_min = x;
        }
        if (this.pos_max.lt(x)) {
            this.pos_max = x;
        }
    }
}

