/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.driver;

import fr.univ_orleans.jdl.util.File_Util;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LaTeX_Print_writer
extends PrintWriter {
    private static final int BYTE_TAB_SIZE = 1024;
    public static final String EXTENTION_LATEX = ".tex";
    private static final String RESSOURCE__DIR = "fr/univ_orleans/jdl/agc/driver/";
    private static final String RESSOURCE_COMMENT_WARNING = "fr/univ_orleans/jdl/agc/driver/comment_warning.tex";
    private static final String RESSOURCE_PROLOGUE = "fr/univ_orleans/jdl/agc/driver/prologue.tex";
    private final PrintStream final_print_stream;
    private boolean should_compile_alone = false;
    private final StringWriter string_w;

    public LaTeX_Print_writer(OutputStream os) throws IOException {
        this(new StringWriter(), os);
    }

    public LaTeX_Print_writer(String file_name) throws IOException {
        this(new FileOutputStream(File_Util.ensureSuffix(file_name, EXTENTION_LATEX)));
    }

    private LaTeX_Print_writer(StringWriter string_w, OutputStream os) throws IOException {
        super(string_w);
        this.string_w = string_w;
        this.final_print_stream = new PrintStream(os);
        this.append_file_content_to_outputstream(os, RESSOURCE_COMMENT_WARNING);
    }

    private void append_file_content_to_outputstream(OutputStream os, String file_name) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream is = ClassLoader.getSystemResourceAsStream(file_name);){
            int n;
            if (is == null) {
                throw new RuntimeException("Impossible to access " + file_name);
            }
            byte[] tab = new byte[1024];
            while (-1 != (n = is.read(tab))) {
                os.write(tab, 0, n);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        os.flush();
    }

    @Override
    public void close() {
        try {
            if (this.should_compile_alone) {
                this.append_file_content_to_outputstream(this.final_print_stream, RESSOURCE_PROLOGUE);
            }
            this.final_print_stream.print(this.string_w.toString());
            if (this.should_compile_alone) {
                this.final_print_stream.print("\n\\end{document}\n\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.final_print_stream.close();
    }

    public void should_compile_alone() {
        this.should_compile_alone = true;
    }
}

