/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.kernel;

import fr.univ_orleans.jdl.agc.I_Collision;
import fr.univ_orleans.jdl.agc.I_Signal;
import fr.univ_orleans.jdl.agc.kernel.Run;
import fr.univ_orleans.jdl.agc.kernel.Signal;
import fr.univ_orleans.jdl.agc.util.Util_Signal;
import fr.univ_orleans.jdl.util.Rational;
import fr.univ_orleans.jdl.util.Tree_Linked_List;

public class Collision
implements I_Collision {
    private final Rational date;
    private Tree_Linked_List.Node location_in_tree;
    private final Rational position;
    private Signal[] signals_in;
    private Signal[] signals_out;
    private final Run run;

    Collision(Run run, Rational date, Rational position) {
        this.run = run;
        this.date = date;
        this.position = position;
        this.signals_in = null;
        this.location_in_tree = null;
    }

    Collision(Run run, Signal signal_left, Signal signal_right, Rational date) {
        this.run = run;
        this.date = date;
        this.position = signal_left.get_position_at(date);
        assert (signal_left.get_meta_signal().get_speed().compareTo(signal_right.get_meta_signal().get_speed()) > 0);
        this.signals_in = new Signal[]{signal_left, signal_right};
        this.location_in_tree = run.forecasted_collisions.add(this);
        signal_left.collision_with_right = this;
        assert (this.is_coherent());
    }

    void add_signal_in(Signal signal) {
        assert (signal != null);
        assert (!this.is_contained_in_in(signal));
        if (!this.is_contained_in_in(signal)) {
            Signal[] newSig = new Signal[this.signals_in.length + 1];
            int i = 0;
            int j = 0;
            while (i < this.signals_in.length && this.signals_in[i].meta_signal.get_speed().compareTo(signal.meta_signal.get_speed()) > 0) {
                newSig[j++] = this.signals_in[i++];
            }
            newSig[j++] = signal;
            while (i < this.signals_in.length) {
                newSig[j++] = this.signals_in[i++];
            }
            this.signals_in = newSig;
        }
    }

    void dispel() {
        Signal[] signalArray = this.signals_in;
        int n = this.signals_in.length;
        int n2 = 0;
        while (n2 < n) {
            Signal s = signalArray[n2];
            if (s.collision_with_right == this) {
                s.collision_with_right = null;
            }
            ++n2;
        }
        this.run.forecasted_collisions.remove(this.location_in_tree);
        this.location_in_tree = null;
    }

    @Override
    public Rational get_date() {
        return this.date;
    }

    @Override
    public Rational get_position() {
        return this.position;
    }

    Signal get_signal_on_left() {
        assert (this.signals_in != null && this.signals_in.length != 0 && this.signals_out == null);
        return this.signals_in[0].get_signal_on_left();
    }

    Signal get_signal_on_right() {
        assert (this.signals_in != null && this.signals_in.length != 0 && this.signals_out == null);
        return this.signals_in[this.signals_in.length - 1].get_signal_on_right();
    }

    public Signal[] get_signals_in() {
        return (Signal[])this.signals_in.clone();
    }

    @Override
    public I_Signal[] get_signals_out() {
        return (I_Signal[])this.signals_out.clone();
    }

    private boolean is_coherent() {
        Signal right_most = this.signals_in[this.signals_in.length - 1];
        Signal[] signalArray = this.signals_in;
        int n = this.signals_in.length;
        int n2 = 0;
        while (n2 < n) {
            Signal signal_curent = signalArray[n2];
            assert (signal_curent == right_most || signal_curent.collision_with_right == this);
            ++n2;
        }
        return true;
    }

    boolean is_contained_in_in(I_Signal signal) {
        Signal[] signalArray = this.signals_in;
        int n = this.signals_in.length;
        int n2 = 0;
        while (n2 < n) {
            Signal sig = signalArray[n2];
            if (signal == sig) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void merge_left_collision_in(Collision collision_on_the_left) {
        Signal[] signalArray = collision_on_the_left.signals_in;
        int n = collision_on_the_left.signals_in.length;
        int n2 = 0;
        while (n2 < n) {
            Signal signal = signalArray[n2];
            signal.collision_with_right = this;
            ++n2;
        }
        signalArray = collision_on_the_left.signals_in;
        n = collision_on_the_left.signals_in.length;
        n2 = 0;
        while (n2 < n) {
            Signal s = signalArray[n2];
            this.add_signal_in(s);
            ++n2;
        }
        collision_on_the_left.dispel();
    }

    void remove_signal(Signal signal) {
        assert (this.is_contained_in_in(signal));
        if (this.signals_in.length <= 2) {
            this.dispel();
        } else {
            Signal[] new_signal_in = new Signal[this.signals_in.length - 1];
            int j = 0;
            Signal[] signalArray = this.signals_in;
            int n = this.signals_in.length;
            int n2 = 0;
            while (n2 < n) {
                Signal sig = signalArray[n2];
                if (sig != signal) {
                    new_signal_in[j++] = sig;
                }
                ++n2;
            }
            this.signals_in = new_signal_in;
            if (this == signal.collision_with_right) {
                signal.collision_with_right = null;
            }
            this.signals_in[this.signals_in.length - 1].collision_with_right = null;
        }
    }

    void set_signals_out(Signal[] signals_out) {
        assert (this.signals_out == null);
        this.signals_out = signals_out;
    }

    public String toString() {
        return "( date=" + this.date + ", position=" + this.position + ", in=" + Util_Signal.to_string(this.signals_in) + ", out=" + (this.signals_out == null ? "-" : Util_Signal.to_string(this.signals_out)) + " )";
    }
}

