/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.kernel;

import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Signal_Machine;
import fr.univ_orleans.jdl.agc.Meta_Signal_Constant;
import fr.univ_orleans.jdl.agc.kernel.Signal_Machine;
import fr.univ_orleans.jdl.util.Color_Constant;
import fr.univ_orleans.jdl.util.Rational;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class Meta_Signal
implements I_Meta_Signal {
    private static int next_number = 0;
    private String id;
    private final int number;
    private HashMap<String, Object> properties = null;
    private final I_Signal_Machine sm;
    private Rational speed;

    public Meta_Signal(I_Signal_Machine sm, String id, int p, int q) {
        this(sm, id, new Rational(p, q));
    }

    public Meta_Signal(I_Signal_Machine sm, String id, int p, int q, Color c) {
        this(sm, id, p, q);
        this.set_color(c);
    }

    public Meta_Signal(I_Signal_Machine sm, String id, Rational speed) {
        this.sm = sm;
        this.id = id;
        this.speed = speed;
        this.number = next_number++;
    }

    public Meta_Signal(I_Signal_Machine sm, String id, Rational speed, Color c) {
        this(sm, id, speed);
        this.set_color(c);
    }

    @Override
    public I_Meta_Signal clone(I_Signal_Machine mach) {
        Meta_Signal ms = new Meta_Signal(mach, this.get_id(), this.get_speed(), this.get_color());
        ms.properties.putAll(this.properties);
        return ms;
    }

    @Override
    public int compareTo(I_Meta_Signal ms) {
        assert (ms instanceof Meta_Signal);
        return this.number - ((Meta_Signal)ms).number;
    }

    @Override
    public Color get_color() {
        Object c = this.get_property("color");
        return c == null ? Meta_Signal_Constant.COLOR_DEFAULT : (Color)c;
    }

    @Override
    public String get_id() {
        return this.id;
    }

    @Override
    public Object get_property(String key) {
        key = key.toLowerCase();
        return this.properties == null ? null : this.properties.get(key);
    }

    @Override
    public Stream<Map.Entry<String, Object>> get_property_stream() {
        return this.properties == null ? null : this.properties.entrySet().stream();
    }

    @Override
    public I_Signal_Machine get_signal_machine() {
        return this.sm;
    }

    @Override
    public Rational get_speed() {
        return this.speed;
    }

    @Override
    public void set_color(Color color) {
        assert (color != null);
        this.set_property("color", color);
    }

    @Override
    public void set_color(I_Meta_Signal st) {
        assert (st != null);
        this.set_color(st.get_color());
    }

    @Override
    public void set_color(int r, int g, int b) {
        this.set_color(new Color(r, g, b));
    }

    @Override
    public void set_color(String color) {
        assert (color != null);
        Color c = Color_Constant.get_color(color);
        if (c != null) {
            this.set_color(c);
        }
    }

    @Override
    public void set_id(String id) {
        ((Signal_Machine)this.sm).change_signal_id(this, id);
    }

    void set_id_straight(String id) {
        this.id = id;
    }

    @Override
    public void set_property(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if ((key = key.toLowerCase()).equals("color") && !(value instanceof Color)) {
            if (value instanceof I_Meta_Signal) {
                this.set_color((I_Meta_Signal)value);
            } else {
                this.set_color(value.toString());
            }
        } else {
            this.properties.put(key, value);
        }
    }

    @Override
    public void set_speed(Rational speed) {
        assert (speed != null);
        this.speed = speed;
    }

    public String toString() {
        return "ms ( \"" + this.id + "\", " + this.speed + ", " + this.get_color() + " )";
    }
}

