/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.kernel;

import fr.univ_orleans.jdl.agc.I_Collision;
import fr.univ_orleans.jdl.agc.I_Configuration;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Run;
import fr.univ_orleans.jdl.agc.I_Signal;
import fr.univ_orleans.jdl.agc.I_Signal_Machine;
import fr.univ_orleans.jdl.agc.exception.E_Identical_Speed_Exception;
import fr.univ_orleans.jdl.agc.kernel.Collision;
import fr.univ_orleans.jdl.agc.kernel.Signal;
import fr.univ_orleans.jdl.util.Iterable_Without_Remove;
import fr.univ_orleans.jdl.util.Rational;
import fr.univ_orleans.jdl.util.Tree_Linked_List;
import java.util.LinkedList;

public class Run
implements I_Run {
    private static final Rational DATE_DEFAULT = Rational.ZERO;
    private Rational date = Rational.ZERO;
    final Tree_Linked_List<Signal> active_signals = new Tree_Linked_List((s1, s2) -> {
        if (s1 == s2) {
            return 0;
        }
        int cmp = s1.get_position_at(this.date).compareTo(s2.get_position_at(this.date));
        if (cmp != 0) {
            return cmp;
        }
        int speed_comparison = s1.get_meta_signal().get_speed().compareTo(s2.get_meta_signal().get_speed());
        if (s1.get_date_start().compareTo(this.get_date()) < 0) {
            return -speed_comparison;
        }
        return speed_comparison;
    });
    final LinkedList<Signal> finished_signals = new LinkedList();
    final Tree_Linked_List<Collision> forecasted_collisions = new Tree_Linked_List((r1, r2) -> {
        int cmp = r1.get_date().compareTo(r2.get_date());
        if (cmp != 0) {
            return cmp;
        }
        return r1.get_position().compareTo(r2.get_position());
    });
    private final I_Configuration initial_configuration;
    private final I_Signal_Machine sm;

    public static Rational compute_date_collision(I_Signal s1, I_Signal s2) {
        return s1.get_position_at(Rational.ZERO).subtract(s2.get_position_at(Rational.ZERO)).divide(s2.get_meta_signal().get_speed().subtract(s1.get_meta_signal().get_speed()));
    }

    public Run(I_Signal_Machine sm) {
        this(sm, false);
    }

    public Run(I_Signal_Machine sm, boolean is_an_initial_configuration) {
        this(sm, is_an_initial_configuration, DATE_DEFAULT);
    }

    Run(I_Signal_Machine sm, boolean is_an_initial_configuration, Rational date) {
        this.sm = sm;
        this.date = date;
        this.initial_configuration = is_an_initial_configuration ? null : new Run(sm, true);
    }

    @Override
    public I_Signal add_signal(I_Meta_Signal ms, int pos) {
        return this.add_signal(ms, pos, 1);
    }

    @Override
    public I_Signal add_signal(I_Meta_Signal ms, int p, int q) {
        return this.add_signal(ms, new Rational(p, q));
    }

    @Override
    public I_Signal add_signal(I_Meta_Signal ms, Rational pos) {
        if (this.sm != ms.get_signal_machine()) {
            throw new E_Identical_Speed_Exception("meta signals " + ms + " does not belong to Signal machine " + this.sm);
        }
        if (this.initial_configuration != null && this.date.equals(this.initial_configuration.get_date())) {
            this.initial_configuration.add_signal(ms, pos);
        }
        return new Signal(this, ms, new Collision(this, this.get_date(), pos));
    }

    @Override
    public I_Signal add_signal(String id, int pos) {
        return this.add_signal(id, pos, 1);
    }

    @Override
    public I_Signal add_signal(String id, int p, int q) {
        return this.add_signal(id, new Rational(p, q));
    }

    @Override
    public I_Signal add_signal(String id, Rational pos) {
        return this.add_signal(this.sm.get_meta_signal(id), pos);
    }

    @Override
    public I_Signal add_signal_relative_position(I_Meta_Signal ms, Rational pos_relative) {
        Rational pos_min = this.get_leftmost_position();
        Rational pos_max = this.get_rightmost_position();
        Rational pos = pos_min.add(pos_max.subtract(pos_min).multiply(pos_relative));
        return this.add_signal(ms, pos);
    }

    private Signal[] add_signals(I_Meta_Signal[] ms, I_Collision col_end) {
        Signal[] signal_out = new Signal[ms.length];
        int i = 0;
        I_Meta_Signal[] i_Meta_SignalArray = ms;
        int n = ms.length;
        int n2 = 0;
        while (n2 < n) {
            I_Meta_Signal m_s = i_Meta_SignalArray[n2];
            signal_out[i++] = new Signal(this, m_s, col_end);
            if (this.initial_configuration != null && this.date.equals(this.initial_configuration.get_date())) {
                this.initial_configuration.add_signal(m_s, col_end.get_position());
            }
            ++n2;
        }
        return signal_out;
    }

    @Override
    public void clear_all() {
        this.date = Rational.ZERO;
        this.active_signals.clear();
        this.forecasted_collisions.clear();
        this.finished_signals.clear();
        if (this.initial_configuration != null) {
            this.initial_configuration.clear_all();
        }
    }

    private void forecast_collision(Signal signal) {
        assert (signal.is_active());
        assert (this.active_signals.test_linked_list());
        assert (signal.is_coherent());
        Signal signal_on_right = signal.get_signal_on_right();
        if (signal_on_right != null) {
            this.forecast_collision(signal, signal_on_right);
        } else if (signal.collision_with_right != null) {
            signal.collision_with_right.dispel();
        }
        Signal signal_on_left = signal.get_signal_on_left();
        if (signal_on_left != null) {
            this.forecast_collision(signal_on_left, signal);
        }
        assert (signal.is_coherent());
    }

    void forecast_collision(Signal signal_left, Signal signal_right) {
        assert (signal_left != null);
        assert (signal_right != null);
        assert (signal_left.is_active());
        assert (signal_right.is_active());
        assert (signal_right.get_signal_on_left() == signal_left);
        assert (signal_left.get_signal_on_right() == signal_right);
        assert (signal_left.is_coherent());
        assert (signal_right.is_coherent());
        assert (this.active_signals.get_comparator().compare(signal_left, signal_right) < 0);
        if (signal_left.collision_with_right != null) {
            if (signal_left.collision_with_right.is_contained_in_in(signal_right)) {
                return;
            }
            signal_left.collision_with_right.remove_signal(signal_left);
        }
        Collision thisCol = null;
        if (signal_right.meta_signal.get_speed().compareTo(signal_left.meta_signal.get_speed()) < 0) {
            boolean is_same_collision_left;
            Rational collision_date = Run.compute_date_collision(signal_left, signal_right);
            boolean is_same_collision_right = signal_right.collision_with_right != null && collision_date.equals(signal_right.collision_with_right.get_date());
            Signal left_left_signal = signal_left.get_signal_on_left();
            boolean bl = is_same_collision_left = left_left_signal != null && left_left_signal.collision_with_right != null && collision_date.equals(left_left_signal.collision_with_right.get_date());
            if (is_same_collision_right) {
                thisCol = signal_right.collision_with_right;
                if (is_same_collision_left) {
                    if (thisCol != signal_right.collision_with_right) {
                        signal_right.collision_with_right.merge_left_collision_in(thisCol);
                    } else {
                        thisCol.add_signal_in(signal_left);
                    }
                } else {
                    thisCol.add_signal_in(signal_left);
                }
            } else if (is_same_collision_left) {
                assert (left_left_signal != null);
                thisCol = left_left_signal.collision_with_right;
                assert (thisCol != null);
                thisCol.add_signal_in(signal_right);
            } else {
                thisCol = new Collision(this, signal_left, signal_right, collision_date);
            }
        }
        signal_left.collision_with_right = thisCol;
        assert (signal_left.is_coherent());
        assert (signal_right.is_coherent());
    }

    @Override
    public Rational get_date() {
        return this.date;
    }

    @Override
    public Iterable<I_Signal> get_finished_signals() {
        return new Iterable_Without_Remove(this.finished_signals);
    }

    public Iterable<Collision> get_forecasted_collisions_copy() {
        return new Iterable_Without_Remove(this.forecasted_collisions);
    }

    @Override
    public I_Configuration get_initial_configuration() {
        return this.initial_configuration;
    }

    @Override
    public Rational get_leftmost_position() {
        I_Signal sig = this.get_leftmost_signal();
        return sig == null ? null : sig.get_position_at(this.get_date());
    }

    @Override
    public I_Signal get_leftmost_right_of(Rational pos) {
        I_Signal ret = null;
        for (I_Signal i_Signal : this.active_signals) {
            if (i_Signal.get_position_at(this.get_date()).compareTo(pos) <= 0) continue;
            ret = i_Signal;
            break;
        }
        return ret;
    }

    @Override
    public I_Signal get_leftmost_signal() {
        return this.active_signals.is_empty() ? null : (I_Signal)this.active_signals.get_first();
    }

    @Override
    public I_Collision get_next_collision() {
        return this.has_collision() ? (I_Collision)this.forecasted_collisions.get_first() : null;
    }

    @Override
    public I_Signal get_rightmost_left_of(Rational pos) {
        I_Signal ret = null;
        I_Signal prev = null;
        for (I_Signal i_Signal : this.active_signals) {
            if (i_Signal.get_position_at(this.get_date()).compareTo(pos) >= 0) {
                ret = prev;
                break;
            }
            prev = i_Signal;
        }
        return ret;
    }

    @Override
    public Rational get_rightmost_position() {
        I_Signal sig = this.get_rightmost_signal();
        return sig == null ? null : sig.get_position_at(this.get_date());
    }

    @Override
    public I_Signal get_rightmost_signal() {
        return this.active_signals.is_empty() ? null : (I_Signal)this.active_signals.get_last();
    }

    @Override
    public I_Signal_Machine get_signal_machine() {
        return this.sm;
    }

    @Override
    public Iterable<I_Signal> get_signals() {
        return new Iterable_Without_Remove(this.active_signals);
    }

    @Override
    public boolean has_collision() {
        return !this.forecasted_collisions.is_empty();
    }

    @Override
    public boolean has_signals() {
        return !this.active_signals.is_empty();
    }

    @Override
    public void make_collision_step(long nbr) {
        while (0L < nbr && this.has_collision()) {
            Rational date_collision = this.forecasted_collisions.get_first().get_date();
            do {
                this.make_next_collision();
            } while (this.has_collision() && date_collision.equals(this.forecasted_collisions.get_first().get_date()));
            --nbr;
        }
    }

    @Override
    public void make_collision_until(Rational date_end) {
        while (this.has_collision() && this.get_next_collision_date().compareTo(date_end) <= 0) {
            this.make_next_collision();
        }
        this.date = date_end;
    }

    @Override
    public void make_collision_until_limited(Rational date_end, long max_col) {
        while (0L < max_col && this.has_collision() && this.get_next_collision_date().compareTo(date_end) <= 0) {
            Rational date_collision = this.forecasted_collisions.get_first().get_date();
            do {
                this.make_next_collision();
            } while (this.has_collision() && date_collision.equals(this.forecasted_collisions.get_first().get_date()));
            --max_col;
        }
        Rational date_next_collision = this.get_next_collision_date();
        if (date_next_collision == null || date_end.compareTo(date_next_collision) <= 0) {
            this.date = date_end;
        }
    }

    @Override
    public void make_next_collision() {
        if (this.has_collision()) {
            Collision col = this.forecasted_collisions.get_first();
            this.forecasted_collisions.remove(col);
            this.date = col.get_date();
            Signal signal_on_left = col.get_signal_on_left();
            Signal signal_on_right = col.get_signal_on_right();
            Signal[] signalArray = col.get_signals_in();
            int n = signalArray.length;
            int n2 = 0;
            while (n2 < n) {
                Signal s = signalArray[n2];
                s.finish(col);
                ++n2;
            }
            I_Meta_Signal[] out_meta_signals = this.sm.get_collision_rule_output(col);
            if (out_meta_signals != null && out_meta_signals.length != 0) {
                col.set_signals_out(this.add_signals(out_meta_signals, col));
            }
            if (signal_on_left != null) {
                this.forecast_collision(signal_on_left);
            }
            if (signal_on_right != null) {
                this.forecast_collision(signal_on_right);
            }
        }
    }

    void remove_from_left_collision(Signal signal) {
        Signal left_signal = signal.get_signal_on_left();
        if (left_signal != null && left_signal.collision_with_right != null) {
            left_signal.collision_with_right.remove_signal(signal);
        }
    }

    void remove_from_right_collision(Signal signal) {
        if (signal.collision_with_right != null) {
            signal.collision_with_right.remove_signal(signal);
        }
    }

    @Override
    public void remove_signal(I_Signal signal) {
        this.remove_signal((Signal)signal);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public I_Signal remove_signal(int n) {
        block6: {
            block5: {
                if (n <= 0) break block5;
                loc = this.active_signals.get_first_location();
                if (true) ** GOTO lbl6
                do {
                    loc = this.active_signals.get_location_after(loc);
lbl6:
                    // 2 sources

                    v0 = --n;
                    --n;
                } while (v0 > 0);
                break block6;
            }
            if (n < 0) {
                n = -n - 1;
                loc = this.active_signals.get_last_location();
                while (n-- > 0) {
                    loc = this.active_signals.get_location_before(loc);
                }
            } else {
                throw new IllegalArgumentException("No zero position for removal");
            }
        }
        if (loc == null) {
            return null;
        }
        removed_signal = (Signal)loc.get_value();
        this.remove_signal(removed_signal);
        return removed_signal;
    }

    void remove_signal(Signal signal) {
        Signal left = signal.get_signal_on_left();
        Signal right = signal.get_signal_on_right();
        this.remove_from_right_collision(signal);
        this.remove_from_left_collision(signal);
        this.active_signals.remove(signal);
        if (left != null) {
            this.forecast_collision(left);
        }
        if (right != null) {
            this.forecast_collision(right);
        }
        if (this.initial_configuration != null && this.date.equals(this.initial_configuration.get_date())) {
            for (I_Signal s : this.initial_configuration.get_signals()) {
                if (s.get_meta_signal() != signal.get_meta_signal() || !s.get_position_start().equals(signal.get_position_start())) continue;
                this.initial_configuration.remove_signal(s);
            }
        }
    }

    @Override
    public void reset_to_initial_configuration() {
        assert (this.initial_configuration != null);
        this.active_signals.clear();
        this.forecasted_collisions.clear();
        this.finished_signals.clear();
        this.date = this.initial_configuration.get_date();
        for (I_Signal si : this.initial_configuration.get_signals()) {
            new Signal(this, si.get_meta_signal(), new Collision(this, this.date, si.get_position_at(this.date)));
        }
    }

    @Override
    public Run run() {
        Run run = new Run(this.sm);
        Rational date_loc = this.get_date();
        for (I_Signal s : this.get_signals()) {
            run.add_signal(s.get_meta_signal(), s.get_position_at(date_loc));
        }
        return run;
    }
}

