/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.kernel;

import fr.univ_orleans.jdl.agc.I_Collision;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Run;
import fr.univ_orleans.jdl.agc.I_Signal;
import fr.univ_orleans.jdl.agc.exception.E_Signal_Still_Active;
import fr.univ_orleans.jdl.agc.kernel.Collision;
import fr.univ_orleans.jdl.agc.kernel.Run;
import fr.univ_orleans.jdl.util.Rational;
import fr.univ_orleans.jdl.util.Tree_Linked_List;

public class Signal
implements I_Signal {
    private Collision collision_end = null;
    private final I_Collision collision_start;
    Collision collision_with_right = null;
    private final Tree_Linked_List.Node location_in_tree;
    final I_Meta_Signal meta_signal;
    private final Run run;

    Signal(Run run, I_Meta_Signal ms, I_Collision col_start) {
        assert (ms != null);
        assert (col_start != null);
        this.run = run;
        this.meta_signal = ms;
        this.collision_start = col_start;
        this.location_in_tree = run.active_signals.add(this);
        if (this != run.active_signals.get_value(this.location_in_tree)) {
            throw new IllegalArgumentException("Signal uncorrectly inserted " + this + "\nFound:" + run.active_signals.get_value(this.location_in_tree));
        }
        Signal signal_on_left = this.get_signal_on_left();
        if (signal_on_left != null) {
            assert (signal_on_left.get_signal_on_right() == this);
            run.forecast_collision(signal_on_left, this);
        }
        assert (this.is_coherent());
        Signal signal_on_right = this.get_signal_on_right();
        if (signal_on_right != null) {
            run.forecast_collision(this, signal_on_right);
        }
        assert (this.is_coherent());
    }

    void finish(Collision collision_end) {
        Collision collision_with_left;
        assert (this.is_coherent());
        assert (collision_end != null);
        this.collision_end = collision_end;
        Signal signal_on_left = this.get_signal_on_left();
        Signal signal_on_right = this.get_signal_on_right();
        this.run.active_signals.remove(this.location_in_tree);
        if (signal_on_left != null && (collision_with_left = signal_on_left.collision_with_right) != collision_end && collision_with_left != null) {
            if (collision_with_left.is_contained_in_in(this)) {
                collision_with_left.remove_signal(this);
            } else {
                collision_with_left.remove_signal(signal_on_left);
            }
        }
        if (this.collision_with_right != collision_end && this.collision_with_right != null) {
            this.collision_with_right.remove_signal(this);
        }
        this.collision_with_right = null;
        if (signal_on_left != null && signal_on_right != null) {
            this.run.forecast_collision(signal_on_left, signal_on_right);
        }
        this.run.finished_signals.add(this);
    }

    @Override
    public I_Collision get_collision_end() {
        return this.collision_end;
    }

    @Override
    public I_Collision get_collision_start() {
        return this.collision_start;
    }

    @Override
    public Rational get_date_end() {
        if (this.is_active()) {
            throw new E_Signal_Still_Active(this.toString());
        }
        return this.collision_end.get_date();
    }

    @Override
    public Rational get_date_start() {
        return this.collision_start.get_date();
    }

    @Override
    public Rational get_duration() {
        return (this.collision_end == null ? this.run.get_date() : this.get_date_end()).subtract(this.collision_start.get_date());
    }

    @Override
    public I_Meta_Signal get_meta_signal() {
        return this.meta_signal;
    }

    @Override
    public Rational get_position_at(Rational date) {
        return this.collision_start.get_position().add(date.subtract(this.collision_start.get_date()).multiply(this.meta_signal.get_speed()));
    }

    @Override
    public Rational get_position_end() {
        if (this.is_active()) {
            throw new E_Signal_Still_Active(this.toString());
        }
        return this.collision_end.get_position();
    }

    @Override
    public Rational get_position_start() {
        return this.collision_start.get_position();
    }

    @Override
    public I_Run get_run() {
        return this.run;
    }

    Signal get_signal_on_left() {
        assert (this.is_coherent());
        assert (this.location_in_tree.is_coherent(true, true));
        return this.run.active_signals.get_value_before((Signal)((Object)this.location_in_tree));
    }

    Signal get_signal_on_right() {
        assert (this.is_coherent());
        assert (this.location_in_tree.is_coherent(true, true));
        return this.run.active_signals.get_value_after((Signal)((Object)this.location_in_tree));
    }

    @Override
    public boolean is_active() {
        return this.collision_end == null;
    }

    boolean is_coherent() {
        return this.collision_with_right == null || this.collision_with_right.is_contained_in_in(this);
    }

    public String toString() {
        return "( \"" + this.meta_signal.get_id() + "\", pos=" + this.collision_start.get_position() + ", start=" + this.collision_start.get_date() + (this.collision_end != null ? ", end=" + this.get_date_end() : "") + " )";
    }
}

