/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.kernel;

import fr.univ_orleans.jdl.agc.I_Collision;
import fr.univ_orleans.jdl.agc.I_Configuration;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Signal;
import fr.univ_orleans.jdl.agc.I_Signal_Machine;
import fr.univ_orleans.jdl.agc.I_Undefined_Collision_Rule;
import fr.univ_orleans.jdl.agc.exception.E_Identical_Speed_Exception;
import fr.univ_orleans.jdl.agc.exception.E_Meta_Signal_Already_Present_Exception;
import fr.univ_orleans.jdl.agc.exception.E_No_Such_Meta_Signal_Exception;
import fr.univ_orleans.jdl.agc.kernel.Meta_Signal;
import fr.univ_orleans.jdl.agc.kernel.Rule_Comparator;
import fr.univ_orleans.jdl.agc.kernel.Run;
import fr.univ_orleans.jdl.agc.kernel.Undefined_Collision_Rule_Function;
import fr.univ_orleans.jdl.agc.util.Util_Meta_Signal;
import fr.univ_orleans.jdl.agc.util.Util_Signal;
import fr.univ_orleans.jdl.util.Rational;
import java.awt.Color;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;

public class Signal_Machine
implements I_Signal_Machine {
    private static final I_Meta_Signal[] EMPTY_I_META_SIGNAL_ARRAY = new I_Meta_Signal[0];
    private final TreeMap<I_Meta_Signal[], I_Meta_Signal[]> collision_rules = new TreeMap(new Rule_Comparator());
    private final TreeMap<String, I_Meta_Signal> meta_signal_set = new TreeMap();
    private I_Undefined_Collision_Rule undefined_rule = new Undefined_Collision_Rule_Function();

    private static I_Meta_Signal[] translate(I_Signal_Machine mach, I_Meta_Signal[] t) {
        I_Meta_Signal[] res = new I_Meta_Signal[t.length];
        int i = 0;
        while (i < t.length) {
            res[i] = mach.get_meta_signal(t[i].get_id());
            ++i;
        }
        return res;
    }

    @Override
    public I_Signal_Machine create_copy() {
        Signal_Machine mach = new Signal_Machine();
        for (I_Meta_Signal i_Meta_Signal : this.meta_signal_set.values()) {
            mach.meta_signal_set.put(i_Meta_Signal.get_id(), i_Meta_Signal.clone(mach));
        }
        for (Map.Entry entry : this.collision_rules.entrySet()) {
            mach.add_collision_rule(Signal_Machine.translate(mach, (I_Meta_Signal[])entry.getKey()), Signal_Machine.translate(mach, (I_Meta_Signal[])entry.getValue()));
        }
        mach.undefined_rule = this.undefined_rule;
        return mach;
    }

    @Override
    public I_Meta_Signal[] add_collision_rule(Collection<I_Meta_Signal> ms_in, Collection<I_Meta_Signal> ms_out) {
        return this.add_collision_rule_array_not_reused(ms_in.toArray(EMPTY_I_META_SIGNAL_ARRAY), ms_out.toArray(EMPTY_I_META_SIGNAL_ARRAY));
    }

    @Override
    public I_Meta_Signal[] add_collision_rule(I_Meta_Signal[] ms_in, I_Meta_Signal[] ms_out) {
        return this.add_collision_rule_array_not_reused((I_Meta_Signal[])ms_in.clone(), (I_Meta_Signal[])ms_out.clone());
    }

    public I_Meta_Signal[] add_collision_rule_array_not_reused(I_Meta_Signal[] ms_in, I_Meta_Signal[] ms_out) {
        if (ms_in.length < 2) {
            throw new IllegalArgumentException("There should be at least two in-coming signals : \n " + Util_Meta_Signal.to_string(ms_in) + "\n -> " + Util_Meta_Signal.to_string(ms_out));
        }
        int i = 0;
        while (i < ms_in.length) {
            if (this != ms_in[i].get_signal_machine()) {
                throw new E_Identical_Speed_Exception("meta signals_in [ i ] " + ms_in[i] + " does not belong to Signal machine " + this);
            }
            ++i;
        }
        i = 0;
        while (i < ms_out.length) {
            if (this != ms_out[i].get_signal_machine()) {
                throw new E_Identical_Speed_Exception("meta signals_out [ i ] " + ms_out[i] + " does not belong to Signal machine " + this);
            }
            ++i;
        }
        Util_Meta_Signal.sort(ms_in);
        i = 0;
        while (i < ms_in.length - 1) {
            if (ms_in[i].get_speed().equals(ms_in[i + 1].get_speed())) {
                throw new E_Identical_Speed_Exception("\n  => ** from " + Util_Meta_Signal.to_string_speed(ms_in) + "\n      to " + Util_Meta_Signal.to_string_speed(ms_out));
            }
            ++i;
        }
        Util_Meta_Signal.sort(ms_out);
        i = 0;
        while (i < ms_out.length - 1) {
            if (ms_out[i].get_speed().equals(ms_out[i + 1].get_speed())) {
                throw new E_Identical_Speed_Exception("\n  =>   from " + Util_Meta_Signal.to_string_speed(ms_in) + "\n   ** to " + Util_Meta_Signal.to_string_speed(ms_out));
            }
            ++i;
        }
        return this.collision_rules.put(ms_in, ms_out);
    }

    @Override
    public I_Meta_Signal[] add_collision_rule_by_id(Collection<String> id_in, Collection<String> id_out) {
        I_Meta_Signal[] ia = new I_Meta_Signal[id_in.size()];
        I_Meta_Signal[] ib = new I_Meta_Signal[id_out.size()];
        int i = 0;
        for (String id : id_in) {
            ia[i++] = this.get_meta_signal(id);
        }
        i = 0;
        for (String id : id_out) {
            ib[i++] = this.get_meta_signal(id);
        }
        return this.add_collision_rule_array_not_reused(ia, ib);
    }

    @Override
    public I_Meta_Signal[] add_collision_rule_by_id(String[] id_in, String[] id_out) {
        String id;
        I_Meta_Signal[] ia = new I_Meta_Signal[id_in.length];
        I_Meta_Signal[] ib = new I_Meta_Signal[id_out.length];
        int i = 0;
        String[] stringArray = id_in;
        int n = id_in.length;
        int n2 = 0;
        while (n2 < n) {
            id = stringArray[n2];
            ia[i++] = this.get_meta_signal(id);
            ++n2;
        }
        i = 0;
        stringArray = id_out;
        n = id_out.length;
        n2 = 0;
        while (n2 < n) {
            id = stringArray[n2];
            ib[i++] = this.get_meta_signal(id);
            ++n2;
        }
        return this.add_collision_rule_array_not_reused(ia, ib);
    }

    protected I_Meta_Signal add_meta_signal(I_Meta_Signal ms) {
        assert (this == ms.get_signal_machine());
        if (this.meta_signal_set.get(ms.get_id()) != null) {
            throw new E_Meta_Signal_Already_Present_Exception(ms.get_id());
        }
        this.meta_signal_set.put(ms.get_id(), ms);
        return ms;
    }

    @Override
    public I_Meta_Signal add_meta_signal(String id, int p) {
        return this.add_meta_signal(new Meta_Signal((I_Signal_Machine)this, id, p, 1));
    }

    @Override
    public I_Meta_Signal add_meta_signal(String id, int p, Color c) {
        return this.add_meta_signal(new Meta_Signal(this, id, p, 1, c));
    }

    @Override
    public I_Meta_Signal add_meta_signal(String id, int p, int q) {
        return this.add_meta_signal(new Meta_Signal((I_Signal_Machine)this, id, p, q));
    }

    @Override
    public I_Meta_Signal add_meta_signal(String id, int p, int q, Color c) {
        return this.add_meta_signal(new Meta_Signal(this, id, p, q, c));
    }

    @Override
    public I_Meta_Signal add_meta_signal(String id, Rational speed) {
        return this.add_meta_signal(new Meta_Signal(this, id, speed));
    }

    @Override
    public I_Meta_Signal add_meta_signal(String id, Rational speed, Color c) {
        return this.add_meta_signal(new Meta_Signal((I_Signal_Machine)this, id, speed, c));
    }

    void change_signal_id(Meta_Signal ms, String id) {
        assert (id != null);
        assert (!id.equals(""));
        assert (this == ms.get_signal_machine());
        String old_id = ms.get_id();
        if (old_id.equals(id)) {
            return;
        }
        if (this.is_id_present(id)) {
            throw new E_Meta_Signal_Already_Present_Exception("Meta_Signal with id=\"" + id + "\" exists.");
        }
        I_Meta_Signal renamed_one = this.meta_signal_set.remove(old_id);
        if (renamed_one != ms) {
            throw new E_No_Such_Meta_Signal_Exception("There is another meta-Signal with id=\"" + old_id + "\" exists.");
        }
        ms.set_id_straight(id);
        this.meta_signal_set.put(id, ms);
    }

    public void changed_signal_speed(I_Meta_Signal ms, Rational speed) {
        assert (this == ms.get_signal_machine());
        ms.set_speed(speed);
    }

    @Override
    public I_Configuration create_configuration() {
        return new Run(this, true);
    }

    @Override
    public I_Configuration create_configuration(Rational date) {
        return new Run(this, true, date);
    }

    public String find_new_id(String prefix) {
        if (!this.is_id_present(prefix)) {
            return prefix;
        }
        int n = 0;
        while (this.is_id_present(String.valueOf(prefix) + n)) {
            ++n;
        }
        return String.valueOf(prefix) + n;
    }

    @Override
    public I_Meta_Signal[] get_collision_rule_output(I_Collision col) {
        I_Meta_Signal[] out_meta_signals = this.get_collision_rule_output(col.get_signals_in());
        if (out_meta_signals == null) {
            out_meta_signals = this.undefined_rule.get_undefined_rule_output(col);
        }
        return out_meta_signals;
    }

    @Override
    public I_Meta_Signal[] get_collision_rule_output(I_Meta_Signal[] key) {
        Util_Meta_Signal.sort(key);
        return this.get_collision_rule_output_sorted(key);
    }

    @Override
    public I_Meta_Signal[] get_collision_rule_output(I_Signal[] signal_in) {
        return this.get_collision_rule_output(Util_Signal.signal_to_meta_signal(signal_in));
    }

    private I_Meta_Signal[] get_collision_rule_output_sorted(I_Meta_Signal[] signal_in) {
        assert (Arrays.stream(signal_in).map(e -> this == e.get_signal_machine()).reduce(true, (r, e) -> r != false && e != false).booleanValue());
        return this.collision_rules.get(signal_in);
    }

    public TreeMap<I_Meta_Signal[], I_Meta_Signal[]> get_collision_rules_copy() {
        return (TreeMap)this.collision_rules.clone();
    }

    @Override
    public I_Meta_Signal get_meta_signal(String id) {
        I_Meta_Signal m_s = this.meta_signal_set.get(id);
        if (m_s == null) {
            throw new E_No_Such_Meta_Signal_Exception("with id=\"" + id + "\".");
        }
        return m_s;
    }

    @Override
    public Stream<I_Meta_Signal> get_meta_signal_stream() {
        return this.meta_signal_set.values().stream();
    }

    @Override
    public I_Meta_Signal[] get_meta_signals_copy() {
        return this.meta_signal_set.values().toArray(EMPTY_I_META_SIGNAL_ARRAY);
    }

    @Override
    public Rational[] get_min_max_abs_speed() {
        Rational minSpeed = Rational.PLUS_INFINITY;
        Rational maxSpeed = Rational.MINUS_INFINITY;
        for (I_Meta_Signal ms : this.meta_signal_set.values()) {
            Rational speed = ms.get_speed();
            if (speed.compareTo(minSpeed) < 0) {
                minSpeed = speed;
                continue;
            }
            if (maxSpeed.compareTo(speed) >= 0) continue;
            maxSpeed = speed;
        }
        return new Rational[]{minSpeed, maxSpeed, Rational.max(maxSpeed.abs(), minSpeed.abs())};
    }

    @Override
    public int get_nbr_collision_rules() {
        return this.collision_rules.size();
    }

    @Override
    public int get_nbr_meta_signals() {
        return this.meta_signal_set.size();
    }

    @Override
    public Stream<Map.Entry<List<I_Meta_Signal>, List<I_Meta_Signal>>> get_rule_stream() {
        return this.collision_rules.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<List<I_Meta_Signal>, List<I_Meta_Signal>>(Arrays.asList((I_Meta_Signal[])e.getKey()), Arrays.asList((I_Meta_Signal[])e.getValue())));
    }

    @Override
    public I_Undefined_Collision_Rule get_undefined_rule() {
        return this.undefined_rule;
    }

    @Override
    public boolean is_id_present(String id) {
        for (String s : this.meta_signal_set.keySet()) {
            if (!s.equals(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void remove_meta_signal(I_Meta_Signal m_s) {
        assert (this == m_s.get_signal_machine());
        Iterator<Map.Entry<I_Meta_Signal[], I_Meta_Signal[]>> iter = this.collision_rules.entrySet().iterator();
        block0: while (iter.hasNext()) {
            I_Meta_Signal m;
            Map.Entry<I_Meta_Signal[], I_Meta_Signal[]> e = iter.next();
            I_Meta_Signal[] i_Meta_SignalArray = e.getKey();
            int n = i_Meta_SignalArray.length;
            int n2 = 0;
            while (n2 < n) {
                m = i_Meta_SignalArray[n2];
                if (m == m_s) {
                    iter.remove();
                    continue block0;
                }
                ++n2;
            }
            i_Meta_SignalArray = e.getValue();
            n = i_Meta_SignalArray.length;
            n2 = 0;
            while (n2 < n) {
                m = i_Meta_SignalArray[n2];
                if (m == m_s) {
                    iter.remove();
                    continue block0;
                }
                ++n2;
            }
        }
        this.meta_signal_set.remove(m_s.get_id());
    }

    @Override
    public I_Meta_Signal[] remove_rule(I_Meta_Signal[] ms_in) {
        assert (Arrays.stream(ms_in).map(e -> this == e.get_signal_machine()).reduce(true, (r, e) -> r != false && e != false).booleanValue());
        return this.collision_rules.remove(ms_in);
    }

    @Override
    public void set_undefined_rule(I_Undefined_Collision_Rule undefined_rule) {
        this.undefined_rule = undefined_rule;
    }
}

