/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.operator;

import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Signal_Machine;
import fr.univ_orleans.jdl.agc.exception.E_Identical_Speed_Exception;
import fr.univ_orleans.jdl.agc.operator.E_Signal_Machine_Operator_Exception;
import fr.univ_orleans.jdl.util.Rational;
import java.util.Map;

public interface Signal_Machine_Operator_Utilities {
    public static void change_speed_affine(I_Signal_Machine mach, Rational a, Rational b) {
        I_Meta_Signal[] i_Meta_SignalArray = mach.get_meta_signals_copy();
        int n = i_Meta_SignalArray.length;
        int n2 = 0;
        while (n2 < n) {
            I_Meta_Signal k = i_Meta_SignalArray[n2];
            k.set_speed(k.get_speed().multiply(a).add(b));
            ++n2;
        }
    }

    public static void check_rules(I_Signal_Machine mach) {
        I_Meta_Signal[][] key_set;
        I_Meta_Signal[][] i_Meta_SignalArray = key_set = (I_Meta_Signal[][])((I_Meta_Signal[][])mach.get_collision_rules_copy().keySet().toArray((T[])new I_Meta_Signal[0][0])).clone();
        int n = key_set.length;
        int n2 = 0;
        while (n2 < n) {
            I_Meta_Signal[] key_orig = i_Meta_SignalArray[n2];
            I_Meta_Signal[] key = (I_Meta_Signal[])key_orig.clone();
            I_Meta_Signal[] value = (I_Meta_Signal[])mach.get_collision_rule_output(key).clone();
            mach.add_collision_rule(key, value);
            ++n2;
        }
    }

    public static String copy_into_signal_machine(String prefix, I_Signal_Machine sm_source, I_Signal_Machine sm_destination) {
        prefix = Signal_Machine_Operator_Utilities.find_prefix(prefix, sm_destination);
        I_Meta_Signal[] i_Meta_SignalArray = sm_source.get_meta_signals_copy();
        int n = i_Meta_SignalArray.length;
        int n2 = 0;
        while (n2 < n) {
            I_Meta_Signal ki = i_Meta_SignalArray[n2];
            sm_destination.add_meta_signal(String.valueOf(prefix) + ki.get_id(), ki.get_speed()).set_color(ki.get_color());
            ++n2;
        }
        for (Map.Entry<I_Meta_Signal[], I_Meta_Signal[]> entry : sm_source.get_collision_rules_copy().entrySet()) {
            sm_destination.add_collision_rule_by_id(Signal_Machine_Operator_Utilities.prefix_id(entry.getKey(), prefix), Signal_Machine_Operator_Utilities.prefix_id(entry.getValue(), prefix));
        }
        return prefix;
    }

    public static String find_prefix(String prefix, I_Signal_Machine sm) {
        if (!Signal_Machine_Operator_Utilities.is_prefix_present(prefix, sm)) {
            return prefix;
        }
        int n = 0;
        while (Signal_Machine_Operator_Utilities.is_suffix_present(prefix, sm)) {
            ++n;
        }
        return String.valueOf(prefix) + n;
    }

    public static String find_suffix(String suffix, I_Signal_Machine sm) {
        if (!Signal_Machine_Operator_Utilities.is_suffix_present(suffix, sm)) {
            return suffix;
        }
        int n = 0;
        while (Signal_Machine_Operator_Utilities.is_suffix_present(String.valueOf(n) + suffix, sm)) {
            ++n;
        }
        return String.valueOf(n) + suffix;
    }

    public static boolean is_prefix_present(String prefix, I_Signal_Machine mach) {
        I_Meta_Signal[] i_Meta_SignalArray = mach.get_meta_signals_copy();
        int n = i_Meta_SignalArray.length;
        int n2 = 0;
        while (n2 < n) {
            I_Meta_Signal m_s = i_Meta_SignalArray[n2];
            if (m_s.get_id().startsWith(prefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean is_suffix_present(String suffix, I_Signal_Machine mach) {
        I_Meta_Signal[] i_Meta_SignalArray = mach.get_meta_signals_copy();
        int n = i_Meta_SignalArray.length;
        int n2 = 0;
        while (n2 < n) {
            I_Meta_Signal m_s = i_Meta_SignalArray[n2];
            if (m_s.get_id().endsWith(suffix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String[] prefix_id(I_Meta_Signal[] m_s_T, String pref) {
        String[] res = new String[m_s_T.length];
        int i = 0;
        while (i < res.length) {
            res[i] = String.valueOf(pref) + m_s_T[i].get_id();
            ++i;
        }
        return res;
    }

    public static void replace_meta_signal_in_rules(I_Signal_Machine mach, I_Meta_Signal old_ms, I_Meta_Signal new_ms, boolean throw_exception_on_redefine, boolean ignore_Identical_Speed_Exception, boolean also_change_if_only_in_output) {
        I_Meta_Signal[][] key_set;
        I_Meta_Signal[][] i_Meta_SignalArray = key_set = (I_Meta_Signal[][])((I_Meta_Signal[][])mach.get_collision_rules_copy().keySet().toArray((T[])new I_Meta_Signal[0][0])).clone();
        int n = key_set.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                I_Meta_Signal[] key_orig = i_Meta_SignalArray[n2];
                I_Meta_Signal[] key = (I_Meta_Signal[])key_orig.clone();
                I_Meta_Signal[] value = (I_Meta_Signal[])mach.get_collision_rule_output(key).clone();
                boolean is_in_key = false;
                int i = 0;
                while (i < key.length) {
                    if (key[i] == old_ms) {
                        key[i] = new_ms;
                        is_in_key = true;
                        break;
                    }
                    ++i;
                }
                boolean is_in_value = false;
                int i2 = 0;
                while (i2 < value.length) {
                    if (value[i2] == old_ms) {
                        value[i2] = new_ms;
                        is_in_value = true;
                        break;
                    }
                    ++i2;
                }
                try {
                    if ((is_in_key || is_in_value && also_change_if_only_in_output) && mach.add_collision_rule(key, value) != null && is_in_key && throw_exception_on_redefine) {
                        throw new E_Signal_Machine_Operator_Exception("Rule collision in replacing meta-signal \n" + key);
                    }
                }
                catch (E_Identical_Speed_Exception ise) {
                    if (ignore_Identical_Speed_Exception) break block8;
                    throw ise;
                }
            }
            ++n2;
        }
    }

    public static I_Meta_Signal[] add_to_array(I_Meta_Signal[] ms_a, I_Meta_Signal ms) {
        I_Meta_Signal[] ms_s_res = new I_Meta_Signal[ms_a.length + 1];
        int i = ms_a.length - 1;
        while (i >= 0) {
            ms_s_res[i] = ms_a[i];
            --i;
        }
        ms_s_res[ms_s_res.length - 1] = ms;
        return ms_s_res;
    }

    public static boolean is_speed_in(Rational speed, I_Meta_Signal[] in) {
        I_Meta_Signal[] i_Meta_SignalArray = in;
        int n = in.length;
        int n2 = 0;
        while (n2 < n) {
            I_Meta_Signal m_s = i_Meta_SignalArray[n2];
            if (m_s.get_speed().compareTo(speed) == 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

