/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.run;

import fr.univ_orleans.jdl.agc.driver.Driver_Import_AGC;
import java.io.IOException;

public class Run_AGC {
    private static final int JAVA_VERSION_MINIMUM = 11;
    private static final String ERROR_MESSAGE_JAVA_VERSION = "Must use Java 11 or higher to run";

    private static int get_version() {
        String version = System.getProperty("java.specification.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(46);
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    public static void main(String[] args) {
        if (Run_AGC.get_version() < 11) {
            System.err.println(ERROR_MESSAGE_JAVA_VERSION);
            System.exit(1);
        }
        try {
            if (args.length < 1) {
                System.err.println("Use ^d to finish the input, agc code is executed then");
                new Driver_Import_AGC(System.in, "standard input");
            } else {
                String base_name = args[0].replaceFirst(".agc$", "");
                new Driver_Import_AGC(String.valueOf(base_name) + ".agc");
            }
        }
        catch (IOException ioe) {
            System.err.println("FAIL opening / reading\n" + ioe);
        }
        catch (Exception e) {
            System.err.println("Syntax: java file #iterations\n" + e);
            e.printStackTrace();
        }
    }
}

