/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.agc.util;

import fr.univ_orleans.jdl.agc.I_Configuration;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Run;
import fr.univ_orleans.jdl.agc.I_Signal;
import fr.univ_orleans.jdl.agc.I_Signal_Machine;
import fr.univ_orleans.jdl.agc.kernel.Collision;
import fr.univ_orleans.jdl.agc.kernel.Run;
import fr.univ_orleans.jdl.agc.util.Util_Meta_Signal;
import java.io.PrintStream;

public class Util_Print {
    static final PrintStream DEFAULT_PRINT_STREAM = System.out;

    private Util_Print() {
    }

    public static void print_collision_rules(I_Signal_Machine sm) {
        Util_Print.print_collision_rules(sm, DEFAULT_PRINT_STREAM);
    }

    public static void print_collision_rules(I_Signal_Machine sm, PrintStream ps) {
        ps.println("## List of collision rules");
        for (I_Meta_Signal[] t : sm.get_collision_rules_copy().keySet()) {
            ps.print("{ ");
            Util_Print.print_list_id(ps, t);
            ps.print(" } --> { ");
            Util_Print.print_list_id(ps, sm.get_collision_rule_output(t));
            ps.println(" } ;");
        }
    }

    public static void print_forecasted_collisions(I_Run run) {
        Util_Print.print_forecasted_collisions((Run)run, DEFAULT_PRINT_STREAM);
    }

    public static void print_forecasted_collisions(Run run) {
        Util_Print.print_forecasted_collisions(run, DEFAULT_PRINT_STREAM);
    }

    public static void print_forecasted_collisions(Run run, PrintStream ps) {
        ps.println("## List of forcasted collisions");
        if (run.has_collision()) {
            for (Collision c : run.get_forecasted_collisions_copy()) {
                ps.println(c);
            }
        } else {
            ps.println(" no forcasted collisions");
        }
    }

    static void print_list_id(I_Meta_Signal[] t) {
        Util_Print.print_list_id(DEFAULT_PRINT_STREAM, t);
    }

    static void print_list_id(PrintStream ps, I_Meta_Signal[] t) {
        ps.print(Util_Meta_Signal.to_string(t));
    }

    public static void print_meta_signals(I_Signal_Machine sm) {
        Util_Print.print_meta_signals(sm, DEFAULT_PRINT_STREAM);
    }

    public static void print_meta_signals(I_Signal_Machine sm, PrintStream ps) {
        ps.println("## List of meta_signal_set");
        I_Meta_Signal[] i_Meta_SignalArray = sm.get_meta_signals_copy();
        int n = i_Meta_SignalArray.length;
        int n2 = 0;
        while (n2 < n) {
            I_Meta_Signal k = i_Meta_SignalArray[n2];
            ps.println(k + " ;");
            ++n2;
        }
    }

    public static void print_present_signals(I_Configuration conf) {
        Util_Print.print_present_signals(conf, DEFAULT_PRINT_STREAM);
    }

    public static void print_present_signals(I_Configuration conf, PrintStream ps) {
        ps.println("## List of present signals");
        if (conf.has_signals()) {
            for (I_Signal sig : conf.get_signals()) {
                ps.println(sig);
            }
        } else {
            ps.println(" no signal present");
        }
    }

    public static void print_present_signals_with_position(I_Configuration conf) {
        Util_Print.print_present_signals_with_position(conf, DEFAULT_PRINT_STREAM);
    }

    public static void print_present_signals_with_position(I_Configuration conf, PrintStream ps) {
        ps.println("## List of present signals");
        if (conf.has_signals()) {
            for (I_Signal sig : conf.get_signals()) {
                ps.println(sig + " at " + sig.get_position_at(conf.get_date()));
            }
        } else {
            ps.println(" no signal present");
        }
    }
}

