/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.library.AGC;

import com.itextpdf.text.DocumentException;
import fr.univ_orleans.jdl.agc.AGC_Center;
import fr.univ_orleans.jdl.agc.I_Run;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_Run_Writer;
import fr.univ_orleans.jdl.agc.util.Util_Print;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Exception_Impossible_Operation;
import fr.univ_orleans.jdl.language.exception.Exception_Library;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.exception.RuntimeException_Wrapper;
import fr.univ_orleans.jdl.language.library.AGC.AGC_Configuration;
import fr.univ_orleans.jdl.language.library.AGC.AGC_Signal_Machine;
import fr.univ_orleans.jdl.language.library.AGC.Library_Main;
import fr.univ_orleans.jdl.language.value.I_Value_Iterable;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Constant_Predefined;
import fr.univ_orleans.jdl.language.value.Value_Context;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Abstract;
import fr.univ_orleans.jdl.language.value.Value_Function;
import fr.univ_orleans.jdl.language.value.Value_Holder_Abstract;
import fr.univ_orleans.jdl.language.value.Value_Number;
import fr.univ_orleans.jdl.language.value.Value_Special;
import fr.univ_orleans.jdl.language.value.Value_String;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class AGC_Run
extends AGC_Configuration {
    private static Map<String, Function<AGC_Run, Value>> value_predefined = Map.ofEntries(Map.entry("step", Step::new), Map.entry("until", Until::new), Map.entry("export", Export::new), Map.entry("print_signal_list", run -> new Value_Function(Library_Main.ORIGIN, (AGC_Run)run){
        private final /* synthetic */ AGC_Run val$run;
        {
            this.val$run = aGC_Run;
            super($anonymous0);
        }

        @Override
        public Value call(I_Chunk_Origin origin, Eval_Context e_c, List<Value> args_val) {
            Util_Print.print_present_signals(this.val$run.conf);
            return new Value_Special.Value_Void(origin);
        }
    }));

    public AGC_Run(I_Chunk_Origin origin, AGC_Signal_Machine machine, I_Run run) {
        super(origin, machine, run);
    }

    @Override
    String get_KW() {
        return "run";
    }

    @Override
    protected Value_Holder_Abstract get_predefined(String id) {
        Function<AGC_Run, Value> gen = value_predefined.get(id);
        if (gen != null) {
            return new Value_Constant_Predefined(Library_Main.ORIGIN, gen.apply(this));
        }
        return super.get_predefined(id);
    }

    static class Creator
    extends Value_Function {
        public static final String KW_CREATE = "run";
        final AGC_Configuration context_conf;

        public Creator(AGC_Configuration context_conf) {
            super(Library_Main.ORIGIN);
            this.context_conf = context_conf;
        }

        @Override
        public Value call(I_Chunk_Origin origin, Eval_Context e_c, List<Value> args_val) throws Language_Throwable {
            if (1 == args_val.size()) {
                Value_Number vn;
                Value v1 = args_val.remove(0);
                if (v1 instanceof Value_Number && (vn = (Value_Number)v1).is_integer()) {
                    return this.context_conf.context_machine.get_configuration(vn.get_int_value() - 1L);
                }
            } else if (args_val.isEmpty()) {
                I_Run run = this.context_conf.conf.run();
                return new AGC_Run(origin, this.context_conf.context_machine, run);
            }
            this.throw_type_error("argument should be () or ( delay: number )");
            return null;
        }
    }

    static class Export
    extends Value_Function {
        final AGC_Run context_run;
        public static final String KW = "export";

        Export(AGC_Run context_run) {
            super(Library_Main.ORIGIN);
            this.context_run = context_run;
        }

        @Override
        public Value call(I_Chunk_Origin origin, Eval_Context e_c, List<Value> args_val) throws Language_Throwable {
            if (2 <= args_val.size() && args_val.size() <= 3) {
                Value type_v = args_val.remove(0).get_ground_value();
                Value file_v = args_val.remove(0).get_ground_value();
                if (type_v instanceof Value_String && file_v instanceof Value_String) {
                    Value param_v;
                    String type = ((Value_String)type_v).str;
                    String file = ((Value_String)file_v).str.replace("~", System.getProperty("user.home"));
                    Driver_Export_Run_Writer derw = AGC_Center.create_driver_export_run_writer(type, (I_Run)this.context_run.conf);
                    if (derw == null) {
                        throw new Exception_Impossible_Operation(origin, "No driver foung for " + type);
                    }
                    if (!(args_val.isEmpty() || (param_v = args_val.remove(0).get_ground_value()) instanceof I_Value_Iterable && ((I_Value_Iterable)((Object)param_v)).is_empty())) {
                        Value_Context param = ((Value_Context_Holder_Abstract)param_v).get_context();
                        try {
                            param.affectation_stream().forEach(s -> {
                                String label = (String)s.getKey();
                                try {
                                    switch (label) {
                                        case "clip_end": {
                                            derw.set_clipping_end(((Value_Holder_Abstract)s.getValue()).get_number().get_rational_value());
                                            break;
                                        }
                                        case "clip_left": {
                                            derw.set_clipping_left(((Value_Holder_Abstract)s.getValue()).get_number().get_rational_value());
                                            break;
                                        }
                                        case "clip_right": {
                                            derw.set_clipping_right(((Value_Holder_Abstract)s.getValue()).get_number().get_rational_value());
                                            break;
                                        }
                                        case "clip_start": {
                                            derw.set_clipping_start(((Value_Holder_Abstract)s.getValue()).get_number().get_rational_value());
                                            break;
                                        }
                                        case "scale": {
                                            derw.set_scale(((Value_Holder_Abstract)s.getValue()).get_number().get_rational_value());
                                            break;
                                        }
                                        case "scale_x": {
                                            derw.set_scale_x(((Value_Holder_Abstract)s.getValue()).get_number().get_rational_value());
                                            break;
                                        }
                                        case "scale_y": {
                                            derw.set_scale_y(((Value_Holder_Abstract)s.getValue()).get_number().get_rational_value());
                                            break;
                                        }
                                        default: {
                                            throw new Exception_Impossible_Operation(Library_Main.ORIGIN, "Unknown parameter " + label);
                                        }
                                    }
                                }
                                catch (Language_Throwable e) {
                                    throw new RuntimeException_Wrapper(e);
                                }
                            });
                        }
                        catch (RuntimeException_Wrapper e) {
                            throw e.get_Language_Throwable();
                        }
                    }
                    try {
                        derw.write_diagram(file);
                    }
                    catch (DocumentException | IOException e) {
                        e.printStackTrace();
                    }
                    return this.context_run;
                }
            }
            this.throw_type_error("argument should be ( type : String , File : String [ . option := value ] )");
            return null;
        }
    }

    static class Step
    extends Value_Function {
        final AGC_Run context_run;
        private static final String KW = "step";

        Step(AGC_Run context_run) {
            super(Library_Main.ORIGIN);
            this.context_run = context_run;
        }

        @Override
        public Value call(I_Chunk_Origin origin, Eval_Context e_c, List<Value> args_val) throws Language_Throwable {
            Value_Number vn;
            Value v1;
            if (args_val.isEmpty()) {
                ((I_Run)this.context_run.conf).make_next_collision();
                return this.context_run;
            }
            if (1 == args_val.size() && (v1 = args_val.remove(0)) instanceof Value_Number && (vn = (Value_Number)v1).is_integer()) {
                try {
                    ((I_Run)this.context_run.conf).make_collision_step(vn.get_int_value());
                }
                catch (Exception e) {
                    throw new Exception_Library(origin, (Throwable)e);
                }
                return this.context_run;
            }
            this.throw_type_error("argument should be ( <number of steps> : integral )");
            return null;
        }
    }

    static class Until
    extends Value_Function {
        final AGC_Run context_run;
        private static final String KW = "until";

        Until(AGC_Run context_run) {
            super(Library_Main.ORIGIN);
            this.context_run = context_run;
        }

        @Override
        public Value call(I_Chunk_Origin origin, Eval_Context e_c, List<Value> args_val) throws Language_Throwable {
            Value v1;
            int nb_arg = args_val.size();
            if (1 <= nb_arg && nb_arg <= 2 && (v1 = args_val.remove(0)) instanceof Value_Number) {
                Value_Number vn1 = (Value_Number)v1;
                if (1 == nb_arg) {
                    try {
                        ((I_Run)this.context_run.conf).make_collision_until(vn1.get_rational_value());
                    }
                    catch (Exception e) {
                        throw new Exception_Library(origin, (Throwable)e);
                    }
                    return this.context_run;
                }
                Value v2 = args_val.remove(0);
                if (v2 instanceof Value_Number) {
                    Value_Number vn2 = (Value_Number)v2;
                    try {
                        ((I_Run)this.context_run.conf).make_collision_until_limited(vn1.get_rational_value(), vn2.get_int_value());
                    }
                    catch (Exception e) {
                        throw new Exception_Library(origin, (Throwable)e);
                    }
                    return this.context_run;
                }
            }
            this.throw_type_error("argument should be ( < limit_date : rational > , [ <number of steps> : integral ] )");
            return null;
        }
    }
}

