/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.library.AGC;

import fr.univ_orleans.jdl.agc.AGC_Center;
import fr.univ_orleans.jdl.agc.I_Collision;
import fr.univ_orleans.jdl.agc.I_Configuration;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Signal;
import fr.univ_orleans.jdl.agc.I_Signal_Machine;
import fr.univ_orleans.jdl.agc.I_Undefined_Collision_Rule;
import fr.univ_orleans.jdl.agc.kernel.Rule_Comparator;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Exception_Constant_Assignment;
import fr.univ_orleans.jdl.language.exception.Exception_Impossible_Operation;
import fr.univ_orleans.jdl.language.exception.Exception_Library;
import fr.univ_orleans.jdl.language.exception.Exception_Type_Error;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.library.AGC.AGC_Collision_Rule;
import fr.univ_orleans.jdl.language.library.AGC.AGC_Configuration;
import fr.univ_orleans.jdl.language.library.AGC.AGC_Meta_Signal;
import fr.univ_orleans.jdl.language.library.AGC.Library_Main;
import fr.univ_orleans.jdl.language.value.I_Value_Iterable;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Constant_Predefined;
import fr.univ_orleans.jdl.language.value.Value_Context;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Abstract;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Basic;
import fr.univ_orleans.jdl.language.value.Value_Function;
import fr.univ_orleans.jdl.language.value.Value_Function_Abstract;
import fr.univ_orleans.jdl.language.value.Value_Holder_Abstract;
import fr.univ_orleans.jdl.language.value.Value_Label;
import fr.univ_orleans.jdl.language.value.Value_Label_Abstract;
import fr.univ_orleans.jdl.language.value.Value_List;
import fr.univ_orleans.jdl.language.value.Value_Number;
import fr.univ_orleans.jdl.language.value.Value_Special;
import fr.univ_orleans.jdl.language.value.Value_String;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AGC_Signal_Machine
extends Value_Context {
    public static final Value_Function_Abstract creator = new Value_Function_Abstract(Library_Main.ORIGIN){

        @Override
        public Value call(I_Chunk_Origin origin, Eval_Context e_c, List<Value> args_val) throws Language_Throwable {
            if (!args_val.isEmpty()) {
                this.throw_type_error("Does not take any argument: create_signal_machine");
            }
            return new AGC_Signal_Machine(origin, e_c);
        }
    };
    public static final String KW_CREATE = "create_signal_machine";
    public static final String LABEL_UNDEFINED_RULE = "undefined_rule";
    private static Map<String, Function<AGC_Signal_Machine, Value>> value_predefined = Map.ofEntries(Map.entry("add_meta_signal", Add_Meta_Signal::new), Map.entry("create_configuration", AGC_Configuration.Creator::new), Map.entry("-->", Add_Collision_Rule::new), Map.entry("to_string", To_String::new), Map.entry("get_meta_signal", Get_Meta_Signal::new), Map.entry("get_meta_signal_list", Get_Meta_Signal_List::new), Map.entry("get_rule_output", Get_Rule_Output::new), Map.entry("get_rule_list", Get_Rule_List::new));
    private final TreeMap<I_Meta_Signal[], AGC_Collision_Rule> collision_rule_map = new TreeMap(new Rule_Comparator());
    List<AGC_Configuration> configuration_list = new LinkedList<AGC_Configuration>();
    private Value_Label_Abstract label_udefined_rule;
    final I_Signal_Machine mach = AGC_Center.create_signal_machine();
    private final HashMap<String, AGC_Meta_Signal> meta_signal_map = new HashMap();
    private final Eval_Context e_c;

    public static String to_string_method(I_Signal_Machine sm, List<AGC_Configuration> configuration_list) {
        Context_To_String_Code ctsc = new Context_To_String_Code();
        ctsc.increase_prefix();
        String inner = AGC_Signal_Machine.to_string_method_inner(ctsc, sm, configuration_list);
        return "create_signal_machine () {" + (inner.isEmpty() ? inner : String.valueOf(inner) + '\n') + "}" + " ;";
    }

    private static String to_string_method_inner(Context_To_String_Code ctsc, I_Signal_Machine sm, List<AGC_Configuration> configuration_list) {
        String pref = String.valueOf('\n') + ctsc.get_prefix();
        StringBuilder res = new StringBuilder(String.valueOf(sm.get_meta_signal_stream().map(ms -> String.valueOf(pref) + AGC_Meta_Signal.to_string_meta_signal(ctsc, ms) + " ;").collect(Collectors.joining())) + sm.get_rule_stream().map(rule -> String.valueOf(pref) + AGC_Collision_Rule.to_string_rule((List)rule.getKey(), (List)rule.getValue()) + " ;").collect(Collectors.joining()));
        int i = 1;
        for (AGC_Configuration conf : configuration_list) {
            res.append(String.valueOf(pref) + "//" + " " + conf.get_KW() + " " + "(" + " " + i + " " + ")" + pref + conf.to_string_conf(ctsc) + " ;");
            ++i;
        }
        return res.toString();
    }

    public AGC_Signal_Machine(I_Chunk_Origin origin, Eval_Context e_c) {
        super(origin);
        this.e_c = e_c;
    }

    public AGC_Signal_Machine(I_Chunk_Origin origin) {
        this(origin, null);
    }

    public AGC_Meta_Signal get_agc_meta_signal(String id) {
        return this.meta_signal_map.get(id);
    }

    public AGC_Configuration get_configuration(long i) {
        return this.configuration_list.get((int)i);
    }

    public Stream<I_Configuration> get_configuration_stream() {
        return this.configuration_list.stream().map(AGC_Configuration::get_configuration);
    }

    @Override
    public Value_Label_Abstract get_label_association(final Value v) {
        String lab = null;
        if (v instanceof Value_Label) {
            lab = ((Value_Label)v).id;
        } else {
            Value v_grnd = v.get_ground_value();
            if (v_grnd instanceof Value_String) {
                lab = ((Value_String)v_grnd).str;
            }
        }
        if (LABEL_UNDEFINED_RULE.equals(lab)) {
            if (this.label_udefined_rule == null) {
                this.label_udefined_rule = new Value_Label(Library_Main.ORIGIN, LABEL_UNDEFINED_RULE, this){

                    @Override
                    protected void register() {
                        AGC_Signal_Machine.this.register_label(this);
                    }

                    @Override
                    public void set_value(Value val) throws Exception_Constant_Assignment, Exception_Type_Error, Exception_Impossible_Operation {
                        if (val instanceof Value_String) {
                            String name = ((Value_String)val).str;
                            try {
                                Class<?> cla;
                                Class<?> ufrc_class = cla = Class.forName(name);
                                Constructor<?>[] constructorArray = ufrc_class.getDeclaredConstructors();
                                int n = constructorArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Constructor<?> constructor = constructorArray[n2];
                                    if (1 == constructor.getParameterCount() && I_Signal_Machine.class == constructor.getParameterTypes()[0]) {
                                        I_Undefined_Collision_Rule ucrf = (I_Undefined_Collision_Rule)constructor.newInstance(AGC_Signal_Machine.this.mach);
                                        AGC_Signal_Machine.this.mach.set_undefined_rule(ucrf);
                                        return;
                                    }
                                    if (constructor.getParameterCount() == 0) {
                                        I_Undefined_Collision_Rule ucrf = (I_Undefined_Collision_Rule)constructor.newInstance(new Object[0]);
                                        AGC_Signal_Machine.this.mach.set_undefined_rule(ucrf);
                                        return;
                                    }
                                    ++n2;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.throw_operation_impossible("Impossible to load the class " + name);
                            }
                        } else if (val instanceof Value_Function) {
                            AGC_Signal_Machine.this.mach.set_undefined_rule(new I_Undefined_Collision_Rule(val){
                                final Value_Function fct;
                                {
                                    this.fct = (Value_Function)value;
                                }

                                @Override
                                public I_Meta_Signal[] get_undefined_rule_output(I_Collision enc) {
                                    Value res;
                                    Value_List ms_list = new Value_List(origin);
                                    I_Signal[] i_SignalArray = enc.get_signals_in();
                                    int n = i_SignalArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        I_Signal s = i_SignalArray[n2];
                                        ms_list.add(AGC_Signal_Machine.this.get_agc_meta_signal(s.get_meta_signal().get_id()));
                                        ++n2;
                                    }
                                    ArrayList<Value> args = new ArrayList<Value>();
                                    args.add(ms_list);
                                    try {
                                        res = this.fct.call(origin, (this).AGC_Signal_Machine.this.e_c, args);
                                    }
                                    catch (Language_Throwable e) {
                                        e.printStackTrace();
                                        System.err.println("Impossible to evaluate the default collision rule");
                                        return null;
                                    }
                                    if (res instanceof Value_List) {
                                        Value_List res_vl = (Value_List)res;
                                        boolean is_ok = true;
                                        ArrayList<I_Meta_Signal> ms_out_list = new ArrayList<I_Meta_Signal>();
                                        for (Value v2 : res_vl) {
                                            Value v_gr = v2.get_ground_value();
                                            if (v_gr instanceof Value_Context_Holder_Basic) {
                                                v_gr = ((Value_Context_Holder_Basic)v_gr).context;
                                            }
                                            if (v_gr instanceof AGC_Meta_Signal) {
                                                ms_out_list.add(((AGC_Meta_Signal)v_gr).meta_signal);
                                                continue;
                                            }
                                            if (v_gr instanceof Value_String) {
                                                I_Meta_Signal ms = (this).AGC_Signal_Machine.this.mach.get_meta_signal(((Value_String)v_gr).str);
                                                ms_out_list.add(ms);
                                                continue;
                                            }
                                            is_ok = false;
                                        }
                                        if (is_ok) {
                                            return ms_out_list.toArray(new I_Meta_Signal[ms_out_list.size()]);
                                        }
                                    }
                                    System.err.println("The default collision rule function should return a list of meta-signals and strings (id's):\n\t" + v);
                                    return null;
                                }
                            });
                        } else {
                            this.throw_type_error("This is a special assing, only string (to design a java class) or a function are allowed");
                        }
                    }

                    @Override
                    public String to_string(Context_To_String_Code ctsc) {
                        return String.valueOf(this.to_string_just_label()) + "\"" + AGC_Signal_Machine.this.mach.get_undefined_rule().getClass().getName();
                    }

                    @Override
                    public String to_string_just_label() {
                        return AGC_Signal_Machine.LABEL_UNDEFINED_RULE;
                    }
                };
            }
            return this.label_udefined_rule;
        }
        return super.get_label_association(v);
    }

    @Override
    protected Value_Holder_Abstract get_predefined(String id) {
        Function<AGC_Signal_Machine, Value> gen = value_predefined.get(id);
        if (gen != null) {
            return new Value_Constant_Predefined(Library_Main.ORIGIN, gen.apply(this));
        }
        return null;
    }

    public I_Signal_Machine get_signal_machine() {
        return this.mach;
    }

    void register(AGC_Collision_Rule rule) {
        this.collision_rule_map.put(rule.key_in, rule);
    }

    int register(AGC_Configuration configuration) {
        this.configuration_list.add(configuration);
        return this.configuration_list.size();
    }

    void register(AGC_Meta_Signal ms) {
        this.meta_signal_map.put(ms.get_id(), ms);
    }

    AGC_Meta_Signal to_AGC_meta_signal(Value a_in) throws Language_Throwable {
        block8: {
            try {
                Value a = a_in.get_ground_value();
                if (a instanceof AGC_Meta_Signal) {
                    return (AGC_Meta_Signal)a;
                }
                if (a instanceof Value_Context_Holder_Abstract) {
                    Value_Context vc = ((Value_Context_Holder_Abstract)a).get_context();
                    if (vc instanceof AGC_Meta_Signal) {
                        return (AGC_Meta_Signal)vc;
                    }
                    break block8;
                }
                if (!(a instanceof Value_String)) break block8;
                String id = ((Value_String)a).str;
                AGC_Meta_Signal ams = this.meta_signal_map.get(id);
                if (ams != null) {
                    return ams;
                }
                I_Meta_Signal ms = this.mach.get_meta_signal(id);
                if (ms != null) {
                    return new AGC_Meta_Signal(this.origin, ms, this);
                }
                this.throw_type_error("Does not refer to a meta-signal" + a);
                return null;
            }
            catch (Exception t) {
                throw new Exception_Library(a_in.origin, (Throwable)t);
            }
        }
        this.throw_type_error(a_in.origin, "Must be a meta-signal: " + a_in);
        return null;
    }

    Value_List to_AGC_meta_signal_set(Value val) throws Language_Throwable {
        if (!(val instanceof I_Value_Iterable)) {
            this.throw_type_error("Must be a set of meta-signals: " + val);
        }
        Value_List l_ms = new Value_List(this.origin);
        for (Value a : (I_Value_Iterable)((Object)val)) {
            try {
                l_ms.add(this.to_AGC_meta_signal(a));
            }
            catch (Language_Throwable e) {
                e.printStackTrace();
                throw new Exception_Library(val.origin, (Throwable)e);
            }
        }
        return l_ms;
    }

    @Override
    protected String to_string_closing(Context_To_String_Code ctsc) {
        return "}";
    }

    public String to_string_method() {
        return AGC_Signal_Machine.to_string_method(this.mach, this.configuration_list);
    }

    @Override
    protected String to_string_opening(Context_To_String_Code ctsc) {
        ctsc.increase_prefix();
        String res = "create_signal_machine () {" + AGC_Signal_Machine.to_string_method_inner(ctsc, this.mach, this.configuration_list);
        ctsc.pop_prefix();
        return res;
    }

    static class Add_Collision_Rule
    extends Value_Function {
        final AGC_Signal_Machine context_sm;
        public static final String SYMBOL_AGC_RULE = "-->";

        Add_Collision_Rule(AGC_Signal_Machine context_sm) {
            super(Library_Main.ORIGIN);
            this.context_sm = context_sm;
        }

        @Override
        public Value call(I_Chunk_Origin origin, Eval_Context e_c, List<Value> args_val) throws Language_Throwable {
            assert (2 == args_val.size());
            Value_List set_in = this.context_sm.to_AGC_meta_signal_set(args_val.remove(0));
            Value_List set_out = this.context_sm.to_AGC_meta_signal_set(args_val.remove(0));
            return new AGC_Collision_Rule(origin, this.context_sm, set_in, set_out);
        }
    }

    static class Add_Meta_Signal
    extends Value_Function {
        public static final String KW = "add_meta_signal";
        static final String MESSAGE_ERROR_TYPE = "Arguents for add_meta_signal are ( :String , :Rational ) or ( :String)";
        final AGC_Signal_Machine context_sm;

        Add_Meta_Signal(AGC_Signal_Machine context_sm) {
            super(Library_Main.ORIGIN);
            this.context_sm = context_sm;
        }

        @Override
        public Value call(I_Chunk_Origin origin, Eval_Context e_c, List<Value> args_val) throws Language_Throwable {
            Value arg1;
            if (1 == args_val.size() && (arg1 = args_val.get(0)) instanceof Value_String) {
                return this.context_sm.to_AGC_meta_signal(arg1);
            }
            if (2 == args_val.size()) {
                arg1 = args_val.get(0);
                Value arg2 = args_val.get(1);
                if (arg1 instanceof Value_String && arg2 instanceof Value_Number) {
                    return new AGC_Meta_Signal(origin, this.context_sm, (Value_String)arg1, (Value_Number)arg2);
                }
            }
            this.throw_type_error(MESSAGE_ERROR_TYPE);
            return null;
        }
    }

    private static class Get_Meta_Signal
    extends Value_Function {
        public static final String KW = "get_meta_signal";
        final AGC_Signal_Machine context_sm;

        Get_Meta_Signal(AGC_Signal_Machine context_sm) {
            super(Library_Main.ORIGIN);
            this.context_sm = context_sm;
        }

        @Override
        public Value call(I_Chunk_Origin origin, Eval_Context e_c, List<Value> args_val) throws Language_Throwable {
            assert (1 == args_val.size());
            Value val = this.context_sm.meta_signal_map.get(args_val.get(0).get_ground_value().toString());
            return val == null ? new Value_Special.Value_Void(origin) : val;
        }
    }

    private static class Get_Meta_Signal_List
    extends Value_Function {
        public static final String KW = "get_meta_signal_list";
        final AGC_Signal_Machine context_sm;

        Get_Meta_Signal_List(AGC_Signal_Machine context_sm) {
            super(Library_Main.ORIGIN);
            this.context_sm = context_sm;
        }

        @Override
        public Value call(I_Chunk_Origin origin, Eval_Context e_c, List<Value> args_val) throws Language_Throwable {
            assert (args_val.isEmpty());
            Value_List vl = new Value_List(Library_Main.ORIGIN);
            this.context_sm.meta_signal_map.forEach((k, ms) -> vl.add((Value)ms));
            return vl;
        }
    }

    private static class Get_Rule_List
    extends Value_Function {
        public static final String KW = "get_rule_list";
        final AGC_Signal_Machine context_sm;

        Get_Rule_List(AGC_Signal_Machine context_sm) {
            super(Library_Main.ORIGIN);
            this.context_sm = context_sm;
        }

        @Override
        public Value call(I_Chunk_Origin origin, Eval_Context e_c, List<Value> args_val) throws Language_Throwable {
            assert (args_val.isEmpty());
            Value_List vl = new Value_List(Library_Main.ORIGIN);
            this.context_sm.collision_rule_map.forEach((k, r) -> vl.add((Value)r));
            return vl;
        }
    }

    private static class Get_Rule_Output
    extends Value_Function {
        public static final String KW = "get_rule_output";
        final AGC_Signal_Machine context_sm;

        Get_Rule_Output(AGC_Signal_Machine context_sm) {
            super(Library_Main.ORIGIN);
            this.context_sm = context_sm;
        }

        @Override
        public Value call(I_Chunk_Origin origin, Eval_Context e_c, List<Value> args_val) throws Language_Throwable {
            assert (1 == args_val.size());
            Value arg = args_val.get(0).get_ground_value();
            Value_List key = this.context_sm.to_AGC_meta_signal_set(arg);
            I_Meta_Signal[] key_i = AGC_Collision_Rule.to_I_MS(key);
            AGC_Collision_Rule rule = this.context_sm.collision_rule_map.get(key_i);
            return rule == null ? new Value_Special.Value_Void(origin) : (Value)((Object)rule.out);
        }
    }

    static class To_String
    extends Value_Function {
        final AGC_Signal_Machine context_sm;

        To_String(AGC_Signal_Machine context_sm) {
            super(Library_Main.ORIGIN);
            this.context_sm = context_sm;
        }

        @Override
        public Value call(I_Chunk_Origin origin, Eval_Context e_c, List<Value> args_val) throws Language_Throwable {
            if (!args_val.isEmpty()) {
                this.throw_type_error("There must be no argument");
            }
            return new Value_String(origin, this.context_sm.to_string_method());
        }
    }
}

