/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.operator;

import fr.univ_orleans.jdl.language.Chunk;
import fr.univ_orleans.jdl.language.Constant_Operator;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.operator.OP;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Variable_Abstract;

public class OP_Affectation
extends OP {
    final Chunk expression;
    final Chunk label_chunk;

    public OP_Affectation(I_Chunk_Origin origin, Chunk label, Chunk expression) {
        super(origin);
        this.label_chunk = label;
        this.expression = expression;
    }

    @Override
    public Value eval(Eval_Context e_c) throws Language_Throwable {
        Value v = this.expression.eval(e_c);
        Value vlab = this.label_chunk.eval(e_c);
        if (!(vlab instanceof Value_Variable_Abstract)) {
            this.throw_type_error("Should be a variable: " + this.label_chunk + " -> " + vlab);
        }
        Value_Variable_Abstract vl = (Value_Variable_Abstract)vlab;
        vl.set_value(v);
        return v;
    }

    @Override
    public Constant_Operator.Priority get_priority() {
        return Constant_Operator.PRIORITY_AFFECTATION;
    }

    @Override
    public String to_code(Context_To_String_Code tcc) {
        return String.valueOf(this.to_code_opt_parenthesis(tcc, this.label_chunk)) + " " + ":=" + " " + this.to_code_opt_parenthesis(tcc, this.expression);
    }

    @Override
    public String to_string(Context_To_String_Code tcc) {
        return String.valueOf(this.to_string_opt_parenthesis(tcc, this.label_chunk)) + " " + ":=" + " " + this.to_string_opt_parenthesis(tcc, this.expression);
    }
}

