/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.operator;

import fr.univ_orleans.jdl.language.Chunk;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Exception_Impossible_Operation;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.operator.OP_Addition;
import fr.univ_orleans.jdl.language.operator.OP_Binary;
import fr.univ_orleans.jdl.language.operator.OP_Division;
import fr.univ_orleans.jdl.language.operator.OP_Division_Integral;
import fr.univ_orleans.jdl.language.operator.OP_Product;
import fr.univ_orleans.jdl.language.operator.OP_Remainder;
import fr.univ_orleans.jdl.language.operator.OP_Subtraction;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Number;

public abstract class OP_Binary_Number
extends OP_Binary {
    public static OP_Binary_Number create_operator_binary_number(I_Chunk_Origin origin, Chunk chunk_left, Chunk chunk_right, OP_Binary_Number_Type type) {
        switch (type) {
            case OP_ADDITION: {
                return new OP_Addition(origin, chunk_left, chunk_right);
            }
            case OP_DIVISION: {
                return new OP_Division(origin, chunk_left, chunk_right);
            }
            case OP_DIVISION_INTEGRAL: {
                return new OP_Division_Integral(origin, chunk_left, chunk_right);
            }
            case OP_PRODUCT: {
                return new OP_Product(origin, chunk_left, chunk_right);
            }
            case OP_REMAINDER: {
                return new OP_Remainder(origin, chunk_left, chunk_right);
            }
            case OP_SUBTRACTION: {
                return new OP_Subtraction(origin, chunk_left, chunk_right);
            }
        }
        return null;
    }

    public OP_Binary_Number(I_Chunk_Origin origin, Chunk operand_left, Chunk operand_right) {
        super(origin, operand_left, operand_right);
    }

    @Override
    public Value eval(Eval_Context e_c) throws Language_Throwable {
        Value res;
        Value v_l = this.eval_left(e_c);
        Value v_r = this.eval_right(e_c);
        if (!(v_l instanceof Value_Number)) {
            this.throw_type_error("expecting number as left operand: \"" + v_l + "\"");
        }
        if (!(v_r instanceof Value_Number)) {
            this.throw_type_error("expecting number as right operand: \"" + v_r + "\"");
        }
        if ((res = this.eval_binary((Value_Number)v_l, (Value_Number)v_r)) == null) {
            this.throw_operation_impossible(this.get_symbol());
        }
        return res;
    }

    abstract Value eval_binary(Value_Number var1, Value_Number var2) throws Exception_Impossible_Operation;

    public static enum OP_Binary_Number_Type {
        OP_ADDITION,
        OP_DIVISION,
        OP_DIVISION_INTEGRAL,
        OP_PRODUCT,
        OP_REMAINDER,
        OP_SUBTRACTION;

    }
}

