/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.operator;

import fr.univ_orleans.jdl.language.Chunk;
import fr.univ_orleans.jdl.language.Constant_Operator;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.operator.OP;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Context;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Abstract;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Basic;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class OP_Block
extends OP {
    protected final List<Chunk> sequence = new LinkedList<Chunk>();

    public OP_Block(I_Chunk_Origin origin) {
        super(origin);
    }

    @Override
    public Constant_Operator.Priority get_priority() {
        return Constant_Operator.PRIORITY_VALUE_ATOMIC;
    }

    public void add(Chunk ch) {
        this.sequence.add(ch);
    }

    public Value eval(Eval_Context e_c, Value_Context_Holder_Abstract block_context_holder) throws Language_Throwable {
        if (block_context_holder != null) {
            e_c.push_block(block_context_holder);
        }
        try {
            for (Chunk c : this.sequence) {
                c.eval(e_c);
            }
        }
        finally {
            if (block_context_holder != null) {
                e_c.pop_block();
            }
        }
        return block_context_holder;
    }

    @Override
    public Value eval(Eval_Context e_c) throws Language_Throwable {
        return this.eval(e_c, this.create_new_context(e_c));
    }

    protected Value_Context_Holder_Abstract create_new_context(Eval_Context e_c) {
        return new Value_Context_Holder_Basic(this.origin, e_c.get_current_block(), new Value_Context(this.origin));
    }

    @Override
    public String to_code(Context_To_String_Code tsc) {
        tsc.increase_prefix();
        String res = this.to_code_opening(tsc);
        String string_addition = this.to_code_addition(tsc);
        boolean is_not_empty = !this.sequence.isEmpty() || !"".equals(string_addition);
        String pref = tsc.get_prefix();
        if (is_not_empty) {
            res = String.valueOf(res) + "\n" + this.sequence.stream().map(ch -> String.valueOf(pref) + ch.to_code(tsc) + " ;\n").collect(Collectors.joining("")) + string_addition;
        }
        tsc.pop_prefix();
        if (is_not_empty) {
            res = String.valueOf(res) + tsc.get_prefix();
        }
        return String.valueOf(res) + this.to_code_closing(tsc);
    }

    protected String to_code_addition(Context_To_String_Code tsc) {
        return "";
    }

    protected String to_code_closing(Context_To_String_Code tsc) {
        return "}";
    }

    protected String to_code_opening(Context_To_String_Code tsc) {
        return "{";
    }

    @Override
    public String to_string(Context_To_String_Code tsc) {
        boolean is_not_empty;
        String res = this.to_string_opening(tsc);
        tsc.increase_prefix();
        String string_addition = this.to_string_addition();
        boolean bl = is_not_empty = !this.sequence.isEmpty() || !"".equals(string_addition);
        if (is_not_empty) {
            String pref = tsc.get_prefix();
            res = String.valueOf(res) + "\n" + this.sequence.stream().map(ch -> String.valueOf(pref) + ch.to_code(tsc) + " ;\n").collect(Collectors.joining("")) + string_addition;
        }
        tsc.pop_prefix();
        if (is_not_empty) {
            res = String.valueOf(res) + tsc.get_prefix();
        }
        return String.valueOf(res) + this.to_string_closing(tsc);
    }

    protected String to_string_addition() {
        return "";
    }

    protected String to_string_closing(Context_To_String_Code tsc) {
        return "}";
    }

    protected String to_string_opening(Context_To_String_Code tsc) {
        return "{";
    }
}

