/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.operator;

import fr.univ_orleans.jdl.language.Chunk;
import fr.univ_orleans.jdl.language.Constant_Operator;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.operator.OP;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Number;

public class OP_Change_Sign
extends OP {
    private final Chunk operand;

    public OP_Change_Sign(I_Chunk_Origin origin, Chunk operand) {
        super(origin);
        assert (operand != null);
        this.operand = operand;
    }

    @Override
    public Value eval(Eval_Context e_c) throws Language_Throwable {
        Value_Number vn = this.operand.eval(e_c).get_ground_value().get_number();
        return vn.negate(this.origin);
    }

    @Override
    public Constant_Operator.Priority get_priority() {
        return Constant_Operator.PRIORITY_CHANGE_SIGN;
    }

    @Override
    public String to_code(Context_To_String_Code tcc) {
        return "- " + this.to_code_opt_parenthesis(tcc, this.operand);
    }

    @Override
    public String to_string(Context_To_String_Code tsc) {
        return "- " + this.to_string_opt_parenthesis(tsc, this.operand);
    }
}

