/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.operator;

import fr.univ_orleans.jdl.language.Chunk;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.exception.Return_Throw;
import fr.univ_orleans.jdl.language.operator.OP;
import fr.univ_orleans.jdl.language.value.I_Value_Iterable;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Context;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Basic;
import fr.univ_orleans.jdl.language.value.Value_Label;
import fr.univ_orleans.jdl.language.value.Value_Special;

public class OP_Foreach
extends OP {
    final Chunk list;
    final Chunk expr;
    final String id;

    public OP_Foreach(I_Chunk_Origin origin, String id, Chunk list, Chunk expr) {
        super(origin);
        this.id = id;
        this.list = list;
        this.expr = expr;
    }

    @Override
    public Value eval(Eval_Context e_c) throws Language_Throwable {
        Value vl = this.list.eval(e_c).get_ground_value();
        if (!(vl instanceof I_Value_Iterable)) {
            this.throw_type_error("Error list or set (or iterable) expected " + this.list + " -> " + vl);
        }
        Value_Context vc = new Value_Context(this.origin);
        e_c.push_block(new Value_Context_Holder_Basic(this.origin, e_c.get_current_block(), vc));
        Value_Label var = new Value_Label(this.origin, this.id, vc);
        vc.register_label(var);
        try {
            for (Value v : (I_Value_Iterable)((Object)vl)) {
                var.set_value(v);
                this.expr.eval(e_c);
            }
        }
        catch (Return_Throw rt) {
            e_c.pop_block();
            throw rt;
        }
        e_c.pop_block();
        return new Value_Special.Value_Void(this.origin);
    }

    @Override
    public String to_code(Context_To_String_Code tcc) {
        return "foreach ( " + this.id + " " + ":" + " " + this.list.to_code(tcc) + " " + ")" + " " + this.expr.to_code(tcc);
    }

    @Override
    public String to_string(Context_To_String_Code tcc) {
        return "while ( " + this.id + " " + ":" + " " + this.list.to_string(tcc) + " " + ")" + " " + this.expr.to_string(tcc);
    }
}

