/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.operator;

import fr.univ_orleans.jdl.language.Chunk;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.exception.Return_Throw;
import fr.univ_orleans.jdl.language.operator.OP;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Context;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Basic;
import fr.univ_orleans.jdl.language.value.Value_Integer;
import fr.univ_orleans.jdl.language.value.Value_Label;
import fr.univ_orleans.jdl.language.value.Value_Number;
import fr.univ_orleans.jdl.language.value.Value_Special;

public class OP_Foreach_Range
extends OP {
    final Chunk exp_min;
    final Chunk exp_max;
    final Chunk expr;
    final String id;

    public OP_Foreach_Range(I_Chunk_Origin origin, String id, Chunk exp_min, Chunk exp_max, Chunk expr) {
        super(origin);
        this.id = id;
        this.exp_min = exp_min;
        this.exp_max = exp_max;
        this.expr = expr;
    }

    @Override
    public Value eval(Eval_Context e_c) throws Language_Throwable {
        Value v_val = this.exp_min.eval(e_c).get_ground_value();
        Value v_max = this.exp_max.eval(e_c).get_ground_value();
        if (!(v_val instanceof Value_Number)) {
            this.throw_type_error("The left bound of a range must be a number " + this.exp_min + " -> " + v_val);
        }
        if (!(v_max instanceof Value_Number)) {
            this.throw_type_error("The right bound of a range must be a number " + this.exp_min + " -> " + v_max);
        }
        Value_Context vc = new Value_Context(this.origin);
        e_c.push_block(new Value_Context_Holder_Basic(this.origin, e_c.get_current_block(), vc));
        Value_Label var = new Value_Label(this.origin, this.id, vc);
        vc.register_label(var);
        Value_Number val = (Value_Number)v_val;
        Value_Number max = (Value_Number)v_max;
        try {
            while (val.compare_to(max) <= 0) {
                var.set_value(val);
                this.expr.eval(e_c);
                val = val.add(this.origin, Value_Integer.ONE);
            }
        }
        catch (Return_Throw rt) {
            e_c.pop_block();
            throw rt;
        }
        e_c.pop_block();
        return new Value_Special.Value_Void(this.origin);
    }

    @Override
    public String to_code(Context_To_String_Code tcc) {
        return "foreach ( " + this.id + " " + ":" + " " + this.exp_min.to_code(tcc) + " " + "..." + " " + this.exp_max.to_code(tcc) + " " + ")" + " " + this.expr.to_code(tcc);
    }

    @Override
    public String to_string(Context_To_String_Code tcc) {
        return "while ( " + this.id + " " + ":" + this.exp_min.to_string(tcc) + " " + "..." + " " + this.exp_max.to_string(tcc) + ")" + " " + this.expr.to_string(tcc);
    }
}

