/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.operator;

import fr.univ_orleans.jdl.language.Chunk;
import fr.univ_orleans.jdl.language.Constant_Operator;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.operator.OP_Block;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Context;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Abstract;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Basic;
import fr.univ_orleans.jdl.language.value.Value_Function_Abstract;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class OP_Function_Call
extends OP_Block {
    final List<Chunk> args = new LinkedList<Chunk>();
    final Chunk function_chk;

    public OP_Function_Call(I_Chunk_Origin origin, Chunk function_chk) {
        super(origin);
        this.function_chk = function_chk;
    }

    public void add_arg(Chunk arg) {
        this.args.add(arg);
    }

    @Override
    public Value eval(Eval_Context e_c) throws Language_Throwable {
        Value fct = this.function_chk.eval(e_c).get_ground_value();
        if (!(fct instanceof Value_Function_Abstract)) {
            this.throw_type_error("Does not define a function: " + this.function_chk + ": " + fct);
        }
        Value_Function_Abstract f = (Value_Function_Abstract)fct;
        LinkedList<Value> args_val = new LinkedList<Value>();
        for (Chunk ar : this.args) {
            args_val.add(ar.eval(e_c).get_ground_value());
        }
        Value res = f.call(this.origin, e_c, args_val);
        if (res instanceof Value_Context) {
            Value_Context vc = (Value_Context)res;
            Value_Context_Holder_Abstract vch = vc.get_initial_holder();
            if (vch == null) {
                vch = new Value_Context_Holder_Basic(this.origin, e_c.get_current_block(), vc);
            }
            res = vch;
        }
        if (!this.sequence.isEmpty()) {
            if (!(res instanceof Value_Context_Holder_Abstract)) {
                this.throw_type_error("Function did not return a context: " + this.function_chk);
            }
            super.eval(e_c, (Value_Context_Holder_Abstract)res);
        }
        return res;
    }

    @Override
    public Constant_Operator.Priority get_priority() {
        return Constant_Operator.PRIORITY_FUNCTION_CALL;
    }

    @Override
    public String to_code(Context_To_String_Code ctsc) {
        String res = String.valueOf(this.function_chk.to_code(ctsc)) + " " + "(";
        if (!this.args.isEmpty()) {
            res = String.valueOf(res) + " " + this.args.stream().map(ch -> ch.to_code(ctsc)).collect(Collectors.joining(" , ")) + " ";
        }
        res = String.valueOf(res) + ")";
        if (!this.sequence.isEmpty()) {
            String pref_base = ctsc.get_prefix();
            ctsc.increase_prefix();
            String pref = ctsc.get_prefix();
            res = String.valueOf(res) + " {\n" + this.sequence.stream().map(ch -> String.valueOf(pref) + ch.to_code(ctsc) + " ;\n").collect(Collectors.joining("")) + pref_base + "}";
            ctsc.pop_prefix();
        }
        return res;
    }

    @Override
    public String to_string(Context_To_String_Code ctsc) {
        String res = String.valueOf(this.function_chk.to_string(ctsc)) + " " + "(";
        if (!this.args.isEmpty()) {
            res = String.valueOf(res) + " " + this.args.stream().map(ch -> ch.to_string(ctsc)).collect(Collectors.joining(" , ")) + " ";
        }
        res = String.valueOf(res) + ")";
        if (!this.sequence.isEmpty()) {
            String pref_base = ctsc.get_prefix();
            ctsc.increase_prefix();
            String pref = ctsc.get_prefix();
            res = String.valueOf(res) + " {\n" + this.sequence.stream().map(ch -> String.valueOf(pref) + ch.to_string(ctsc) + " ;\n").collect(Collectors.joining("")) + 'Z' + pref_base + "}";
            ctsc.pop_prefix();
        }
        return res;
    }
}

