/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.operator;

import fr.univ_orleans.jdl.language.Chunk;
import fr.univ_orleans.jdl.language.Constant_Operator;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.operator.OP;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Boolean;
import fr.univ_orleans.jdl.language.value.Value_Special;

public class OP_If
extends OP {
    final Chunk cnd;
    final Chunk fl;
    final Chunk tr;

    public OP_If(I_Chunk_Origin origin, Chunk cnd, Chunk tr) {
        super(origin);
        this.cnd = cnd;
        this.tr = tr;
        this.fl = null;
    }

    public OP_If(I_Chunk_Origin origin, Chunk cnd, Chunk tr, Chunk fl) {
        super(origin);
        this.cnd = cnd;
        this.tr = tr;
        this.fl = fl;
    }

    @Override
    public Value eval(Eval_Context e_c) throws Language_Throwable {
        Value cnd_val = this.cnd.eval(e_c).get_ground_value();
        if (!(cnd_val instanceof Value_Boolean)) {
            this.throw_type_error("Error boolean expected for condition not " + cnd_val);
        }
        return ((Value_Boolean)cnd_val).get_value_bool() ? this.tr.eval(e_c) : (this.fl == null ? new Value_Special.Value_Void(this.origin) : this.fl.eval(e_c));
    }

    @Override
    public String to_code(Context_To_String_Code tcc) {
        String prefix = tcc.get_prefix();
        tcc.increase_prefix();
        String res = "if ( " + this.cnd.to_code(tcc) + " ) \n" + tcc.get_prefix() + this.tr.to_code(tcc) + (this.fl == null ? "" : "\n" + prefix + "else" + "\n" + tcc.get_prefix() + this.fl.to_code(tcc));
        tcc.pop_prefix();
        return res;
    }

    @Override
    public String to_string(Context_To_String_Code tcc) {
        String prefix = tcc.get_prefix();
        tcc.increase_prefix();
        String res = "if ( " + this.cnd.to_string(tcc) + " ) \n" + tcc.get_prefix() + this.tr.to_string(tcc) + (this.fl == null ? "" : "\n" + prefix + "else" + "\n" + tcc.get_prefix() + this.fl.to_string(tcc));
        tcc.pop_prefix();
        return res;
    }

    @Override
    public Constant_Operator.Priority get_priority() {
        return Constant_Operator.PRIORITY_IF;
    }
}

