/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.operator;

import fr.univ_orleans.jdl.language.Chunk;
import fr.univ_orleans.jdl.language.Constant_Operator;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.operator.OP;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_List;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class OP_List
extends OP
implements Iterable<Chunk> {
    private final List<Chunk> list_chunk = new LinkedList<Chunk>();

    public OP_List(I_Chunk_Origin origin) {
        super(origin);
    }

    public void add(Chunk val) {
        this.list_chunk.add(val);
    }

    @Override
    public Value eval(Eval_Context e_c) throws Language_Throwable {
        Value_List li = new Value_List(this.origin);
        for (Chunk c : this.list_chunk) {
            li.add(c.eval(e_c).get_ground_value());
        }
        return li;
    }

    @Override
    public Constant_Operator.Priority get_priority() {
        return Constant_Operator.PRIORITY_VALUE_ATOMIC;
    }

    @Override
    public Iterator<Chunk> iterator() {
        return this.list_chunk.iterator();
    }

    @Override
    public String to_code(Context_To_String_Code tcc) {
        return this.list_chunk.isEmpty() ? "[]" : "[ " + this.list_chunk.stream().map(ch -> ch.to_code(tcc)).collect(Collectors.joining(" , ")) + " " + "]";
    }

    @Override
    public String to_string(Context_To_String_Code tsc) {
        return this.list_chunk.isEmpty() ? "[]" : "[ " + this.list_chunk.stream().map(ch -> ch.to_string(tsc)).collect(Collectors.joining(" , ")) + " " + "]";
    }
}

