/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.operator;

import fr.univ_orleans.jdl.language.Chunk;
import fr.univ_orleans.jdl.language.Constant_Operator;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.operator.OP;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Abstract;
import fr.univ_orleans.jdl.language.value.Value_Integer;
import fr.univ_orleans.jdl.language.value.Value_List;
import fr.univ_orleans.jdl.language.value.Value_List_Cell;
import fr.univ_orleans.jdl.language.value.Value_Number;
import fr.univ_orleans.jdl.language.value.Value_Variable_Abstract;

public class OP_List_Cell
extends OP {
    private final Chunk cell_index;
    private final Chunk list_ch;

    public OP_List_Cell(I_Chunk_Origin origin, Chunk list, Chunk cell_index) {
        super(origin);
        this.list_ch = list;
        this.cell_index = cell_index;
    }

    @Override
    public Value_Variable_Abstract eval(Eval_Context e_c) throws Language_Throwable {
        return this.eval_label(e_c, e_c.get_current_block());
    }

    protected Value_Variable_Abstract eval_label(Eval_Context e_c, Value_Context_Holder_Abstract v_c) throws Language_Throwable {
        Value_Number index;
        Value list = this.list_ch.eval(e_c).get_ground_value();
        if (!(list instanceof Value_List)) {
            this.throw_type_error("Is not a list " + this.list_ch);
        }
        if (!((index = this.cell_index.eval(e_c).get_number()) instanceof Value_Integer)) {
            this.throw_type_error("Is not an integer " + this.cell_index);
        }
        return new Value_List_Cell(this.origin, (Value_List)list, (Value_Integer)index);
    }

    @Override
    public Constant_Operator.Priority get_priority() {
        return Constant_Operator.PRIORITY_LABEL;
    }

    @Override
    public String to_code(Context_To_String_Code tcc) {
        return String.valueOf(this.list_ch.to_code(tcc)) + " " + "[" + " " + this.cell_index.to_code(tcc) + " " + "]" + " ";
    }

    @Override
    public String to_string(Context_To_String_Code tcc) {
        return String.valueOf(this.list_ch.to_string(tcc)) + " " + "[" + " " + this.cell_index.to_string(tcc) + " " + "]" + " ";
    }
}

