/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.operator;

import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.driver.Driver_Import;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.exception.Lexical_Error;
import fr.univ_orleans.jdl.language.operator.OP;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Special;
import java.io.IOException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;

public class OP_Load_Code
extends OP {
    final String file_name;
    static ANTLRErrorListener error_listener_lexical = new BaseErrorListener(){

        @Override
        public void syntaxError(Recognizer<?, ?> arg0, Object arg1, int arg2, int arg3, String arg4, RecognitionException arg5) {
            throw new Lexical_Error("line " + arg2 + ":" + arg3 + " " + arg4, arg5);
        }
    };
    static ANTLRErrorListener error_listener_syntaxic = new BaseErrorListener(){

        @Override
        public void syntaxError(Recognizer<?, ?> arg0, Object arg1, int arg2, int arg3, String arg4, RecognitionException arg5) {
            throw new Lexical_Error("line " + arg2 + ":" + arg3 + " " + arg4, arg5);
        }
    };

    public OP_Load_Code(I_Chunk_Origin origin, String file_name) {
        super(origin);
        this.file_name = file_name;
    }

    public boolean equals(Object obj) {
        return obj instanceof OP_Load_Code && this.file_name.equals(((OP_Load_Code)obj).file_name);
    }

    @Override
    public Value eval(Eval_Context e_c) throws Language_Throwable {
        try {
            return Driver_Import.read_file(this.file_name).eval(e_c);
        }
        catch (Language_Throwable lt) {
            lt.printStackTrace();
        }
        catch (IOException ioe) {
            System.err.println("FAIL opening / reading\n" + ioe);
        }
        catch (Exception e) {
            this.throw_operation_impossible("Impossible to load code " + this.file_name);
            e.printStackTrace();
        }
        return new Value_Special.Value_Error(this.origin);
    }

    @Override
    public String to_code(Context_To_String_Code ctsc) {
        return String.valueOf(ctsc.get_prefix()) + "use" + ' ' + this.file_name;
    }

    @Override
    public String to_string(Context_To_String_Code ctsc) {
        return this.to_code(ctsc);
    }
}

