/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.operator;

import fr.univ_orleans.jdl.language.Chunk;
import fr.univ_orleans.jdl.language.Constant_Operator;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.operator.OP;
import fr.univ_orleans.jdl.language.operator.OP_Block;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Context;
import fr.univ_orleans.jdl.language.value.Value_Context_Ghost;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Abstract;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Basic;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Here;
import fr.univ_orleans.jdl.language.value.Value_Label;
import fr.univ_orleans.jdl.language.value.Value_Label_Ghost;
import fr.univ_orleans.jdl.language.value.Value_Special;

public class OP_Reopen
extends OP {
    Chunk context_chunk;
    Chunk expr;
    final OP_Reopen_Type op;

    public OP_Reopen(I_Chunk_Origin origin, OP_Reopen_Type op, Chunk context, Chunk expr) {
        super(origin);
        this.op = op;
        this.context_chunk = context;
        this.expr = expr;
    }

    @Override
    public Value eval(Eval_Context e_c) throws Language_Throwable {
        Value res;
        Value_Context_Holder_Abstract open;
        if (this.context_chunk == null) {
            open = this.op.provide_context_holder(this.origin, e_c);
        } else {
            Value val_ct_ch = this.context_chunk.eval(e_c);
            Value val_ct = val_ct_ch.get_ground_value();
            if (val_ct instanceof Value_Special.Value_Undefined && val_ct_ch instanceof Value_Label) {
                Value_Label_Ghost vlg = new Value_Label_Ghost(this.origin, ((Value_Label)val_ct_ch).id, e_c.get_current_search().get_context());
                open = new Value_Context_Holder_Basic(this.origin, e_c.get_current_search(), new Value_Context_Ghost(this.origin, vlg));
                vlg.set_value(open);
            } else if (val_ct instanceof Value_Context_Holder_Abstract) {
                open = (Value_Context_Holder_Abstract)val_ct;
            } else if (val_ct instanceof Value_Context) {
                open = new Value_Context_Holder_Basic(this.origin, null, (Value_Context)val_ct);
            } else {
                this.throw_type_error("Does not label a context: " + this.context_chunk + " -> " + val_ct + val_ct.getClass());
                open = null;
            }
        }
        if (this.expr instanceof OP_Block) {
            res = ((OP_Block)this.expr).eval(e_c, open);
        } else {
            e_c.push_search(open);
            res = this.expr.eval(e_c);
            e_c.pop_search();
        }
        return res;
    }

    @Override
    public Constant_Operator.Priority get_priority() {
        return Constant_Operator.PRIORITY_LABEL;
    }

    @Override
    public String to_code(Context_To_String_Code ctsc) {
        return String.valueOf(this.context_chunk == null ? "" : String.valueOf(this.to_string_opt_parenthesis(ctsc, this.context_chunk)) + " ") + this.op.op_string + ' ' + this.to_string_opt_parenthesis(ctsc, this.expr);
    }

    @Override
    public String to_string(Context_To_String_Code ctsc) {
        return String.valueOf(this.context_chunk == null ? "" : String.valueOf(this.to_string_opt_parenthesis(ctsc, this.context_chunk)) + " ") + this.op.op_string + " " + this.to_string_opt_parenthesis(ctsc, this.expr);
    }

    public static enum OP_Reopen_Type {
        ABOVE(".."){

            @Override
            public Value_Context_Holder_Abstract provide_context_holder(I_Chunk_Origin origin, Eval_Context e_c) {
                return e_c.get_current_search().father;
            }

            @Override
            Value_Context_Holder_Abstract provide_context_holder(I_Chunk_Origin origin, Value_Context_Holder_Abstract context_holder) {
                return context_holder.father;
            }
        }
        ,
        CALLING("?"){

            @Override
            public Value_Context_Holder_Abstract provide_context_holder(I_Chunk_Origin origin, Eval_Context e_c) {
                return e_c.get_current_block().get_function_context_call();
            }

            @Override
            Value_Context_Holder_Abstract provide_context_holder(I_Chunk_Origin origin, Value_Context_Holder_Abstract context_holder) {
                return context_holder.get_function_context_call();
            }
        }
        ,
        HERE("."){

            @Override
            public Value_Context_Holder_Abstract provide_context_holder(I_Chunk_Origin origin, Eval_Context e_c) {
                return new Value_Context_Holder_Here(origin, e_c.get_current_search());
            }

            @Override
            Value_Context_Holder_Abstract provide_context_holder(I_Chunk_Origin origin, Value_Context_Holder_Abstract context_holder) {
                return new Value_Context_Holder_Here(origin, context_holder);
            }
        }
        ,
        REOPEN("::");

        public final String op_string;

        private OP_Reopen_Type(String op_string) {
            this.op_string = op_string;
        }

        public Value_Context_Holder_Abstract provide_context_holder(I_Chunk_Origin origin, Eval_Context e_c) {
            return e_c.get_context_holder_Top();
        }

        Value_Context_Holder_Abstract provide_context_holder(I_Chunk_Origin origin, Value_Context_Holder_Abstract context) {
            return context;
        }
    }
}

