/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.operator;

import fr.univ_orleans.jdl.language.Chunk;
import fr.univ_orleans.jdl.language.Constant_Operator;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Exception_Value_Uncomparable;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.operator.OP;
import fr.univ_orleans.jdl.language.value.I_Value_Comparable;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Boolean;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class OP_Test_Sequence
extends OP {
    private final List<Chunk> values = new LinkedList<Chunk>();
    private final List<Test_Type> test_nature = new LinkedList<Test_Type>();

    public OP_Test_Sequence(I_Chunk_Origin origin, Chunk left_most) {
        super(origin);
        this.values.add(left_most);
    }

    public void add(Test_Type type, Chunk val_next) {
        this.test_nature.add(type);
        this.values.add(val_next);
    }

    @Override
    public Value eval(Eval_Context e_c) throws Language_Throwable {
        Iterator<Chunk> it_value = this.values.iterator();
        Chunk cl = it_value.next();
        Value vl = cl.eval(e_c).get_ground_value();
        Iterator<Test_Type> it_with_equality = this.test_nature.iterator();
        do {
            Value vr = it_value.next().eval(e_c).get_ground_value();
            if (!it_with_equality.next().test(vl, vr)) {
                if (!e_c.is_boolean_evaluation_lazy()) {
                    while (it_value.hasNext()) {
                        it_value.next().eval(e_c).get_ground_value();
                    }
                }
                return Value_Boolean.FALSE;
            }
            vl = vr;
        } while (it_value.hasNext());
        return Value_Boolean.TRUE;
    }

    protected static void throw_not_comparable(I_Chunk_Origin origin, String msg) throws Exception_Value_Uncomparable {
        throw new Exception_Value_Uncomparable(origin, msg);
    }

    @Override
    public String to_code(Context_To_String_Code tcc) {
        Iterator<Chunk> it_value = this.values.iterator();
        Iterator<Test_Type> it_with_equality = this.test_nature.iterator();
        Chunk cl = it_value.next();
        StringBuilder res = new StringBuilder(cl.to_code(tcc));
        do {
            res.append(" ").append(it_with_equality.next().get_symbol()).append(" ").append(it_value.next().to_code(tcc));
        } while (it_value.hasNext());
        return res.toString();
    }

    @Override
    public String to_string(Context_To_String_Code tcc) {
        Iterator<Chunk> it_value = this.values.iterator();
        Iterator<Test_Type> it_with_equality = this.test_nature.iterator();
        Chunk cl = it_value.next();
        StringBuilder res = new StringBuilder(cl.to_string(tcc));
        do {
            res.append(" ").append(it_with_equality.next().get_symbol()).append(" ").append(it_value.next().to_string(tcc));
        } while (it_value.hasNext());
        return res.toString();
    }

    @Override
    public Constant_Operator.Priority get_priority() {
        return Constant_Operator.PRIORITY_TEST;
    }

    public static enum Test_Type {
        EQUAL{

            @Override
            boolean test(Value left, Value right) throws Language_Throwable {
                return left.get_ground_value().equals(right.get_ground_value());
            }

            @Override
            String get_symbol() {
                return "==";
            }
        }
        ,
        DIFFERENT{

            @Override
            boolean test(Value left, Value right) throws Language_Throwable {
                return !EQUAL.test(left, right);
            }

            @Override
            String get_symbol() {
                return "!=";
            }
        }
        ,
        LESS_THAN{

            @Override
            boolean test(Value vl, Value vr) throws Language_Throwable {
                if (!(vl instanceof I_Value_Comparable)) {
                    OP_Test_Sequence.throw_not_comparable(vl.origin, Test_Type.STRING_ARGUNEMENT_IS_NOT_A_COMPARABLE + vl);
                }
                if (!(vr instanceof I_Value_Comparable)) {
                    OP_Test_Sequence.throw_not_comparable(vr.origin, Test_Type.STRING_ARGUNEMENT_IS_NOT_A_COMPARABLE + vr);
                }
                return ((I_Value_Comparable)((Object)vl)).compare_to((I_Value_Comparable)((Object)vr)) < 0;
            }

            @Override
            String get_symbol() {
                return "<";
            }
        }
        ,
        LESS_EQUAL{

            @Override
            boolean test(Value vl, Value vr) throws Language_Throwable {
                if (!(vl instanceof I_Value_Comparable)) {
                    OP_Test_Sequence.throw_not_comparable(vl.origin, Test_Type.STRING_ARGUNEMENT_IS_NOT_A_COMPARABLE + vl);
                }
                if (!(vr instanceof I_Value_Comparable)) {
                    OP_Test_Sequence.throw_not_comparable(vr.origin, Test_Type.STRING_ARGUNEMENT_IS_NOT_A_COMPARABLE + vr);
                }
                return ((I_Value_Comparable)((Object)vl)).compare_to((I_Value_Comparable)((Object)vr)) <= 0;
            }

            @Override
            String get_symbol() {
                return "<=";
            }
        };

        private static final String STRING_ARGUNEMENT_IS_NOT_A_COMPARABLE = "argunement is not a comparable: ";

        abstract boolean test(Value var1, Value var2) throws Language_Throwable;

        abstract String get_symbol();
    }
}

