/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.operator;

import fr.univ_orleans.jdl.language.Chunk;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.operator.OP;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Boolean;
import fr.univ_orleans.jdl.language.value.Value_Special;

public class OP_While
extends OP {
    final Chunk cnd;
    final Chunk exp;

    public OP_While(I_Chunk_Origin origin, Chunk cnd, Chunk exp) {
        super(origin);
        this.cnd = cnd;
        this.exp = exp;
    }

    @Override
    public Value eval(Eval_Context e_c) throws Language_Throwable {
        Value res = new Value_Special.Value_Void(this.origin);
        while (true) {
            Value cnd_val;
            if (!((cnd_val = this.cnd.eval(e_c)) instanceof Value_Boolean)) {
                this.throw_type_error("Error boolean expected for condition not " + cnd_val);
            }
            if (!((Value_Boolean)cnd_val).get_value_bool()) {
                return res;
            }
            res = this.exp.eval(e_c);
        }
    }

    @Override
    public String to_code(Context_To_String_Code tcc) {
        return "while ( " + this.cnd.to_code(tcc) + " " + ")" + " " + this.exp.to_code(tcc);
    }

    @Override
    public String to_string(Context_To_String_Code tcc) {
        return "while ( " + this.cnd.to_string(tcc) + " " + ")" + " " + this.exp.to_string(tcc);
    }
}

