/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.operator;

import fr.univ_orleans.jdl.language.Chunk;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.operator.OP;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Boolean;

public class OP_While_Do
extends OP {
    final Chunk cnd;
    final Chunk exp;

    public OP_While_Do(I_Chunk_Origin origin, Chunk cnd, Chunk exp) {
        super(origin);
        this.cnd = cnd;
        this.exp = exp;
    }

    @Override
    public Value eval(Eval_Context e_c) throws Language_Throwable {
        Value res;
        Value cnd_val;
        do {
            res = this.exp.eval(e_c);
            cnd_val = this.cnd.eval(e_c);
            if (cnd_val instanceof Value_Boolean) continue;
            this.throw_type_error("Error boolean expected for condition not " + cnd_val);
        } while (((Value_Boolean)cnd_val).get_value_bool());
        return res;
    }

    @Override
    public String to_code(Context_To_String_Code tcc) {
        return "do " + this.exp.to_code(tcc) + " " + "while" + " " + "(" + " " + this.cnd.to_code(tcc) + " " + ")";
    }

    @Override
    public String to_string(Context_To_String_Code tcc) {
        return "do " + this.exp.to_string(tcc) + " " + "while" + " " + "(" + " " + this.cnd.to_string(tcc) + " " + ")";
    }
}

