/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.value;

import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.value.Value_Atomic;
import fr.univ_orleans.jdl.language.value.Value_Supplier;

public abstract class Value_Boolean
extends Value_Atomic {
    public static final Value_Boolean FALSE = new Value_False();
    public static final Value_Boolean TRUE = new Value_True();

    public static Value_Boolean value_of(boolean b) {
        return b ? TRUE : FALSE;
    }

    private Value_Boolean(I_Chunk_Origin origin) {
        super(origin);
    }

    private Value_Boolean() {
        super(null);
    }

    public abstract Value_Boolean and(Value_Supplier var1) throws Language_Throwable;

    public abstract boolean get_value_bool();

    public abstract Value_Boolean not();

    public abstract Value_Boolean or(Value_Supplier var1) throws Language_Throwable;

    private static class Value_False
    extends Value_Boolean {
        private Value_False() {
        }

        @Override
        public Value_Boolean and(Value_Supplier vb) throws Language_Throwable {
            return FALSE;
        }

        @Override
        public boolean get_value_bool() {
            return false;
        }

        @Override
        public Value_Boolean not() {
            return TRUE;
        }

        @Override
        public Value_Boolean or(Value_Supplier vb) throws Language_Throwable {
            return (Value_Boolean)vb.get();
        }

        @Override
        public String to_code(Context_To_String_Code tcc) {
            return "false";
        }

        @Override
        public String to_string(Context_To_String_Code tsc) {
            return "false";
        }
    }

    private static class Value_True
    extends Value_Boolean {
        private Value_True() {
        }

        @Override
        public Value_Boolean and(Value_Supplier vb) throws Language_Throwable {
            return (Value_Boolean)vb.get();
        }

        @Override
        public boolean get_value_bool() {
            return true;
        }

        @Override
        public Value_Boolean not() {
            return FALSE;
        }

        @Override
        public Value_Boolean or(Value_Supplier vb) throws Language_Throwable {
            return TRUE;
        }

        @Override
        public String to_code(Context_To_String_Code tcc) {
            return "true";
        }

        @Override
        public String to_string(Context_To_String_Code tsc) {
            return "true";
        }
    }
}

