/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.value;

import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.Library_Abstract;
import fr.univ_orleans.jdl.language.exception.Exception_Impossible_Operation;
import fr.univ_orleans.jdl.language.exception.Exception_Type_Error;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Abstract;
import fr.univ_orleans.jdl.language.value.Value_Holder_Abstract;
import fr.univ_orleans.jdl.language.value.Value_Label;
import fr.univ_orleans.jdl.language.value.Value_Label_Abstract;
import fr.univ_orleans.jdl.language.value.Value_Variable_Abstract;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Value_Context
extends Value {
    private Value_Context_Holder_Abstract initial_holder = null;
    private final Map<String, Value_Holder_Abstract> labels = new HashMap<String, Value_Holder_Abstract>();
    private final List<Library_Abstract> library_list = new LinkedList<Library_Abstract>();

    public Value_Context(I_Chunk_Origin origin) {
        super(origin);
    }

    public void add_library(Library_Abstract library) {
        this.library_list.add(0, library);
    }

    public Stream<Map.Entry<String, Value_Holder_Abstract>> affectation_stream() {
        return this.labels.entrySet().stream();
    }

    public Value_Holder_Abstract create_label(I_Chunk_Origin origin, String id) {
        assert (this.labels.get(id) == null);
        Value_Label vha = new Value_Label(origin, id, this);
        this.labels.put(id, vha);
        return vha;
    }

    public Value_Context_Holder_Abstract get_initial_holder() {
        return this.initial_holder;
    }

    public Value_Label_Abstract get_label_association(Value v) {
        return null;
    }

    final Value_Holder_Abstract get_label_here(String id) {
        Value_Holder_Abstract vh = this.labels.get(id);
        if (vh == null) {
            vh = this.get_predefined(id);
        }
        if (vh == null) {
            vh = this.get_library(id);
        }
        return vh;
    }

    final Value_Holder_Abstract get_library(String id) {
        for (Library_Abstract lib : this.library_list) {
            Value_Holder_Abstract vha = lib.get_predefined(id);
            if (vha == null) continue;
            return vha;
        }
        return null;
    }

    protected Value_Holder_Abstract get_predefined(String id) {
        return null;
    }

    public void register_label(Value_Label lab) {
        this.labels.put(lab.id, lab);
    }

    public void set_initial_holder(Value_Context_Holder_Abstract initial_holder) {
        assert (this.initial_holder == null);
        this.initial_holder = initial_holder;
    }

    Value_Variable_Abstract set_label_here(I_Chunk_Origin origin, String id, Value val) throws Exception_Type_Error, Exception_Impossible_Operation {
        Value_Label v_l = new Value_Label(origin, id, this, val);
        this.labels.put(id, v_l);
        return v_l;
    }

    @Override
    public String to_string(Context_To_String_Code tsc) {
        String res = this.to_string_opening(tsc);
        tsc.increase_prefix();
        String string_addition = this.to_string_addition(tsc);
        String inside = String.valueOf(this.to_string_labels(tsc)) + string_addition;
        if (!inside.isEmpty()) {
            res = String.valueOf(res) + "\n" + inside;
        }
        tsc.pop_prefix();
        if (!inside.isEmpty()) {
            res = String.valueOf(res) + tsc.get_prefix();
        }
        return String.valueOf(res) + this.to_string_closing(tsc);
    }

    protected String to_string_addition(Context_To_String_Code tsc) {
        return "";
    }

    protected String to_string_closing(Context_To_String_Code tsc) {
        return "}";
    }

    protected String to_string_labels(Context_To_String_Code tsc) {
        String pref = tsc.get_prefix();
        return this.labels.entrySet().stream().filter(entry -> !(entry.getValue() instanceof Value_Holder_Abstract) || ((Value_Holder_Abstract)entry.getValue()).is_tangible()).map(entry -> String.valueOf(pref) + (entry.getValue() == null ? "null" : ((Value_Holder_Abstract)entry.getValue()).to_string(tsc)) + " ;\n").collect(Collectors.joining(""));
    }

    protected String to_string_opening(Context_To_String_Code tsc) {
        return "{";
    }
}

