/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.value;

import fr.univ_orleans.jdl.language.Chunk;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Exception_Argument_Already_Present;
import fr.univ_orleans.jdl.language.exception.Exception_Argument_Missing;
import fr.univ_orleans.jdl.language.exception.Exception_Library;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.exception.Return_Throw;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Abstract;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Function_Call;
import fr.univ_orleans.jdl.language.value.Value_Function_Abstract;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Value_Function
extends Value_Function_Abstract {
    final List<String> args;
    protected Value_Context_Holder_Abstract context_definition;
    private Chunk expression;

    public Value_Function(I_Chunk_Origin origin) {
        super(origin);
        this.args = new LinkedList<String>();
    }

    private Value_Function(Value_Function vf) {
        super(vf.origin);
        this.args = vf.args;
        this.expression = vf.expression;
    }

    public void add_arg(String arg) {
        if (this.args.contains(arg)) {
            throw new Exception_Argument_Already_Present(this.origin, arg);
        }
        this.args.add(arg);
    }

    @Override
    public Value call(I_Chunk_Origin origin, Eval_Context e_c, List<Value> args_val) throws Language_Throwable {
        Value res;
        Value_Context_Holder_Abstract context_call = e_c.get_current_block();
        Value_Context_Holder_Function_Call c_v = new Value_Context_Holder_Function_Call(origin, this.context_definition, context_call);
        Iterator<Value> val = args_val.iterator();
        for (String id : this.args) {
            if (val.hasNext()) {
                c_v.set_label_here(origin, id, val.next());
                continue;
            }
            throw new Exception_Argument_Missing(origin, this.expression.toString(), id);
        }
        e_c.push_block(c_v);
        try {
            try {
                res = this.expression.eval(e_c);
            }
            catch (Language_Throwable e) {
                throw e;
            }
            catch (Exception e) {
                throw new Exception_Library(origin, (Throwable)e);
            }
        }
        catch (Return_Throw tl) {
            res = tl.get_val();
        }
        e_c.pop_block();
        return res;
    }

    @Override
    public Value eval(Eval_Context e_c) {
        if (this.context_definition == null) {
            this.context_definition = e_c.get_current_block();
            return this;
        }
        return new Value_Function(this).eval(e_c);
    }

    public void set_expression(Chunk expression) {
        assert (this.expression == null);
        this.expression = expression;
    }

    @Override
    public String to_code(Context_To_String_Code tcc) {
        return String.valueOf(this.args.isEmpty() ? "() " : "( " + String.join((CharSequence)" , ", this.args) + " ) ") + "->" + " " + this.expression.to_code(tcc);
    }

    @Override
    public String to_string(Context_To_String_Code tsc) {
        return String.valueOf(this.args.isEmpty() ? "() " : "( " + String.join((CharSequence)" , ", this.args) + " ) ") + "->" + " " + this.expression.to_string(tsc);
    }
}

