/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.value;

import fr.univ_orleans.jdl.language.Chunk_Origin_CONTANT;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Exception_Impossible_Operation;
import fr.univ_orleans.jdl.language.exception.Exception_Value_Uncomparable;
import fr.univ_orleans.jdl.language.value.I_Value_Comparable;
import fr.univ_orleans.jdl.language.value.Value_Number;
import fr.univ_orleans.jdl.language.value.Value_Rational;
import fr.univ_orleans.jdl.util.Rational;
import java.math.BigInteger;

public class Value_Integer
extends Value_Number {
    public static final Value_Number ONE = new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, 1);
    public final BigInteger bi;

    public Value_Integer(I_Chunk_Origin origin, int n) {
        this(origin, BigInteger.valueOf(n));
    }

    public Value_Integer(I_Chunk_Origin origin, BigInteger bi) {
        super(origin);
        assert (bi != null);
        this.bi = bi;
    }

    @Override
    public Value_Number add(I_Chunk_Origin origin, Value_Number num) throws Exception_Impossible_Operation {
        if (num instanceof Value_Integer) {
            return new Value_Integer(origin, this.bi.add(((Value_Integer)num).bi));
        }
        if (num instanceof Value_Rational) {
            return num.add(origin, this);
        }
        throw new Exception_Impossible_Operation(origin, "Incompatible type for addition: " + num);
    }

    @Override
    public int compare_to(I_Value_Comparable v_c) throws Exception_Value_Uncomparable {
        if (v_c instanceof Value_Integer) {
            return this.bi.compareTo(((Value_Integer)v_c).bi);
        }
        if (v_c instanceof Value_Rational) {
            return -((Value_Rational)v_c).get_rational_value().compareTo(this.bi);
        }
        this.throw_uncomparable(this, v_c);
        return 200;
    }

    @Override
    public Value_Number divide(I_Chunk_Origin origin, Value_Number num) throws Exception_Impossible_Operation {
        if (num.is_zero()) {
            throw new Exception_Impossible_Operation(origin, "Division by zero");
        }
        if (num instanceof Value_Integer) {
            return Value_Integer.simplify_integral(origin, new Rational(this.bi, ((Value_Integer)num).bi));
        }
        if (num instanceof Value_Rational) {
            Rational r = new Rational(this.bi).divide(((Value_Rational)num).get_rational_value());
            return new Value_Rational(origin, r);
        }
        throw new Exception_Impossible_Operation(origin, "Incompatible type for division: " + num);
    }

    @Override
    public Value_Integer division_integral(I_Chunk_Origin origin, Value_Number num) throws Exception_Impossible_Operation {
        if (num.is_zero()) {
            throw new Exception_Impossible_Operation(origin, "Integral division by zero");
        }
        if (num instanceof Value_Integer) {
            BigInteger num_bi = ((Value_Integer)num).bi;
            BigInteger res = this.bi.divide(num_bi);
            return new Value_Integer(origin, res);
        }
        if (num instanceof Value_Rational) {
            return new Value_Integer(origin, ((Value_Rational)num).get_rational_value().divide(this.bi).inverse().round_to_zero_bi());
        }
        throw new Exception_Impossible_Operation(origin, "Incompatible type for integral division: " + num);
    }

    public boolean equals(Object obj) {
        return obj instanceof Value_Integer && this.bi.equals(((Value_Integer)obj).bi) || obj instanceof Value_Rational && obj.equals(this);
    }

    @Override
    public long get_int_value() {
        return this.bi.intValue();
    }

    @Override
    public Rational get_rational_value() {
        return new Rational(this.bi);
    }

    public int hashCode() {
        return this.bi.hashCode();
    }

    @Override
    public Value_Number inverse() {
        return Value_Integer.simplify_integral(this.origin, new Rational(BigInteger.ONE, this.bi));
    }

    @Override
    public boolean is_integer() {
        return true;
    }

    @Override
    protected boolean is_zero() {
        return this.bi.signum() == 0;
    }

    @Override
    public Value_Number multiply(I_Chunk_Origin origin, Value_Number num) throws Exception_Impossible_Operation {
        if (num instanceof Value_Integer) {
            return new Value_Integer(origin, this.bi.multiply(((Value_Integer)num).bi));
        }
        if (num instanceof Value_Rational) {
            return num.multiply(origin, this);
        }
        throw new Exception_Impossible_Operation(origin, "Incompatible type for multiplication: " + num);
    }

    @Override
    public Value_Number negate(I_Chunk_Origin origin) {
        return new Value_Integer(origin, this.bi.negate());
    }

    @Override
    public Value_Number remainder(I_Chunk_Origin origin, Value_Number num) throws Exception_Impossible_Operation {
        if (num.is_zero()) {
            throw new Exception_Impossible_Operation(origin, "Modulo by zero");
        }
        if (num instanceof Value_Integer) {
            BigInteger num_bi = ((Value_Integer)num).bi;
            return new Value_Integer(origin, this.bi.remainder(num_bi));
        }
        if (num instanceof Value_Rational) {
            Rational rat = ((Value_Rational)num).get_rational_value();
            return new Value_Rational(origin, new Rational(this.bi.multiply(rat.get_denominator()).remainder(rat.get_numerator()), rat.get_denominator()));
        }
        throw new Exception_Impossible_Operation(origin, "Incompatible type for modulo: " + num);
    }

    @Override
    public Value_Number subtract(I_Chunk_Origin origin, Value_Number num) throws Exception_Impossible_Operation {
        if (num instanceof Value_Integer) {
            return new Value_Integer(origin, this.bi.subtract(((Value_Integer)num).bi));
        }
        if (num instanceof Value_Rational) {
            return num.subtract(origin, this).negate(origin);
        }
        throw new Exception_Impossible_Operation(origin, "Incompatible type for subtraction: " + num);
    }

    @Override
    public String to_string(Context_To_String_Code tsc) {
        return this.bi.toString();
    }
}

