/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.value;

import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Exception_Impossible_Operation;
import fr.univ_orleans.jdl.language.value.I_Value_Comparable;
import fr.univ_orleans.jdl.language.value.Value_Atomic;
import fr.univ_orleans.jdl.language.value.Value_Integer;
import fr.univ_orleans.jdl.language.value.Value_Rational;
import fr.univ_orleans.jdl.util.Rational;

public abstract class Value_Number
extends Value_Atomic
implements I_Value_Comparable {
    public static Value_Number simplify_integral(I_Chunk_Origin origin, Rational nbr) {
        if (nbr.is_integral()) {
            return new Value_Integer(origin, nbr.get_numerator());
        }
        return new Value_Rational(origin, nbr);
    }

    public Value_Number(I_Chunk_Origin origin) {
        super(origin);
    }

    public abstract Value_Number add(I_Chunk_Origin var1, Value_Number var2) throws Exception_Impossible_Operation;

    public abstract Value_Number divide(I_Chunk_Origin var1, Value_Number var2) throws Exception_Impossible_Operation;

    public abstract Value_Integer division_integral(I_Chunk_Origin var1, Value_Number var2) throws Exception_Impossible_Operation;

    public abstract long get_int_value();

    @Override
    public Value_Number get_number() {
        return this;
    }

    public abstract Rational get_rational_value();

    public abstract Value_Number inverse();

    public abstract boolean is_integer();

    protected abstract boolean is_zero();

    public abstract Value_Number multiply(I_Chunk_Origin var1, Value_Number var2) throws Exception_Impossible_Operation;

    public abstract Value_Number negate(I_Chunk_Origin var1);

    public abstract Value_Number remainder(I_Chunk_Origin var1, Value_Number var2) throws Exception_Impossible_Operation;

    public abstract Value_Number subtract(I_Chunk_Origin var1, Value_Number var2) throws Exception_Impossible_Operation;
}

