/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.value;

import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Exception_Impossible_Operation;
import fr.univ_orleans.jdl.language.exception.Exception_Value_Uncomparable;
import fr.univ_orleans.jdl.language.value.I_Value_Comparable;
import fr.univ_orleans.jdl.language.value.Value_Integer;
import fr.univ_orleans.jdl.language.value.Value_Number;
import fr.univ_orleans.jdl.util.Rational;

public class Value_Rational
extends Value_Number {
    private final Rational rat;

    public Value_Rational(I_Chunk_Origin origin, Rational rat) {
        super(origin);
        assert (rat != null);
        this.rat = rat;
    }

    public Value_Rational(I_Chunk_Origin origin, String s) {
        super(origin);
        assert (s != null);
        this.rat = Rational.value_of(s);
    }

    @Override
    public Value_Number add(I_Chunk_Origin origin, Value_Number num) throws Exception_Impossible_Operation {
        if (num instanceof Value_Rational) {
            return Value_Rational.simplify_integral(origin, this.rat.add(((Value_Rational)num).rat));
        }
        if (num instanceof Value_Integer) {
            return Value_Rational.simplify_integral(origin, this.rat.add(((Value_Integer)num).bi));
        }
        throw new Exception_Impossible_Operation(origin, "Incompatible type for addition: " + num);
    }

    @Override
    public int compare_to(I_Value_Comparable v_c) throws Exception_Value_Uncomparable {
        if (v_c instanceof Value_Rational) {
            return this.rat.compareTo(((Value_Rational)v_c).rat);
        }
        if (v_c instanceof Value_Integer) {
            return this.rat.compareTo(((Value_Integer)v_c).bi);
        }
        this.throw_uncomparable(this, v_c);
        return 200;
    }

    @Override
    public Value_Number divide(I_Chunk_Origin origin, Value_Number num) throws Exception_Impossible_Operation {
        if (num.is_zero()) {
            throw new Exception_Impossible_Operation(origin, "Division by zero");
        }
        Rational res = null;
        if (num instanceof Value_Rational) {
            res = this.rat.divide(((Value_Rational)num).rat);
        } else if (num instanceof Value_Integer) {
            res = this.rat.divide(((Value_Integer)num).bi);
        } else {
            throw new Exception_Impossible_Operation(origin, "Incompatible type for integral division: " + num);
        }
        return Value_Rational.simplify_integral(origin, res);
    }

    @Override
    public Value_Integer division_integral(I_Chunk_Origin origin, Value_Number num) throws Exception_Impossible_Operation {
        if (num.is_zero()) {
            throw new Exception_Impossible_Operation(origin, "Integral division by zero");
        }
        if (num instanceof Value_Rational) {
            return new Value_Integer(origin, this.rat.divide(((Value_Rational)num).rat).round_to_zero_bi());
        }
        if (num instanceof Value_Integer) {
            return new Value_Integer(origin, this.rat.divide(((Value_Integer)num).bi).round_to_zero_bi());
        }
        throw new Exception_Impossible_Operation(origin, "Incompatible type for integral division: " + num);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Value_Rational) {
            return this.rat.equals(((Value_Rational)obj).rat);
        }
        if (obj instanceof Value_Integer) {
            return this.rat.equals(((Value_Integer)obj).bi);
        }
        return false;
    }

    @Override
    public long get_int_value() {
        return this.rat.round();
    }

    @Override
    public Rational get_rational_value() {
        return this.rat;
    }

    public int hashCode() {
        return this.rat.hashCode();
    }

    @Override
    public Value_Number inverse() {
        return Value_Rational.simplify_integral(this.origin, this.rat.inverse());
    }

    @Override
    public boolean is_integer() {
        return this.rat.is_integral();
    }

    @Override
    protected boolean is_zero() {
        return this.rat.signum() == 0;
    }

    @Override
    public Value_Number multiply(I_Chunk_Origin origin, Value_Number num) throws Exception_Impossible_Operation {
        if (num instanceof Value_Rational) {
            return Value_Rational.simplify_integral(origin, this.rat.multiply(((Value_Rational)num).rat));
        }
        if (num instanceof Value_Integer) {
            return Value_Rational.simplify_integral(origin, this.rat.multiply(((Value_Integer)num).bi));
        }
        throw new Exception_Impossible_Operation(origin, "Incompatible type for multiplication: " + num);
    }

    @Override
    public Value_Number negate(I_Chunk_Origin origin) {
        return new Value_Rational(origin, this.rat.negate());
    }

    @Override
    public Value_Number remainder(I_Chunk_Origin origin, Value_Number num) throws Exception_Impossible_Operation {
        if (num.is_zero()) {
            throw new Exception_Impossible_Operation(origin, "Modulo by zero");
        }
        if (num instanceof Value_Rational) {
            return Value_Rational.simplify_integral(origin, this.rat.remainder(((Value_Rational)num).rat));
        }
        if (num instanceof Value_Integer) {
            return Value_Rational.simplify_integral(origin, this.rat.remainder(((Value_Integer)num).bi));
        }
        throw new Exception_Impossible_Operation(origin, "Incompatible type for modulo: " + num);
    }

    @Override
    public Value_Number subtract(I_Chunk_Origin origin, Value_Number num) throws Exception_Impossible_Operation {
        if (num instanceof Value_Rational) {
            return Value_Rational.simplify_integral(origin, this.rat.subtract(((Value_Rational)num).rat));
        }
        if (num instanceof Value_Integer) {
            return Value_Rational.simplify_integral(origin, this.rat.subtract(((Value_Integer)num).bi));
        }
        throw new Exception_Impossible_Operation(origin, "Incompatible type for subtraction: " + num);
    }

    @Override
    public String to_string(Context_To_String_Code tsc) {
        return this.rat.toString(":");
    }

    public static class Minus_Infinity
    extends Value_Rational {
        public Minus_Infinity(I_Chunk_Origin origin) {
            super(origin, Rational.MINUS_INFINITY);
        }
    }

    public static class Plus_Infinity
    extends Value_Rational {
        public Plus_Infinity(I_Chunk_Origin origin) {
            super(origin, Rational.PLUS_INFINITY);
        }
    }
}

