/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.language.value;

import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.I_Chunk_Origin;
import fr.univ_orleans.jdl.language.exception.Exception_Value_Uncomparable;
import fr.univ_orleans.jdl.language.exception.Exception_Value_Unconcatanable;
import fr.univ_orleans.jdl.language.value.I_Value_Comparable;
import fr.univ_orleans.jdl.language.value.I_Value_Concatenable;
import fr.univ_orleans.jdl.language.value.I_Value_Glyph;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Atomic;

public class Value_String
extends Value_Atomic
implements I_Value_Comparable,
I_Value_Glyph,
I_Value_Concatenable {
    public final String str;

    public static String protect(String str) {
        return "\"" + str.replaceAll("\n", "\\n").replaceAll("\"", "\\\\\"") + "\"";
    }

    public Value_String(I_Chunk_Origin origin, String str) {
        super(origin);
        this.str = str;
    }

    @Override
    public int compare_to(I_Value_Comparable v_c) throws Exception_Value_Uncomparable {
        if (!(v_c instanceof Value_String)) {
            this.throw_uncomparable(this, v_c);
        }
        return this.str.compareTo(((Value_String)v_c).str);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Value_String) {
            return this.str.equals(((Value_String)obj).str);
        }
        return super.equals(obj);
    }

    @Override
    public String get_glyph() {
        return this.str;
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    @Override
    public String to_code(Context_To_String_Code tcc) {
        return Value_String.protect(this.str);
    }

    @Override
    public String to_string(Context_To_String_Code tsc) {
        return Value_String.protect(this.str);
    }

    @Override
    public String toString() {
        return this.str;
    }

    @Override
    public Value concatenate(I_Chunk_Origin origin, Value v) throws Exception_Value_Unconcatanable {
        if (v instanceof I_Value_Glyph) {
            return new Value_String(origin, String.valueOf(this.str) + ((I_Value_Glyph)((Object)v)).get_glyph());
        }
        return new Value_String(origin, String.valueOf(this.str) + v.toString());
    }
}

