/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.test.driver;

import fr.univ_orleans.jdl.agc.AGC_Center;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Run;
import fr.univ_orleans.jdl.agc.I_Signal_Machine;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_Eps;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_Pdf;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_Run;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_Run_Writer;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_SVG;
import fr.univ_orleans.jdl.util.Rational;

public class Test_Driver_Pdf_Eps_Svg {
    private static final String STRING_DRIVER_TEST = "driver_test";
    static final I_Run run;
    static final I_Meta_Signal orange;
    static final I_Meta_Signal blue;

    static {
        I_Signal_Machine machine = AGC_Center.create_signal_machine();
        I_Meta_Signal black = machine.add_meta_signal("noir", 0, 1);
        black.set_color("black");
        black.set_property("line_style", "loosely dotted");
        I_Meta_Signal purple = machine.add_meta_signal("purple", 0);
        purple.set_color("purple");
        purple.set_property("line_style", "densely dotted");
        I_Meta_Signal red = machine.add_meta_signal("rouge", 1, 3);
        red.set_property("line_style", "dotted");
        red.set_color("red");
        orange = machine.add_meta_signal("orange", -1, 3);
        orange.set_color("darkOrange");
        orange.set_property("line_style", "loosely dashed");
        blue = machine.add_meta_signal("blue", 1, 1);
        blue.set_color("blue");
        blue.set_property("line_style", "dashed");
        I_Meta_Signal green = machine.add_meta_signal("vert", -1, 1);
        green.set_color("darkGreen");
        green.set_property("line_style", "loosely dotted");
        machine.add_collision_rule(new I_Meta_Signal[]{black, blue}, new I_Meta_Signal[]{black, green});
        machine.add_collision_rule(new I_Meta_Signal[]{black, green}, new I_Meta_Signal[]{black, blue});
        machine.add_collision_rule(new I_Meta_Signal[]{black, green, blue}, new I_Meta_Signal[]{black, green, blue});
        machine.add_collision_rule(new I_Meta_Signal[]{orange, blue}, new I_Meta_Signal[]{black, orange, red, green, blue});
        machine.add_collision_rule(new I_Meta_Signal[]{red, green}, new I_Meta_Signal[]{black, orange, red, green, blue});
        run = machine.create_configuration().run();
        run.add_signal(black, 0);
        run.add_signal(black, 100);
        run.add_signal(blue, 50);
        run.add_signal(green, 50);
        run.add_signal(orange, 50);
        run.add_signal(red, 50);
        run.add_signal(black, 50);
        run.add_signal(purple, 60);
        run.make_collision_step(11L);
    }

    public static void main(String[] args) {
        Test_Driver_Pdf_Eps_Svg.test_for_driver("./Output/Test/Eps/driver_test", new Driver_Export_Eps(run));
        Test_Driver_Pdf_Eps_Svg.test_for_driver("./Output/Test/Pdf/driver_test", new Driver_Export_Pdf(run));
        Test_Driver_Pdf_Eps_Svg.test_for_driver("./Output/Test/Svg/driver_test", new Driver_Export_SVG(run));
        System.out.println("### FINISHED ###");
    }

    private static void test_for_driver(String file_name_full, Driver_Export_Run_Writer drv) {
        try {
            drv.set_scale(new Rational(3L));
            drv.set_clipping(new Rational(10L), new Rational(20L), new Rational(80L), new Rational(90L));
            drv.set_draw_collisions(Driver_Export_Run.Draw_Collisions.AFTER);
            drv.write_diagram(file_name_full);
            System.out.println(file_name_full);
            file_name_full = String.valueOf(file_name_full) + "_rule";
            drv.reset();
            drv.write_rule(file_name_full, new I_Meta_Signal[]{orange, blue}, new Rational(10L));
            System.out.println(file_name_full);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

