/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.test.driver;

import fr.univ_orleans.jdl.agc.AGC_Center;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Run;
import fr.univ_orleans.jdl.agc.I_Signal_Machine;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_Graphics2D;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_LaTeX;
import fr.univ_orleans.jdl.agc.driver.Driver_Import_AGC;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class Test_Drivers {
    static final I_Signal_Machine machine = AGC_Center.create_signal_machine();
    static final I_Run run;
    static final I_Meta_Signal orange;
    static final I_Meta_Signal black;
    static final I_Meta_Signal blue;
    static final I_Meta_Signal red;
    static final I_Meta_Signal green;

    static {
        black = machine.add_meta_signal("noir", 0, 1);
        black.set_color("black");
        red = machine.add_meta_signal("rouge", 1, 3);
        red.set_color("red");
        orange = machine.add_meta_signal("orange", -1, 3);
        orange.set_color("darkOrange");
        blue = machine.add_meta_signal("blue", 1, 1);
        blue.set_color("blue");
        green = machine.add_meta_signal("vert", -1, 1);
        green.set_color("darkGreen");
        machine.add_collision_rule(new I_Meta_Signal[]{black, blue}, new I_Meta_Signal[]{black, green});
        machine.add_collision_rule(new I_Meta_Signal[]{black, green}, new I_Meta_Signal[]{black, blue});
        machine.add_collision_rule(new I_Meta_Signal[]{black, green, blue}, new I_Meta_Signal[]{black, green, blue});
        machine.add_collision_rule(new I_Meta_Signal[]{orange, blue}, new I_Meta_Signal[]{black, orange, red, green, blue});
        machine.add_collision_rule(new I_Meta_Signal[]{red, green}, new I_Meta_Signal[]{black, orange, red, green, blue});
        run = machine.create_configuration().run();
        run.add_signal(black, 0);
        run.add_signal(blue, 50);
        run.add_signal(green, 50);
        run.add_signal(orange, 50);
        run.add_signal(red, 50);
        run.add_signal(black, 50);
        run.add_signal(black, 100);
        run.make_collision_step(11L);
    }

    public static void main(String[] args) {
        try {
            Test_Drivers.test_latex();
            Test_Drivers.test_awt_swing();
            Test_Drivers.test_input_language();
            System.out.println("### FINISHED ###");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void test_awt_swing() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 900);
        JComponent jc = new JComponent(){
            private final I_Run local_run = run;
            static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g) {
                Driver_Export_Graphics2D dg = new Driver_Export_Graphics2D(this.local_run, (Graphics2D)g);
                dg.draw();
            }
        };
        frame.getContentPane().add(jc);
        frame.setVisible(true);
    }

    private static void test_input_language() throws IOException {
        Driver_Import_AGC dia = new Driver_Import_AGC("./Data/Test/Language/machine.agc");
        dia.get_signal_machine().forEach(s -> {
            System.out.println(s);
            dia.get_configuration((I_Signal_Machine)s).forEach(c -> {
                System.out.println("-----------------------------------");
                System.out.println(c);
            });
            System.out.println("===================================");
        });
    }

    private static void test_latex() {
        try {
            Driver_Export_LaTeX dl = new Driver_Export_LaTeX(run);
            dl.set_unit("1em");
            dl.add_package("package");
            dl.add_package("package", "opt");
            dl.add_input("Vocabulary.tex");
            dl.write_diagram("./Output/Test/Latex/driver_test_latex.tex");
        }
        catch (IOException ioe) {
            System.err.println("erreur de lecture" + ioe);
        }
    }
}

