/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.test.kernel;

import com.itextpdf.text.DocumentException;
import fr.univ_orleans.jdl.agc.AGC_Center;
import fr.univ_orleans.jdl.agc.I_Configuration;
import fr.univ_orleans.jdl.agc.I_Meta_Signal;
import fr.univ_orleans.jdl.agc.I_Run;
import fr.univ_orleans.jdl.agc.I_Signal_Machine;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_Run_Writer;
import fr.univ_orleans.jdl.agc.kernel.Run;
import fr.univ_orleans.jdl.agc.util.Util_Print;
import fr.univ_orleans.jdl.util.Rational;
import java.awt.Color;
import java.io.IOException;

public class Test_Basique {
    public static void main(String[] args) {
        I_Signal_Machine p = AGC_Center.create_signal_machine();
        I_Meta_Signal kBlack = p.add_meta_signal("black", 0, 1);
        kBlack.set_color(Color.black);
        I_Meta_Signal kRed = p.add_meta_signal("red", 1, 2);
        kRed.set_color(Color.red);
        I_Meta_Signal kOrange = p.add_meta_signal("orange", -1, 2);
        kOrange.set_color(Color.orange);
        I_Meta_Signal kBlue = p.add_meta_signal("blue", 1, 1);
        kBlue.set_color(Color.blue);
        I_Meta_Signal kGreen = p.add_meta_signal("green", -1, 1);
        kGreen.set_color(Color.green);
        Util_Print.print_meta_signals(p);
        p.add_collision_rule(new I_Meta_Signal[]{kBlack, kBlue}, new I_Meta_Signal[]{kBlack, kGreen});
        p.add_collision_rule(new I_Meta_Signal[]{kBlack, kGreen}, new I_Meta_Signal[]{kBlack, kBlue});
        p.add_collision_rule(new I_Meta_Signal[]{kBlack, kOrange}, new I_Meta_Signal[]{kBlack, kRed});
        p.add_collision_rule(new I_Meta_Signal[]{kBlack, kRed}, new I_Meta_Signal[]{kBlack, kOrange});
        p.add_collision_rule(new I_Meta_Signal[]{kBlack, kOrange}, new I_Meta_Signal[]{kBlack, kRed});
        p.add_collision_rule(new I_Meta_Signal[]{kBlack, kOrange, kRed}, new I_Meta_Signal[]{kBlack, kOrange, kRed, kGreen, kBlue});
        p.add_collision_rule(new I_Meta_Signal[]{kRed, kGreen}, new I_Meta_Signal[]{kBlack});
        p.add_collision_rule(new I_Meta_Signal[]{kBlue, kGreen}, new I_Meta_Signal[]{kBlack});
        try {
            p.add_collision_rule(new I_Meta_Signal[]{kBlue}, new I_Meta_Signal[]{kBlack});
            throw new RuntimeException("This should raise an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                p.add_collision_rule(new I_Meta_Signal[0], new I_Meta_Signal[]{kBlack});
                throw new RuntimeException("This should raise an exception");
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                Util_Print.print_collision_rules(p);
                I_Configuration conf = p.create_configuration();
                conf.add_signal(kBlack, Rational.ZERO);
                conf.add_signal(kBlack, 10);
                conf.add_signal(kBlue, 2);
                conf.add_signal(kOrange, 6, 1);
                conf.add_signal(kRed, 5);
                conf.add_signal(kBlack, 11, 2);
                Util_Print.print_present_signals(conf);
                I_Run run = conf.run();
                Util_Print.print_forecasted_collisions((Run)run);
                run.make_collision_step(8L);
                Util_Print.print_present_signals(run);
                AGC_Center.provide_canvas(run, null);
                Driver_Export_Run_Writer exp = AGC_Center.create_driver_export_run_writer("PDF", run);
                exp.set_scale(new Rational(5L));
                try {
                    String file_name_base = "./Output/Test/Pdf/" + Thread.currentThread().getStackTrace()[1].getClassName();
                    System.out.println(file_name_base);
                    exp.write_diagram(file_name_base);
                    exp.write_rule(String.valueOf(file_name_base) + "-rule", new I_Meta_Signal[]{kBlack, kRed}, new Rational(2L));
                }
                catch (DocumentException | IOException e) {
                    e.printStackTrace();
                }
                return;
            }
        }
    }
}

