/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.test.language;

import fr.univ_orleans.jdl.language.Chunk;
import fr.univ_orleans.jdl.language.Chunk_Origin_CONTANT;
import fr.univ_orleans.jdl.language.Context_To_String_Code;
import fr.univ_orleans.jdl.language.Eval_Context;
import fr.univ_orleans.jdl.language.driver.Driver_Import;
import fr.univ_orleans.jdl.language.exception.Language_Throwable;
import fr.univ_orleans.jdl.language.exception.Lexical_Error;
import fr.univ_orleans.jdl.language.exception.Syntax_Error;
import fr.univ_orleans.jdl.language.library.AGC.AGC_Signal_Machine;
import fr.univ_orleans.jdl.language.parser.SM_Language_Parser;
import fr.univ_orleans.jdl.language.value.Value;
import fr.univ_orleans.jdl.language.value.Value_Boolean;
import fr.univ_orleans.jdl.language.value.Value_Character;
import fr.univ_orleans.jdl.language.value.Value_Context_Holder_Basic;
import fr.univ_orleans.jdl.language.value.Value_Integer;
import fr.univ_orleans.jdl.language.value.Value_Rational;
import fr.univ_orleans.jdl.language.value.Value_Special;
import fr.univ_orleans.jdl.language.value.Value_String;
import fr.univ_orleans.jdl.util.Rational;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.junit.Assert;
import org.junit.Test;

public class JUnit_Language {
    private static final String STRING_NEW_LINE_LINE = "\nLINE ";
    private static final String STRING_SHARP_SHARP_CTX = "## ctx:\n";
    private static final String STRING_LINE_BAR = "\n--------------------\n";
    private static final String STRING_PROBLEM_READING = "Problem reading ";
    private static final String STRING_PROGRAM_ERROR = "PROGRAM ERROR";
    static ANTLRErrorListener error_listener_lexical = new BaseErrorListener(){

        @Override
        public void syntaxError(Recognizer<?, ?> arg0, Object arg1, int arg2, int arg3, String arg4, RecognitionException arg5) {
            throw new Lexical_Error("line " + arg2 + ":" + arg3 + " " + arg4, arg5);
        }
    };
    static ANTLRErrorListener error_listener_syntaxic = new BaseErrorListener(){

        @Override
        public void syntaxError(Recognizer<?, ?> arg0, Object arg1, int arg2, int arg3, String arg4, RecognitionException arg5) {
            throw new Lexical_Error("line " + arg2 + ":" + arg3 + " " + arg4, arg5);
        }
    };
    static final String FILE_SUFFIX_NEW_VERSION = ".new";
    static final String MSG_ERROR = "ERROR";
    static final String MSG_LEXICAL_ERROR = "LEXICAL ERROR";
    static final String MSG_SYNTAX_ERROR = "SYNTAX ERROR";
    static final String TEST__SEQUENCE_DIR = "./Data/Test/Language/";
    static final String TEST_MACHINE_FILE_AGC = "./Data/Test/Language/machine.agc";
    static final String TEST_PART_NEXT = "<<NEXT>>";
    static final String TEST_PART_OUT = "<<OUT>>";
    static final String TEST_SEQUENCE_FILE_SANBOX_TMP = "./Data/Test/Language/language_test_sandbox_tmp.agc";
    static final String TEST_SEQUENCE_FILE = "./Data/Test/Language/language_test_sequence.agc";
    static final String TEST_SEQUENCE_FILE_AGC = "./Data/Test/Language/language_test_sequence_AGC.agc";
    static final String TEST_SEQUENCE_FILE_AGC_MODULE = "./Data/Test/Language/language_test_sequence_AGC_Module.agc";
    static final String TEST_SEQUENCE_FILE_ERROR = "./Data/Test/Language/language_test_sequence_ERROR.agc";
    static final String TEST_SEQUENCE_FILE_FUNCTION = "./Data/Test/Language/language_test_sequence_function.agc";
    static final String TEST_SEQUENCE_FILE_CONTEXT = "./Data/Test/Language/language_test_sequence_context.agc";

    static void generate_test_program_sequence(boolean is_test) {
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE, is_test);
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE_AGC, is_test);
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE_AGC_MODULE, is_test);
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE_ERROR, is_test);
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE_FUNCTION, is_test);
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE_CONTEXT, is_test);
    }

    static void generate_test_program_sequence(String file_name, boolean is_test) {
        System.out.println("Opening " + file_name);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader in = new BufferedReader(new FileReader(file_name));){
                String s;
                String kind;
                PrintStream new_version = null;
                if (is_test) {
                    System.out.println("Processing test programs");
                    kind = "Test";
                } else {
                    new_version = new PrintStream(String.valueOf(file_name) + FILE_SUFFIX_NEW_VERSION);
                    System.out.println("Generating " + file_name + FILE_SUFFIX_NEW_VERSION);
                    kind = "Generation";
                }
                boolean is_input = true;
                StringBuilder prog = new StringBuilder("");
                StringBuilder expected_output = new StringBuilder("");
                String output = "";
                int line = 0;
                int line_prog = 1;
                while ((s = in.readLine()) != null) {
                    ++line;
                    if (TEST_PART_OUT.equals(s)) {
                        is_input = false;
                        continue;
                    }
                    if (TEST_PART_NEXT.equals(s)) {
                        System.out.println(String.valueOf(kind) + " LINE " + line_prog);
                        try {
                            Eval_Context e_v = new Eval_Context();
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            e_v.set_print_out_stream(new PrintStream(baos));
                            Chunk ch = JUnit_Language.parse_program(prog.toString());
                            Value v_got = ch.eval(e_v);
                            Context_To_String_Code cts_c = new Context_To_String_Code();
                            output = baos + "## result:" + (v_got == e_v.get_current_search() ? " <just the context>" : "\n" + v_got) + "\n## code:\n" + ch.to_code(cts_c) + STRING_SHARP_SHARP_CTX + e_v.get_current_search();
                        }
                        catch (Lexical_Error re) {
                            output = "LEXICAL ERROR: " + re.getLocalizedMessage();
                        }
                        catch (Syntax_Error re) {
                            output = "SYNTAX ERROR: " + re.getLocalizedMessage();
                        }
                        catch (Language_Throwable e) {
                            output = "ERROR\n" + e;
                            e.printStackTrace();
                        }
                        if (is_test) {
                            Assert.assertEquals(STRING_NEW_LINE_LINE + line_prog + '\n' + prog + "\n----------- GENERATED ---------\n" + output + STRING_LINE_BAR, expected_output.toString(), String.valueOf(output) + '\n');
                        } else {
                            new_version.println(prog + TEST_PART_OUT + '\n' + output + '\n' + TEST_PART_NEXT);
                        }
                        is_input = true;
                        prog = new StringBuilder("");
                        expected_output = new StringBuilder("");
                        line_prog = line + 1;
                        continue;
                    }
                    if (is_input) {
                        prog.append(String.valueOf(s) + '\n');
                        continue;
                    }
                    expected_output.append(String.valueOf(s) + '\n');
                }
                if (!is_test) {
                    new_version.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            System.err.println(STRING_PROBLEM_READING + file_name);
            System.exit(1);
        }
    }

    static SM_Language_Parser parse(CharStream cs, String id) {
        return Driver_Import.get_parser(cs, id);
    }

    static SM_Language_Parser parse(InputStream is, String id) {
        try {
            return JUnit_Language.parse(CharStreams.fromStream(is), id);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static Chunk parse_expression(String cs) {
        return JUnit_Language.parse((CharStream)CharStreams.fromString((String)cs), null).expression_right().chunk;
    }

    static Chunk parse_program(CharStream cs, String id) {
        return JUnit_Language.parse((CharStream)cs, (String)id).program().chunk;
    }

    static Chunk parse_program(String s) {
        return JUnit_Language.parse_program(CharStreams.fromString(s), s);
    }

    static Value evaluate_expression(String s) {
        Chunk ch = null;
        try {
            ch = JUnit_Language.parse_expression(s);
            Eval_Context e_v = new Eval_Context();
            return ch.eval(e_v);
        }
        catch (Language_Throwable e) {
            System.err.println("## ERROR on " + s);
            e.printStackTrace();
            if (ch != null) {
                Context_To_String_Code ctsc = new Context_To_String_Code();
                ctsc.force_parenthesis(true);
                System.out.println(ch.to_code(ctsc));
            }
            return null;
        }
    }

    static void test_machine(String machine_file) {
        System.out.println("\nREADING FILE: " + machine_file + "\n");
        Eval_Context e_v = new Eval_Context();
        AGC_Signal_Machine mach = new AGC_Signal_Machine(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL);
        Value_Context_Holder_Basic vch = new Value_Context_Holder_Basic(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, e_v.get_current_block(), mach);
        e_v.push_block(vch);
        Chunk ch = null;
        try {
            ch = JUnit_Language.parse_program(CharStreams.fromFileName(machine_file), machine_file);
            Value v_got = ch.eval(e_v);
            System.out.println("## v_got: " + v_got);
            System.out.print("## code:\n" + ch.to_code(new Context_To_String_Code()));
            System.out.println(STRING_SHARP_SHARP_CTX + e_v.get_current_block());
        }
        catch (Lexical_Error | ParseCancellationException e) {
            if (ch != null) {
                Context_To_String_Code ctsc = new Context_To_String_Code();
                ctsc.force_parenthesis(true);
                System.out.println(ch.to_code(ctsc));
            }
        }
        catch (Language_Throwable e) {
            System.out.println(STRING_PROGRAM_ERROR);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println(STRING_PROBLEM_READING + machine_file);
            e.printStackTrace();
        }
    }

    static void test_program(String prog) {
        System.out.println(String.valueOf('\n') + prog + "\n");
        System.out.println(TEST_PART_OUT);
        Eval_Context e_v = new Eval_Context();
        Chunk ch = null;
        try {
            ch = JUnit_Language.parse_program(prog);
            Value v_got = ch.eval(e_v);
            System.out.println("## v_gott: " + v_got);
            System.out.print("## code:\n" + ch.to_code(new Context_To_String_Code()));
            System.out.println(STRING_SHARP_SHARP_CTX + e_v.get_current_block());
        }
        catch (Lexical_Error | ParseCancellationException e) {
            System.out.println(e);
            if (ch != null) {
                Context_To_String_Code ctsc = new Context_To_String_Code();
                ctsc.force_parenthesis(true);
                System.out.println(ch.to_code(ctsc));
            }
        }
        catch (Language_Throwable e) {
            System.out.println(STRING_PROGRAM_ERROR);
            e.printStackTrace();
        }
        System.out.println(TEST_PART_NEXT);
    }

    static void test_stability(String test_file) {
        System.out.println("Testing for stability file " + test_file);
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(test_file));){
                String s;
                boolean is_input = true;
                StringBuilder prog = new StringBuilder("");
                int line = 0;
                int line_prog = 1;
                while ((s = br.readLine()) != null) {
                    ++line;
                    if (TEST_PART_OUT.equals(s)) {
                        is_input = false;
                        continue;
                    }
                    if (TEST_PART_NEXT.equals(s)) {
                        System.out.println("Stability LINE " + line_prog);
                        String prog_2 = null;
                        String prog_3 = null;
                        String v_got = null;
                        String v_got_2 = null;
                        Chunk ch = null;
                        Chunk ch_2 = null;
                        try {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            Eval_Context e_c = new Eval_Context();
                            e_c.set_print_out_stream(new PrintStream(baos));
                            ch = JUnit_Language.parse_program(prog.toString());
                            prog_2 = ch.to_code(new Context_To_String_Code());
                            ch_2 = JUnit_Language.parse_program(prog_2);
                            prog_3 = ch_2.to_code(new Context_To_String_Code());
                            v_got = ch.eval(e_c).to_string(new Context_To_String_Code());
                            e_c = new Eval_Context();
                            e_c.set_print_out_stream(new PrintStream(baos));
                            v_got_2 = ch_2.eval(e_c).to_string(new Context_To_String_Code());
                        }
                        catch (Lexical_Error re) {
                            System.err.println(re);
                            System.out.println(MSG_SYNTAX_ERROR + re.getMessage());
                        }
                        catch (ParseCancellationException re) {
                            System.err.println(re);
                            System.out.println(MSG_SYNTAX_ERROR);
                        }
                        catch (Language_Throwable e) {
                            System.out.println(STRING_PROGRAM_ERROR);
                            e.printStackTrace();
                        }
                        Assert.assertEquals(STRING_NEW_LINE_LINE + line_prog + '\n' + "\n----------- GENERATED code ---------\n" + prog + STRING_LINE_BAR, prog_2, prog_3);
                        Assert.assertEquals(STRING_NEW_LINE_LINE + line_prog + '\n' + "\n----------- GENERATED copntext ---------\n" + prog + STRING_LINE_BAR, v_got, v_got_2);
                        is_input = true;
                        prog = new StringBuilder("");
                        line_prog = line + 1;
                        continue;
                    }
                    if (!is_input) continue;
                    prog.append(String.valueOf(s) + '\n');
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            System.err.println(STRING_PROBLEM_READING + test_file);
            ioe.printStackTrace();
            System.exit(1);
        }
    }

    @Test
    public void generate_program_sequence() {
        JUnit_Language.generate_test_program_sequence(false);
    }

    @Test
    public void generate_sequence_sandbox_tmp() {
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE_SANBOX_TMP, false);
    }

    @Test
    public void generate_sequence_agc() {
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE_AGC, false);
    }

    @Test
    public void generate_sequence_agc_module() {
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE_AGC_MODULE, false);
    }

    @Test
    public void generate_sequence_base() {
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE, false);
    }

    @Test
    public void generate_sequence_error() {
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE_ERROR, false);
    }

    @Test
    public void generate_sequence_function() {
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE_FUNCTION, false);
    }

    @Test
    public void test_expression_val() {
        Assert.assertEquals(JUnit_Language.evaluate_expression(" false "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" true "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" ! true "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" ! false "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" true && true "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" true && false "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" false && true "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" false && false "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" true == true "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" true == false "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" false == true "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" false == false "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 18 == 18"), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 18 == 9*2 "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 18 == 18 / 1"), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" [] == [] "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" [75] == [75] "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" [75,'t'] == [75,'t'] "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" [75] == [75,'u'] "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" [75,'t'] == [75,'u'] "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" [75,'t'] == [74,'t'] "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" true || true "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" true || false "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" false || true "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" false || false "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" ! false || ! true "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" ! false ||false && false "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" ( false ) "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" ( false ||false && false ) "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" ! ( false ||false && false ) "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" false != true "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" ! false != ! true "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 + 2 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(14L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 / 5 + 2 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(22L, 5L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 + 2 / 5 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(62L, 5L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 / 5 + 2 / 5 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(14L, 5L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 - 2 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(10L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 / 5 - 2 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(2L, 5L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 - 2 / 5 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(58L, 5L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 / 5 - 2 / 5 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(2L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 * 2 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(24L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 / 5 * 2 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(24L, 5L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 * 2 / 5 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(24L, 5L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 / 5 * 2 / 5 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(24L, 25L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 / 2 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(6L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 13 / 2 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(13L, 2L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 / 5 / 2 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(12L, 10L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 / ( 2 / 5 )"), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(30L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" ( 12 / 5 ) / ( 2 / 5 ) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(6L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 /% 2 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(6L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 13 /% 2 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(6L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 / 5 /% 2 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(1L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 /% ( 2 / 5 )"), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(30L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression("( 12 / 5 ) /% ( 2 / 5 )"), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(6L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression("( 13 / 5 ) /% ( 2 / 5 )"), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(6L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 % 2 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 13 % 2 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(1L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 / 5 % 2 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(2L, 5L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 % ( 2 / 5 )"), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(0L, 1L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 2 % ( 3 / 5 )"), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(1L, 5L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression("( 12 / 5 ) % ( 2 / 5 )"), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression("( 13 / 5 )% ( 2 / 5 )"), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(1L, 5L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 50 /% ( 6 / 5 ) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(41L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 50 % ( 6 / 5 )"), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(4L, 5L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 /% 13 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 % 13 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(8L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 - ( 47 /% 13) * 13 - ( 47 % 13) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 /% -13 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(-3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 % -13 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(8L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 - ( 47 /% -13) * -13 - ( 47 % -13) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 /% 13 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(-3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 % 13 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(-8L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 - ( -47 /% 13) * 13 - ( -47 % 13) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 /% -13 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 % -13 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(-8L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 - ( -47 /% -13) * -13 - ( -47 % -13) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 23 / 5 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(23L, 5L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 20 / 5  + 3 / 5 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(23L, 5L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 20 / 5  - 3 / 5 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(17L, 5L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 20 / 5  * 3 / 5 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(60L, 25L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 20 / 5  / ( 3 / 5 )"), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(20L, 3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 20 / 5  + 3 / 5 - 10 / 7 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(111L, 35L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" ( 20 / 5 ) / ( 3 / 5 ) "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(20L, 3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" ( 20 / 5 ) / ( 3 / 5 ) / ( 20 / 5  / ( 3 / 5 ) ) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(1L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 88 / 5 - 8 / 5 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(16L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 88 - 5 - 8 - 5 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(70L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 88 - ( 5 + 8 + 5 ) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(70L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 / 3 /% 13 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(1L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 / 3 % 13 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(8L, 3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 / 3 - ( 47 / 3 /% 13) * 13 - ( 47 / 3 % 13) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 / 3 /% -13 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(-1L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 / 3 % -13 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(8L, 3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 / 3 - ( 47 / 3 /% -13) * -13 - ( 47 / 3 % -13) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 / 3 /% 13 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(-1L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 / 3 % 13 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(-8L, 3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 / 3 - ( -47 / 3 /% 13) * 13 - ( -47 / 3 % 13) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 / 3 /% -13 "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(1L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 / 3 % -13 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(-8L, 3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 / 3 - ( -47 / 3 /% -13) * -13 - ( -47 / 3 % -13) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 /% ( 13 / 3 )"), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(10L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 % ( 13 / 3 )"), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(11L, 3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 - ( 47 /% ( 13 / 3 ) ) * ( 13 / 3 ) - ( 47 % ( 13 / 3 ) ) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 /% ( -13 / 3 ) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(-10L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 % ( -13 / 3 ) "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(11L, 3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 - ( 47 /% ( -13 / 3 ) ) * ( -13 / 3 ) - ( 47 % ( -13 / 3 ) ) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 /% ( 13 / 3 )"), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(-10L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 % ( 13 / 3 )"), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(-11L, 3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 - ( -47 /% ( 13 / 3 ) ) * ( 13 / 3 ) - ( -47 % ( 13 / 3 ) ) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 /% ( -13 / 3 )"), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(10L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 % - ( 13 / 3 )"), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(-11L, 3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 - ( -47 /% - ( 13 / 3 ) ) * - ( 13 / 3 ) - ( -47 % - ( 13 / 3 ) ) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 / 3 /% ( 13 / 3 )"), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 / 3 % ( 13 / 3 )"), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(8L, 3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 / 3 - ( 47 / 3 /% ( 13 / 3) ) * ( 13 / 3 ) - ( ( 47 / 3 ) % ( 13 / 3 ) ) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression("( 47 / 3 ) /% ( -13 / 3 )"), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(-3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression("( 47 / 3 ) % ( -13 / 3 )"), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(8L, 3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 47 / 3 - ( 47 / 3 /% ( -13 / 3 ) ) * ( -13 / 3 ) - ( 47 / 3 % ( -13 / 3 )) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 / 3 /% ( 13 / 3 )"), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(-3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 / 3 % ( 13 / 3 )"), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(-8L, 3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 / 3 - ( -47 / 3 /% ( 13 / 3 ) ) * ( 13 / 3 ) - ( -( 47 / 3 ) % ( 13 / 3 ) ) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 / 3 /% ( -13 / 3 )"), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 / 3 % (-13 / 3 )"), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, new Rational(-8L, 3L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" -47 / 3 - ( -47 / 3 /% ( -13 / 3 ) ) * -13 / 3 - ( -47 / 3 % ( -13 / 3 ) ) "), new Value_Integer(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, BigInteger.valueOf(0L)));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 0 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, Rational.ZERO));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 0 / 3 "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, Rational.ZERO));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 0 / ( 3 / 4 ) "), new Value_Rational(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, Rational.ZERO));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 8 != 14 "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 8 + 2 == 14 - 4 "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 8 < 12 "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 < 8 "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 < 12 "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 <= 12 "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 \u2264 12 "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 45 / 4 < 45 / 4 "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 45 / 4 <= 45 / 4 "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 45 / 4 \u2264 45 / 4 "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 80 /7 < 12 /11 "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 <= 120 < 230 "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 <= 120 < 23 "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 <= 11 < 23 "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 \u2264 11 < 23 "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 \u2264 11 == 23 "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 12 != 11 != 23 "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" \"aze\" "), new Value_String(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, "aze"));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" \"ag\" _ \"ze\" "), new Value_String(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, "agze"));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 'a' _ \"ze\" "), new Value_String(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, "aze"));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" \"ag\" _ 'z' "), new Value_String(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, "agz"));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" 'a' _ 'z' "), new Value_String(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, "az"));
        Assert.assertEquals(JUnit_Language.evaluate_expression(" \"abc\" < \"xyz\" "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" \"abc\" <= \"xyz\" "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" \"abc\" \u2264 \"xyz\" "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" \"zyc\" < \"cba\" "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" \"zyc\" <= \"cba\" "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" \"EQUAL\" < \"EQUAL\" "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" \"EQUAL\" <= \"EQUAL\" "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" \"EQUAL\" \u2264 \"EQUAL\" \u2264 \"ZERO\" "), Value_Boolean.TRUE);
        Assert.assertEquals(JUnit_Language.evaluate_expression(" \"EQUAL\" \u2264 \"EQUAL\" < \"ALPHA\" "), Value_Boolean.FALSE);
        Assert.assertEquals(JUnit_Language.evaluate_expression("'A'"), new Value_Character(Chunk_Origin_CONTANT.ORIGIN_TOP_LEVEL, 'A'));
        Assert.assertEquals(JUnit_Language.evaluate_expression("error").getClass(), Value_Special.Value_Error.class);
        Assert.assertEquals(JUnit_Language.evaluate_expression("undef").getClass(), Value_Special.Value_Undefined.class);
        Assert.assertEquals(JUnit_Language.evaluate_expression("void").getClass(), Value_Special.Value_Void.class);
    }

    @Test
    public void test_machine() {
        JUnit_Language.test_machine(TEST_MACHINE_FILE_AGC);
    }

    @Test
    public void test_sequence_AGC() {
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE_AGC, true);
    }

    @Test
    public void test_sequence_AGC_module() {
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE_AGC_MODULE, true);
    }

    @Test
    public void test_sequence_base() {
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE, true);
    }

    @Test
    public void test_sequence_error() {
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE_ERROR, true);
    }

    @Test
    public void test_sequence_context() {
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE_CONTEXT, true);
    }

    @Test
    public void test_sequence_function() {
        JUnit_Language.generate_test_program_sequence(TEST_SEQUENCE_FILE_FUNCTION, true);
    }

    @Test
    public void test_stability() {
        JUnit_Language.test_stability(TEST_SEQUENCE_FILE);
        JUnit_Language.test_stability(TEST_SEQUENCE_FILE_AGC);
        JUnit_Language.test_stability(TEST_SEQUENCE_FILE_AGC_MODULE);
        JUnit_Language.test_stability(TEST_SEQUENCE_FILE_FUNCTION);
        JUnit_Language.test_stability(TEST_SEQUENCE_FILE_ERROR);
    }
}

