/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.test.turing_machine;

import com.itextpdf.text.DocumentException;
import fr.univ_orleans.jdl.agc.I_Run;
import fr.univ_orleans.jdl.agc.driver.Driver_Export_Pdf;
import fr.univ_orleans.jdl.turing_machine.Turing_Machine;
import fr.univ_orleans.jdl.turing_machine.driver.Turing_Machine_Reader;
import fr.univ_orleans.jdl.turing_machine.driver.Turing_Machine_To_Latex;
import fr.univ_orleans.jdl.turing_machine.driver.Turing_Machine_To_Signal_Machine;
import fr.univ_orleans.jdl.util.Rational;
import java.io.IOException;

public class Test_Turing_Machine {
    private static final String STRING_TEST_TUR_MACH = "test_tur_mach";
    static final String FILES = "test.tm";

    public static void main(String[] args) throws DocumentException, IOException {
        Turing_Machine tm = Turing_Machine_Reader.read("./Data/Test/Turing_Machine/test.tm");
        System.out.print(tm);
        Turing_Machine_To_Signal_Machine sm = new Turing_Machine_To_Signal_Machine(tm, new Rational(1L, 1L));
        I_Run run = sm.create_configuration().run();
        sm.put_initial_signals(run);
        run.make_collision_step(12L);
        Driver_Export_Pdf dpdf = new Driver_Export_Pdf(run);
        System.out.println("./Output/Test/Pdf/test_tur_mach");
        dpdf.write_diagram("./Output/Test/Pdf/test_tur_mach");
        System.out.println(tm.get_configuration());
        int i = 0;
        while (i < 7) {
            tm.make_transition();
            System.out.println(tm.get_configuration());
            ++i;
        }
        Turing_Machine_To_Latex tm_l = new Turing_Machine_To_Latex(tm);
        tm_l.set_symbol_latex(0, "\\#");
        tm_l.set_state_latex(0, "\\ensuremath{q_0}");
        tm_l.set_state_latex(1, "\\ensuremath{q_1}");
        tm_l.write_transition_table("./Output/Test/Latex/test_tur_mach");
        tm_l.write_configuration("./Output/Test/Latex/test_tur_mach_conf");
        System.out.println("./Output/Test/Latex/test_tur_mach");
        tm_l.write_run("./Output/Test/Latex/test_tur_mach_run", 2);
        System.out.println("### FINISHED ###");
    }
}

