/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.test.util;

import fr.univ_orleans.jdl.util.Rational;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Test;

public class JUnit_Rational {
    @Test
    public void test_create() {
        Assert.assertEquals(new Rational(0L), Rational.ZERO);
        Assert.assertEquals(new Rational(0L, 100L), Rational.ZERO);
        Assert.assertEquals(new Rational(0L, -100L), Rational.ZERO);
        Assert.assertEquals(Rational.value_of("0/10"), Rational.ZERO);
        Assert.assertEquals(Rational.value_of("0"), Rational.ZERO);
        Assert.assertEquals(Rational.value_of("-0 / 10"), Rational.ZERO);
        Assert.assertEquals(Rational.value_of("-0 / -10"), Rational.ZERO);
        Assert.assertEquals(new Rational(1L), Rational.ONE);
        Assert.assertEquals(new Rational(1L, 1L), Rational.ONE);
        Assert.assertEquals(new Rational(100L, 100L), Rational.ONE);
        Assert.assertEquals(new Rational(-1L, -1L), Rational.ONE);
        Assert.assertEquals(new Rational(-100L, -100L), Rational.ONE);
        Assert.assertEquals(Rational.value_of("10/10"), Rational.ONE);
        Assert.assertEquals(Rational.value_of("1"), Rational.ONE);
        Assert.assertEquals(Rational.value_of("-100 / -100"), Rational.ONE);
        Assert.assertEquals(new Rational(-1L), Rational.MINUS_ONE);
        Assert.assertEquals(new Rational(-1L, 1L), Rational.MINUS_ONE);
        Assert.assertEquals(new Rational(-100L, 100L), Rational.MINUS_ONE);
        Assert.assertEquals(new Rational(1L, -1L), Rational.MINUS_ONE);
        Assert.assertEquals(new Rational(100L, -100L), Rational.MINUS_ONE);
        Assert.assertEquals(Rational.value_of("-10/10"), Rational.MINUS_ONE);
        Assert.assertEquals(Rational.value_of("-1"), Rational.MINUS_ONE);
        Assert.assertEquals(Rational.value_of("100 / -100"), Rational.MINUS_ONE);
        Assert.assertEquals(new Rational(2L), Rational.TWO);
        Assert.assertEquals(new Rational(2L, 1L), Rational.TWO);
        Assert.assertEquals(new Rational(200L, 100L), Rational.TWO);
        Assert.assertEquals(new Rational(-2L, -1L), Rational.TWO);
        Assert.assertEquals(new Rational(-200L, -100L), Rational.TWO);
        Assert.assertEquals(Rational.value_of("20/10"), Rational.TWO);
        Assert.assertEquals(Rational.value_of("2"), Rational.TWO);
        Assert.assertEquals(Rational.value_of("200 / 100"), Rational.TWO);
        Assert.assertEquals(Rational.value_of("-200 / -100"), Rational.TWO);
        Assert.assertEquals(new Rational(-207L, -97L), Rational.value_of("207/97"));
    }

    @Test
    public void test_compare_lt() {
        Assert.assertEquals(Rational.MINUS_INFINITY.compareTo(BigInteger.ZERO), -1L);
        Assert.assertEquals(Rational.MINUS_INFINITY.compareTo(BigInteger.ONE), -1L);
        Assert.assertEquals(Rational.MINUS_INFINITY.compareTo(BigInteger.TWO), -1L);
        Assert.assertEquals(Rational.MINUS_INFINITY.compareTo(BigInteger.TEN), -1L);
        Assert.assertEquals(Rational.MINUS_ONE.compareTo(BigInteger.ZERO), -1L);
        Assert.assertEquals(Rational.MINUS_ONE.compareTo(BigInteger.ONE), -1L);
        Assert.assertEquals(Rational.MINUS_ONE.compareTo(BigInteger.TWO), -1L);
        Assert.assertEquals(Rational.MINUS_ONE.compareTo(BigInteger.TEN), -1L);
        Assert.assertEquals(Rational.ZERO.compareTo(BigInteger.ZERO), 0L);
        Assert.assertEquals(Rational.ZERO.compareTo(BigInteger.ONE), -1L);
        Assert.assertEquals(Rational.ZERO.compareTo(BigInteger.TWO), -1L);
        Assert.assertEquals(Rational.ZERO.compareTo(BigInteger.TEN), -1L);
        Assert.assertEquals(Rational.ONE.compareTo(BigInteger.ZERO), 1L);
        Assert.assertEquals(Rational.ONE.compareTo(BigInteger.ONE), 0L);
        Assert.assertEquals(Rational.ONE.compareTo(BigInteger.TWO), -1L);
        Assert.assertEquals(Rational.ONE.compareTo(BigInteger.TEN), -1L);
        Assert.assertEquals(Rational.TWO.compareTo(BigInteger.ZERO), 1L);
        Assert.assertEquals(Rational.TWO.compareTo(BigInteger.ONE), 1L);
        Assert.assertEquals(Rational.TWO.compareTo(BigInteger.TWO), 0L);
        Assert.assertEquals(Rational.TWO.compareTo(BigInteger.TEN), -1L);
        Assert.assertEquals(Rational.UNDEFINED.compareTo(BigInteger.ZERO), 1L);
        Assert.assertEquals(Rational.UNDEFINED.compareTo(BigInteger.ONE), 1L);
        Assert.assertEquals(Rational.UNDEFINED.compareTo(BigInteger.TWO), 1L);
        Assert.assertEquals(Rational.UNDEFINED.compareTo(BigInteger.TEN), 1L);
        Assert.assertEquals(Rational.PLUS_INFINITY.compareTo(BigInteger.ZERO), 1L);
        Assert.assertEquals(Rational.PLUS_INFINITY.compareTo(BigInteger.ONE), 1L);
        Assert.assertEquals(Rational.PLUS_INFINITY.compareTo(BigInteger.TWO), 1L);
        Assert.assertEquals(Rational.PLUS_INFINITY.compareTo(BigInteger.TEN), 1L);
        Assert.assertEquals(Rational.MINUS_INFINITY.lt(Rational.MINUS_INFINITY), false);
        Assert.assertEquals(Rational.MINUS_ONE.lt(Rational.MINUS_ONE), false);
        Assert.assertEquals(Rational.ZERO.lt(Rational.ZERO), false);
        Assert.assertEquals(Rational.ONE.lt(Rational.ONE), false);
        Assert.assertEquals(Rational.TWO.lt(Rational.TWO), false);
        Assert.assertEquals(Rational.UNDEFINED.lt(Rational.UNDEFINED), false);
        Assert.assertEquals(Rational.PLUS_INFINITY.lt(Rational.PLUS_INFINITY), false);
        Assert.assertEquals(Rational.MINUS_INFINITY.lt(Rational.MINUS_ONE), true);
        Assert.assertEquals(Rational.MINUS_INFINITY.lt(Rational.ZERO), true);
        Assert.assertEquals(Rational.MINUS_INFINITY.lt(Rational.ONE), true);
        Assert.assertEquals(Rational.MINUS_INFINITY.lt(Rational.TWO), true);
        Assert.assertEquals(Rational.MINUS_INFINITY.lt(Rational.UNDEFINED), true);
        Assert.assertEquals(Rational.MINUS_INFINITY.lt(Rational.PLUS_INFINITY), true);
        Assert.assertEquals(Rational.MINUS_ONE.lt(Rational.ZERO), true);
        Assert.assertEquals(Rational.MINUS_ONE.lt(Rational.ONE), true);
        Assert.assertEquals(Rational.MINUS_ONE.lt(Rational.TWO), true);
        Assert.assertEquals(Rational.MINUS_ONE.lt(Rational.UNDEFINED), true);
        Assert.assertEquals(Rational.MINUS_ONE.lt(Rational.PLUS_INFINITY), true);
        Assert.assertEquals(Rational.ZERO.lt(Rational.ONE), true);
        Assert.assertEquals(Rational.ZERO.lt(Rational.TWO), true);
        Assert.assertEquals(Rational.ZERO.lt(Rational.UNDEFINED), true);
        Assert.assertEquals(Rational.ZERO.lt(Rational.PLUS_INFINITY), true);
        Assert.assertEquals(Rational.ONE.lt(Rational.TWO), true);
        Assert.assertEquals(Rational.ONE.lt(Rational.UNDEFINED), true);
        Assert.assertEquals(Rational.ONE.lt(Rational.PLUS_INFINITY), true);
        Assert.assertEquals(Rational.TWO.lt(Rational.UNDEFINED), true);
        Assert.assertEquals(Rational.UNDEFINED.lt(Rational.PLUS_INFINITY), true);
        Assert.assertEquals(Rational.PLUS_INFINITY.lt(Rational.UNDEFINED), false);
        Assert.assertEquals(Rational.PLUS_INFINITY.lt(Rational.TWO), false);
        Assert.assertEquals(Rational.PLUS_INFINITY.lt(Rational.ONE), false);
        Assert.assertEquals(Rational.PLUS_INFINITY.lt(Rational.ZERO), false);
        Assert.assertEquals(Rational.PLUS_INFINITY.lt(Rational.MINUS_ONE), false);
        Assert.assertEquals(Rational.PLUS_INFINITY.lt(Rational.MINUS_INFINITY), false);
        Assert.assertEquals(Rational.UNDEFINED.lt(Rational.TWO), false);
        Assert.assertEquals(Rational.UNDEFINED.lt(Rational.ONE), false);
        Assert.assertEquals(Rational.UNDEFINED.lt(Rational.ZERO), false);
        Assert.assertEquals(Rational.UNDEFINED.lt(Rational.MINUS_ONE), false);
        Assert.assertEquals(Rational.UNDEFINED.lt(Rational.MINUS_INFINITY), false);
        Assert.assertEquals(Rational.TWO.lt(Rational.ONE), false);
        Assert.assertEquals(Rational.TWO.lt(Rational.ZERO), false);
        Assert.assertEquals(Rational.TWO.lt(Rational.MINUS_ONE), false);
        Assert.assertEquals(Rational.TWO.lt(Rational.MINUS_INFINITY), false);
        Assert.assertEquals(Rational.ONE.lt(Rational.ZERO), false);
        Assert.assertEquals(Rational.ONE.lt(Rational.MINUS_ONE), false);
        Assert.assertEquals(Rational.ONE.lt(Rational.MINUS_INFINITY), false);
        Assert.assertEquals(Rational.ZERO.lt(Rational.MINUS_ONE), false);
        Assert.assertEquals(Rational.ZERO.lt(Rational.MINUS_INFINITY), false);
        Assert.assertEquals(Rational.MINUS_ONE.lt(Rational.MINUS_INFINITY), false);
        Assert.assertEquals(Rational.MINUS_INFINITY.le(Rational.MINUS_INFINITY), true);
        Assert.assertEquals(Rational.MINUS_ONE.le(Rational.MINUS_ONE), true);
        Assert.assertEquals(Rational.ZERO.le(Rational.ZERO), true);
        Assert.assertEquals(Rational.ONE.le(Rational.ONE), true);
        Assert.assertEquals(Rational.TWO.le(Rational.TWO), true);
        Assert.assertEquals(Rational.UNDEFINED.le(Rational.UNDEFINED), true);
        Assert.assertEquals(Rational.PLUS_INFINITY.le(Rational.PLUS_INFINITY), true);
        Assert.assertEquals(Rational.MINUS_INFINITY.le(Rational.MINUS_ONE), true);
        Assert.assertEquals(Rational.MINUS_INFINITY.le(Rational.ZERO), true);
        Assert.assertEquals(Rational.MINUS_INFINITY.le(Rational.ONE), true);
        Assert.assertEquals(Rational.MINUS_INFINITY.le(Rational.TWO), true);
        Assert.assertEquals(Rational.MINUS_INFINITY.le(Rational.UNDEFINED), true);
        Assert.assertEquals(Rational.MINUS_INFINITY.le(Rational.PLUS_INFINITY), true);
        Assert.assertEquals(Rational.MINUS_ONE.le(Rational.ZERO), true);
        Assert.assertEquals(Rational.MINUS_ONE.le(Rational.ONE), true);
        Assert.assertEquals(Rational.MINUS_ONE.le(Rational.TWO), true);
        Assert.assertEquals(Rational.MINUS_ONE.le(Rational.UNDEFINED), true);
        Assert.assertEquals(Rational.MINUS_ONE.le(Rational.PLUS_INFINITY), true);
        Assert.assertEquals(Rational.ZERO.le(Rational.ONE), true);
        Assert.assertEquals(Rational.ZERO.le(Rational.TWO), true);
        Assert.assertEquals(Rational.ZERO.le(Rational.UNDEFINED), true);
        Assert.assertEquals(Rational.ZERO.le(Rational.PLUS_INFINITY), true);
        Assert.assertEquals(Rational.ONE.le(Rational.TWO), true);
        Assert.assertEquals(Rational.ONE.le(Rational.UNDEFINED), true);
        Assert.assertEquals(Rational.ONE.le(Rational.PLUS_INFINITY), true);
        Assert.assertEquals(Rational.TWO.le(Rational.UNDEFINED), true);
        Assert.assertEquals(Rational.UNDEFINED.le(Rational.PLUS_INFINITY), true);
        Assert.assertEquals(Rational.PLUS_INFINITY.le(Rational.UNDEFINED), false);
        Assert.assertEquals(Rational.PLUS_INFINITY.le(Rational.TWO), false);
        Assert.assertEquals(Rational.PLUS_INFINITY.le(Rational.ONE), false);
        Assert.assertEquals(Rational.PLUS_INFINITY.le(Rational.ZERO), false);
        Assert.assertEquals(Rational.PLUS_INFINITY.le(Rational.MINUS_ONE), false);
        Assert.assertEquals(Rational.PLUS_INFINITY.le(Rational.MINUS_INFINITY), false);
        Assert.assertEquals(Rational.UNDEFINED.le(Rational.TWO), false);
        Assert.assertEquals(Rational.UNDEFINED.le(Rational.ONE), false);
        Assert.assertEquals(Rational.UNDEFINED.le(Rational.ZERO), false);
        Assert.assertEquals(Rational.UNDEFINED.le(Rational.MINUS_ONE), false);
        Assert.assertEquals(Rational.UNDEFINED.le(Rational.MINUS_INFINITY), false);
        Assert.assertEquals(Rational.TWO.le(Rational.ONE), false);
        Assert.assertEquals(Rational.TWO.le(Rational.ZERO), false);
        Assert.assertEquals(Rational.TWO.le(Rational.MINUS_ONE), false);
        Assert.assertEquals(Rational.TWO.le(Rational.MINUS_INFINITY), false);
        Assert.assertEquals(Rational.ONE.le(Rational.ZERO), false);
        Assert.assertEquals(Rational.ONE.le(Rational.MINUS_ONE), false);
        Assert.assertEquals(Rational.ONE.le(Rational.MINUS_INFINITY), false);
        Assert.assertEquals(Rational.ZERO.le(Rational.MINUS_ONE), false);
        Assert.assertEquals(Rational.ZERO.le(Rational.MINUS_INFINITY), false);
        Assert.assertEquals(Rational.MINUS_ONE.le(Rational.MINUS_INFINITY), false);
    }

    @Test
    public void test_add() {
        Assert.assertEquals(Rational.PLUS_INFINITY.add(Rational.PLUS_INFINITY), Rational.PLUS_INFINITY);
        Assert.assertEquals(Rational.PLUS_INFINITY.add(Rational.ONE), Rational.PLUS_INFINITY);
        Assert.assertEquals(Rational.TWO.add(Rational.PLUS_INFINITY), Rational.PLUS_INFINITY);
        Assert.assertEquals(Rational.PLUS_INFINITY.add(Rational.MINUS_ONE), Rational.PLUS_INFINITY);
        Assert.assertEquals(Rational.MINUS_ONE.add(Rational.PLUS_INFINITY), Rational.PLUS_INFINITY);
    }

    @Test
    public void test_ceil_floor() {
        Assert.assertEquals(Rational.PLUS_INFINITY.ceil(), null);
        Assert.assertEquals(Rational.PLUS_INFINITY.floor(), null);
    }

    @Test
    public void test_negate() {
        Assert.assertEquals(Rational.PLUS_INFINITY.negate(), Rational.MINUS_INFINITY);
        Assert.assertEquals(Rational.MINUS_INFINITY.negate(), Rational.PLUS_INFINITY);
        Assert.assertEquals(Rational.UNDEFINED.negate(), Rational.UNDEFINED);
        Assert.assertEquals(Rational.ZERO.negate(), Rational.ZERO);
        Assert.assertEquals(Rational.ONE.negate(), Rational.MINUS_ONE);
        Assert.assertEquals(Rational.MINUS_ONE.negate(), Rational.ONE);
        Assert.assertEquals(Rational.TWO.negate(), new Rational(-2L));
        Assert.assertEquals(new Rational(-25L, 66L).negate(), new Rational(25L, 66L));
    }

    @Test
    public void test_divide() {
        Assert.assertEquals(Rational.PLUS_INFINITY.divide(Rational.PLUS_INFINITY), Rational.UNDEFINED);
        Assert.assertEquals(Rational.ZERO.divide(Rational.value_of("3/4")), Rational.ZERO);
    }

    @Test
    public void test_mod() {
        Assert.assertEquals(Rational.PLUS_INFINITY.mod(Rational.ONE), Rational.UNDEFINED);
        Assert.assertEquals(new Rational(101L).mod(Rational.TWO), Rational.ONE);
    }

    @Test
    public void test_multiply() {
        Assert.assertEquals(Rational.PLUS_INFINITY.multiply(Rational.ONE), Rational.PLUS_INFINITY);
        Assert.assertEquals(new Rational(101L).multiply(Rational.TWO), new Rational(202L));
    }

    @Test
    public void test_substract() {
        Assert.assertEquals(Rational.PLUS_INFINITY.subtract(Rational.ONE), Rational.PLUS_INFINITY);
        Assert.assertEquals(new Rational(101L).subtract(Rational.TWO), new Rational(99L));
    }

    @Test
    public void test_signum() {
        Assert.assertEquals(Rational.MINUS_INFINITY.signum(), -1L);
        Assert.assertEquals(Rational.MINUS_ONE.signum(), -1L);
        Assert.assertEquals(Rational.ZERO.signum(), 0L);
        Assert.assertEquals(Rational.ONE.signum(), 1L);
        Assert.assertEquals(Rational.TWO.signum(), 1L);
        Assert.assertEquals(Rational.UNDEFINED.signum(), 1L);
        Assert.assertEquals(Rational.PLUS_INFINITY.signum(), 1L);
    }
}

