/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.turing_machine;

import fr.univ_orleans.jdl.turing_machine.Turing_Machine;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TM_Configuration
implements Iterable<Integer> {
    private final Turing_Machine tm;
    private final LinkedList<Integer> tape;
    private int head_position = 0;
    private int state = 0;

    public TM_Configuration(Turing_Machine tm) {
        this.tm = tm;
        this.tape = new LinkedList();
    }

    public TM_Configuration(TM_Configuration conf) {
        this.tm = conf.tm;
        this.head_position = conf.head_position;
        this.state = conf.state;
        this.tape = new LinkedList<Integer>(conf.tape);
    }

    public void add(int symbol) {
        this.tape.add(symbol);
    }

    public int get_head_position() {
        return this.head_position;
    }

    public int get_state() {
        return this.state;
    }

    protected List<Integer> get_tape() {
        this.test_empty();
        return (LinkedList)this.tape.clone();
    }

    public int get_tape_length() {
        this.test_empty();
        return this.tape.size();
    }

    public Turing_Machine get_TM() {
        return this.tm;
    }

    public boolean has_halted() {
        return this.head_position < 0;
    }

    @Override
    public Iterator<Integer> iterator() {
        this.test_empty();
        return this.tape.iterator();
    }

    public void move_head_left() {
        --this.head_position;
    }

    public void move_head_right() {
        ++this.head_position;
        if (this.tape.size() == this.head_position) {
            this.add(0);
        }
    }

    public int read_symbol() {
        this.test_empty();
        return this.tape.get(this.head_position);
    }

    public void set_state(int state) {
        this.state = state;
    }

    private void test_empty() {
        if (this.tape.isEmpty()) {
            this.add(0);
        }
    }

    public String toString() {
        this.test_empty();
        StringBuilder res = new StringBuilder("State: " + this.state + " \tTape: ");
        int i = 0;
        Iterator iterator = this.tape.iterator();
        while (iterator.hasNext()) {
            int s = (Integer)iterator.next();
            res.append(i == this.head_position ? " [" + s + "]" : Integer.valueOf(s));
            ++i;
        }
        return res.append("\t").toString();
    }

    public int write_symbol(int symbol) {
        this.test_empty();
        return this.tape.set(this.head_position, symbol);
    }
}

