/*
 * Decompiled with CFR 0.152.
 */
package fr.univ_orleans.jdl.turing_machine;

import fr.univ_orleans.jdl.turing_machine.E_Undefined_Turing_Transition_Exception;
import fr.univ_orleans.jdl.turing_machine.TM_Configuration;
import fr.univ_orleans.jdl.turing_machine.TM_Transition;
import fr.univ_orleans.jdl.turing_machine.TM_Transition_Abstract;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class Turing_Machine {
    public static final int STATE_INITIAL = 0;
    public static final int SYMBOL_BLANK = 0;
    protected final TM_Configuration configuration;
    private final int state_number;
    private final int symbol_number;
    private final TM_Transition_Abstract[][] tM_Transition_Abstracts;

    public Turing_Machine(int state_number, int symbol_number) {
        this.state_number = state_number;
        this.symbol_number = symbol_number;
        this.tM_Transition_Abstracts = new TM_Transition_Abstract[state_number][symbol_number];
        this.configuration = this.generate_new_configuration();
    }

    public void add_to_tape(int symbol) {
        this.configuration.add(symbol);
    }

    public boolean extract_go_right_from_transition(TM_Transition_Abstract tM_Transition_Abstract) {
        return ((TM_Transition)tM_Transition_Abstract).is_right_move();
    }

    public int extract_state_from_transition(TM_Transition_Abstract tM_Transition_Abstract) {
        return ((TM_Transition)tM_Transition_Abstract).get_state_next();
    }

    public int extract_symbol_from_transition(TM_Transition_Abstract tM_Transition_Abstract) {
        return ((TM_Transition)tM_Transition_Abstract).get_symbol_written();
    }

    public TM_Configuration generate_new_configuration() {
        return new TM_Configuration(this);
    }

    public TM_Configuration get_configuration() {
        return new TM_Configuration(this.configuration);
    }

    public int get_state_current() {
        return this.configuration.get_state();
    }

    public int get_state_number() {
        return this.state_number;
    }

    public int get_symbol_number() {
        return this.symbol_number;
    }

    public List<Integer> get_tape() {
        return this.configuration.get_tape();
    }

    public TM_Transition_Abstract get_transition(int state, int symbol) {
        TM_Transition_Abstract res = this.tM_Transition_Abstracts[state][symbol];
        if (res == null) {
            throw new E_Undefined_Turing_Transition_Exception(state, symbol);
        }
        return res;
    }

    public boolean has_halted() {
        return this.configuration.has_halted();
    }

    public boolean is_transition_defined(int state, int symbol) {
        return this.tM_Transition_Abstracts[state][symbol] != null;
    }

    public void make_transition() {
        if (!this.has_halted()) {
            TM_Transition_Abstract tM_Transition_Abstract = this.get_transition(this.configuration.get_state(), this.configuration.read_symbol());
            try {
                tM_Transition_Abstract.make_transition(this.configuration);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void set_transition(int state_current, int symbol_read, int state_next, int symbol_written, boolean is_right_move) {
        this.set_transition(state_current, symbol_read, new TM_Transition(state_next, symbol_written, is_right_move));
    }

    protected void set_transition(int state_current, int symbol_read, TM_Transition_Abstract tM_Transition_Abstract) {
        this.tM_Transition_Abstracts[state_current][symbol_read] = tM_Transition_Abstract;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("sta \\ sym |");
        int i = 0;
        while (i < this.symbol_number) {
            pw.printf("%6d    |", i);
            ++i;
        }
        pw.println();
        int state = 0;
        while (state < this.state_number) {
            pw.printf(" %6d   |", state);
            int symbol = 0;
            while (symbol < this.symbol_number) {
                TM_Transition_Abstract tM_Transition_Abstract = this.get_transition(state, symbol);
                if (tM_Transition_Abstract == null) {
                    pw.print("    -     |");
                } else {
                    pw.printf("%9s | ", tM_Transition_Abstract);
                }
                ++symbol;
            }
            pw.println();
            ++state;
        }
        return sw.toString();
    }
}

